/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.service.DLFileEntryMetadataLocalServiceUtil;
import com.liferay.document.library.kernel.util.DLProcessor;
import com.liferay.document.library.kernel.util.RawMetadataProcessor;
import com.liferay.dynamic.data.mapping.kernel.DDMStructureManagerUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.metadata.RawMetadataProcessorUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.util.PropsValues;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

@DoPrivileged
public class RawMetadataProcessorImpl
implements DLProcessor,
RawMetadataProcessor {
    private static final Log _log = LogFactoryUtil.getLog(RawMetadataProcessorImpl.class);

    public void afterPropertiesSet() {
    }

    public void cleanUp(FileEntry fileEntry) {
    }

    public void cleanUp(FileVersion fileVersion) {
    }

    public void copy(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
    }

    public void exportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) {
    }

    public void generateMetadata(FileVersion fileVersion) {
        long fileEntryMetadataCount = DLFileEntryMetadataLocalServiceUtil.getFileVersionFileEntryMetadatasCount((long)fileVersion.getFileVersionId());
        if (fileEntryMetadataCount == 0L) {
            this.trigger(fileVersion);
        }
    }

    public String getType() {
        return "RawMetadataProcessor";
    }

    public void importGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) {
    }

    public boolean isSupported(FileVersion fileVersion) {
        return this.isSupported(fileVersion.getMimeType());
    }

    public boolean isSupported(String mimeType) {
        return !ArrayUtil.contains((Object[])PropsValues.DL_FILE_ENTRY_RAW_METADATA_PROCESSOR_EXCLUDED_MIME_TYPES, (Object)mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMetadata(FileVersion fileVersion) throws PortalException {
        Map rawMetadataMap = null;
        if (fileVersion instanceof LiferayFileVersion) {
            try {
                LiferayFileVersion liferayFileVersion = (LiferayFileVersion)fileVersion;
                File file = liferayFileVersion.getFile(false);
                rawMetadataMap = RawMetadataProcessorUtil.getRawMetadataMap((String)fileVersion.getExtension(), (String)fileVersion.getMimeType(), (File)file);
            }
            catch (UnsupportedOperationException liferayFileVersion) {
                // empty catch block
            }
        }
        if (rawMetadataMap == null) {
            InputStream inputStream;
            block8: {
                block9: {
                    inputStream = null;
                    try {
                        inputStream = fileVersion.getContentStream(false);
                        if (inputStream != null) break block8;
                        if (!_log.isWarnEnabled()) break block9;
                        _log.warn((Object)("No metadata is available for file version " + fileVersion.getFileVersionId()));
                    }
                    catch (Throwable throwable) {
                        StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                        throw throwable;
                    }
                }
                StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                return;
            }
            rawMetadataMap = RawMetadataProcessorUtil.getRawMetadataMap((String)fileVersion.getExtension(), (String)fileVersion.getMimeType(), (InputStream)inputStream);
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
        }
        List ddmStructures = DDMStructureManagerUtil.getClassStructures((long)fileVersion.getCompanyId(), (long)PortalUtil.getClassNameId(RawMetadataProcessor.class), (int)-1, (int)-1);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(fileVersion.getGroupId());
        serviceContext.setUserId(fileVersion.getUserId());
        DLFileEntryMetadataLocalServiceUtil.updateFileEntryMetadata((long)fileVersion.getCompanyId(), (List)ddmStructures, (long)fileVersion.getFileEntryId(), (long)fileVersion.getFileVersionId(), (Map)rawMetadataMap, (ServiceContext)serviceContext);
        FileEntry fileEntry = fileVersion.getFileEntry();
        if (fileEntry instanceof LiferayFileEntry) {
            Indexer indexer = IndexerRegistryUtil.getIndexer((String)DLFileEntryConstants.getClassName());
            LiferayFileEntry liferayFileEntry = (LiferayFileEntry)fileEntry;
            indexer.reindex((Object)liferayFileEntry.getDLFileEntry());
        }
    }

    public void trigger(FileVersion fileVersion) {
        this.trigger(fileVersion, fileVersion);
    }

    public void trigger(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        MessageBusUtil.sendMessage((String)"liferay/document_library_raw_metadata_processor", (Object)destinationFileVersion);
    }
}

