/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.image.ImageToolImpl;
import com.liferay.portal.kernel.image.ImageTool;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;

public class LiferayPDFBoxConverter {
    private final int _dpi;
    private final String _extension;
    private final boolean _generatePreview;
    private final boolean _generateThumbnail;
    private final int _height;
    private final File _inputFile;
    private final File[] _previewFiles;
    private final String _thumbnailExtension;
    private final File _thumbnailFile;
    private final int _width;

    public LiferayPDFBoxConverter(File inputFile, File thumbnailFile, File[] previewFiles, String extension, String thumbnailExtension, int dpi, int height, int width, boolean generatePreview, boolean generateThumbnail) {
        this._inputFile = inputFile;
        this._thumbnailFile = thumbnailFile;
        this._previewFiles = previewFiles;
        this._extension = extension;
        this._thumbnailExtension = thumbnailExtension;
        this._dpi = dpi;
        this._height = height;
        this._width = width;
        this._generatePreview = generatePreview;
        this._generateThumbnail = generateThumbnail;
    }

    public void generateImagesPB() throws Exception {
        try (PDDocument pdDocument = PDDocument.load((File)this._inputFile);){
            PDFRenderer pdfRenderer = new PDFRenderer(pdDocument);
            PDPageTree pdPageTree = pdDocument.getPages();
            int count = pdPageTree.getCount();
            for (int i = 0; i < count; ++i) {
                if (this._generateThumbnail && i == 0) {
                    this._generateImagesPB(pdfRenderer, i, this._thumbnailFile, this._thumbnailExtension);
                }
                if (!this._generatePreview) {
                    break;
                }
                this._generateImagesPB(pdfRenderer, i, this._previewFiles[i], this._extension);
            }
        }
    }

    private void _generateImagesPB(PDFRenderer pdfRenderer, int pageIndex, File outputFile, String extension) throws Exception {
        RenderedImage renderedImage = pdfRenderer.renderImageWithDPI(pageIndex, (float)this._dpi, ImageType.RGB);
        ImageTool imageTool = ImageToolImpl.getInstance();
        renderedImage = this._height != 0 ? imageTool.scale(renderedImage, this._width, this._height) : imageTool.scale(renderedImage, this._width);
        outputFile.createNewFile();
        ImageIO.write(renderedImage, extension, outputFile);
    }
}

