/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class UpgradeResourcePermission
extends UpgradeProcess {
    protected void createIndex() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.runSQLTemplateString("create index IX_D5F1E2A2 on ResourcePermission (name[$COLUMN_LENGTH:255$])", false, false);
        }
    }

    protected void doUpgrade() throws Exception {
        this.createIndex();
        this.upgradeResourcePermissions();
    }

    protected void upgradeResourcePermissions() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.runSQL("update ResourcePermission set viewActionId = [$FALSE$] where MOD(actionIds, 2) = 0");
            this.runSQL("update ResourcePermission set viewActionId = [$TRUE$] where MOD(actionIds, 2) = 1");
            ArrayList<String> stringPrimKeys = new ArrayList<String>();
            try (PreparedStatement ps = this.connection.prepareStatement("select distinct primKey from ResourcePermission");
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String primKey = rs.getString("primKey");
                    long primKeyId = GetterUtil.getLong((String)primKey);
                    if (primKeyId > 0L) continue;
                    stringPrimKeys.add(primKey);
                }
            }
            if (stringPrimKeys.isEmpty()) {
                this.runSQL("update ResourcePermission set primKeyId = CAST_LONG(primKey)");
                return;
            }
            StringBundler sb = new StringBundler(stringPrimKeys.size() + 1);
            sb.append("in (?");
            for (int i = 1; i < stringPrimKeys.size(); ++i) {
                sb.append(", ?");
            }
            sb.append(")");
            String inClause = sb.toString();
            this._updatePrimKeyIds("update ResourcePermission set primKeyId = 0 where primKey " + inClause, stringPrimKeys);
            this._updatePrimKeyIds("update ResourcePermission set primKeyId = CAST_LONG(primKey) where primKey not " + inClause, stringPrimKeys);
        }
    }

    private void _updatePrimKeyIds(String sql, List<String> primKeys) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement(SQLTransformer.transform(sql));){
            for (int i = 0; i < primKeys.size(); ++i) {
                String primKey = primKeys.get(i);
                ps.setString(i + 1, primKey);
            }
            ps.executeUpdate();
        }
    }
}

