/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.transaction;

import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvoker;
import com.liferay.portal.spring.transaction.CurrentPlatformTransactionManagerUtil;
import com.liferay.portal.spring.transaction.TransactionAttributeAdapter;
import com.liferay.portal.spring.transaction.TransactionAttributeBuilder;
import com.liferay.portal.spring.transaction.TransactionExecutor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.transaction.PlatformTransactionManager;

public class TransactionInvokerImpl
implements TransactionInvoker {
    private static PlatformTransactionManager _platformTransactionManager;
    private static TransactionExecutor _transactionExecutor;

    public <T> T invoke(TransactionConfig transactionConfig, Callable<T> callable) throws Throwable {
        PlatformTransactionManager platformTransactionManager = CurrentPlatformTransactionManagerUtil.getCurrentPlatformTransactionManager();
        if (platformTransactionManager == null) {
            platformTransactionManager = _platformTransactionManager;
        }
        return (T)_transactionExecutor.execute(platformTransactionManager, new TransactionAttributeAdapter(TransactionAttributeBuilder.build(true, transactionConfig.getIsolation(), transactionConfig.getPropagation(), transactionConfig.isReadOnly(), transactionConfig.getTimeout(), transactionConfig.getRollbackForClasses(), transactionConfig.getRollbackForClassNames(), transactionConfig.getNoRollbackForClasses(), transactionConfig.getNoRollbackForClassNames())), new CallableMethodInvocation(callable));
    }

    public void setPlatformTransactionManager(PlatformTransactionManager platformTransactionManager) {
        _platformTransactionManager = platformTransactionManager;
    }

    public void setTransactionExecutor(TransactionExecutor transactionExecutor) {
        _transactionExecutor = transactionExecutor;
    }

    private static class CallableMethodInvocation
    implements MethodInvocation {
        private final Callable<?> _callable;

        public Object[] getArguments() {
            throw new UnsupportedOperationException();
        }

        public Method getMethod() {
            throw new UnsupportedOperationException();
        }

        public AccessibleObject getStaticPart() {
            throw new UnsupportedOperationException();
        }

        public Object getThis() {
            throw new UnsupportedOperationException();
        }

        public Object proceed() throws Throwable {
            return this._callable.call();
        }

        private CallableMethodInvocation(Callable<?> callable) {
            this._callable = callable;
        }
    }
}

