/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.SingleVMPoolUtil;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.servlet.RequestDispatcherUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.minifier.MinifierUtil;
import com.liferay.portal.servlet.filters.dynamiccss.DynamicCSSUtil;
import com.liferay.portal.util.AggregateUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ComboServlet
extends HttpServlet {
    private static final String _CSS_EXTENSION = "css";
    private static final String _CSS_MINIFIED_SUFFIX = "-min.css";
    private static final FileContentBag _EMPTY_FILE_CONTENT_BAG = new FileContentBag(new byte[0], 0L);
    private static final String _JAVASCRIPT_MINIFIED_SUFFIX = "-min.js";
    private static final Log _log = LogFactoryUtil.getLog(ComboServlet.class);
    private static final PortalCache<String, byte[][]> _bytesArrayPortalCache = SingleVMPoolUtil.getPortalCache((String)ComboServlet.class.getName());
    private static final PortalCache<String, FileContentBag> _fileContentBagPortalCache = SingleVMPoolUtil.getPortalCache((String)FileContentBag.class.getName());
    private final Set<String> _protectedParameters = SetUtil.fromArray((Object[])new String[]{"b", "browserId", "minifierType", "languageId", "t", "themeId", "zx"});

    public static void clearCache() {
        _bytesArrayPortalCache.removeAll();
        _fileContentBagPortalCache.removeAll();
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            this.doService(request, response);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            PortalUtil.sendError((int)500, (Exception)e, (HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    protected static String getModulePortletId(String modulePath) {
        int index = modulePath.indexOf(58);
        if (index > 0) {
            return modulePath.substring(0, index);
        }
        return "90";
    }

    protected static String getResourcePath(String modulePath) {
        int index = modulePath.indexOf(58);
        if (index > 0) {
            return HttpUtil.removePathParameters((String)modulePath.substring(index + 1));
        }
        return HttpUtil.removePathParameters((String)modulePath);
    }

    /*
     * WARNING - void declaration
     */
    protected void doService(HttpServletRequest request, HttpServletResponse response) throws Exception {
        void var11_26;
        void var8_13;
        LinkedHashSet<String> modulePathsSet = new LinkedHashSet<String>();
        Map parameterMap = HttpUtil.getParameterMap((String)request.getQueryString());
        Enumeration enu = Collections.enumeration(parameterMap.keySet());
        while (enu.hasMoreElements()) {
            String pathProxy;
            ServletContext servletContext;
            String string;
            String name = (String)enu.nextElement();
            if (this._protectedParameters.contains(name)) continue;
            if ((name = HttpUtil.decodePath((String)name)).startsWith(string = (servletContext = this.getServletContext()).getContextPath())) {
                name = name.replaceFirst(string, "");
            }
            if (name.startsWith(pathProxy = PortalUtil.getPathProxy())) {
                name = name.replaceFirst(pathProxy, "");
            }
            modulePathsSet.add(name);
        }
        if (modulePathsSet.isEmpty()) {
            PortalUtil.sendError((int)404, (Exception)((Object)new NoSuchLayoutException("Query string translates to an empty module paths set")), (HttpServletRequest)request, (HttpServletResponse)response);
            return;
        }
        Object[] modulePaths = modulePathsSet.toArray(new String[modulePathsSet.size()]);
        String extension = "";
        for (String string : modulePaths) {
            String pathExtension = this._getModulePathExtension(string);
            if (Validator.isNull((String)pathExtension)) continue;
            if (Validator.isNull((String)extension)) {
                extension = pathExtension;
            }
            if (extension.equals(pathExtension)) continue;
            response.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
            response.setStatus(400);
            return;
        }
        String string = ParamUtil.getString((HttpServletRequest)request, (String)"minifierType");
        if (Validator.isNull((String)string)) {
            String string2 = "js";
            if (StringUtil.equalsIgnoreCase((String)extension, (String)_CSS_EXTENSION)) {
                String string3 = _CSS_EXTENSION;
            }
        }
        if (!var8_13.equals(_CSS_EXTENSION) && !var8_13.equals("js")) {
            String string4 = "js";
        }
        String modulePathsString = null;
        Object bytesArray = null;
        if (!PropsValues.COMBO_CHECK_TIMESTAMP) {
            modulePathsString = Arrays.toString(modulePaths);
            modulePathsString = modulePathsString + "#" + LanguageUtil.getLanguageId((HttpServletRequest)request);
            bytesArray = (byte[][])_bytesArrayPortalCache.get((Serializable)((Object)modulePathsString));
        }
        if (bytesArray == null) {
            void var11_23;
            bytesArray = new byte[modulePaths.length][];
            boolean bl = false;
            while (var11_23 < modulePaths.length) {
                Object modulePath = modulePaths[var11_23];
                if (!this.validateModuleExtension((String)modulePath)) {
                    response.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
                    response.setStatus(400);
                    return;
                }
                byte[] bytes = new byte[]{};
                if (Validator.isNotNull((String)modulePath)) {
                    void var8_15;
                    RequestDispatcher requestDispatcher = this.getResourceRequestDispatcher(request, response, (String)modulePath);
                    if (requestDispatcher == null) {
                        response.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
                        response.setStatus(404);
                        return;
                    }
                    bytes = this.getResourceContent(requestDispatcher, request, response, (String)modulePath, (String)var8_15);
                }
                bytesArray[var11_23] = bytes;
                ++var11_23;
            }
            if (modulePathsString != null && !PropsValues.COMBO_CHECK_TIMESTAMP) {
                _bytesArrayPortalCache.put((Serializable)((Object)modulePathsString), bytesArray);
            }
        }
        String string5 = "text/javascript";
        if (StringUtil.equalsIgnoreCase((String)extension, (String)_CSS_EXTENSION)) {
            String string6 = "text/css";
        }
        response.setContentType((String)var11_26);
        ServletResponseUtil.write((HttpServletResponse)response, (byte[][])bytesArray);
    }

    protected byte[] getResourceContent(RequestDispatcher requestDispatcher, HttpServletRequest request, HttpServletResponse response, String modulePath, String minifierType) throws Exception {
        String portletId;
        Portlet portlet;
        String resourcePath = ComboServlet.getResourcePath(modulePath);
        if (!resourcePath.startsWith((portlet = PortletLocalServiceUtil.getPortletById((String)(portletId = ComboServlet.getModulePortletId(modulePath)))).getContextPath())) {
            resourcePath = portlet.getContextPath() + resourcePath;
        }
        StringBundler sb = new StringBundler(5);
        sb.append(resourcePath);
        sb.append("?");
        sb.append(minifierType);
        sb.append("&languageId=");
        sb.append(ParamUtil.getString((HttpServletRequest)request, (String)"languageId"));
        String fileContentKey = sb.toString();
        FileContentBag fileContentBag = (FileContentBag)_fileContentBagPortalCache.get((Serializable)((Object)fileContentKey));
        if (fileContentBag != null && !PropsValues.COMBO_CHECK_TIMESTAMP) {
            return fileContentBag._fileContent;
        }
        if (fileContentBag != null && PropsValues.COMBO_CHECK_TIMESTAMP) {
            long elapsedTime = System.currentTimeMillis() - fileContentBag._lastModified;
            if (requestDispatcher != null && elapsedTime <= PropsValues.COMBO_CHECK_TIMESTAMP_INTERVAL && RequestDispatcherUtil.getLastModifiedTime((RequestDispatcher)requestDispatcher, (HttpServletRequest)request, (HttpServletResponse)response) == fileContentBag._lastModified) {
                return fileContentBag._fileContent;
            }
            _fileContentBagPortalCache.remove((Serializable)((Object)fileContentKey));
        }
        if (requestDispatcher == null) {
            fileContentBag = _EMPTY_FILE_CONTENT_BAG;
        } else {
            ObjectValuePair objectValuePair = RequestDispatcherUtil.getContentAndLastModifiedTime((RequestDispatcher)requestDispatcher, (HttpServletRequest)request, (HttpServletResponse)response);
            String stringFileContent = (String)objectValuePair.getKey();
            if (!StringUtil.endsWith((String)resourcePath, (String)_CSS_MINIFIED_SUFFIX) && !StringUtil.endsWith((String)resourcePath, (String)_JAVASCRIPT_MINIFIED_SUFFIX)) {
                if (minifierType.equals(_CSS_EXTENSION)) {
                    try {
                        stringFileContent = DynamicCSSUtil.replaceToken(this.getServletContext(), request, stringFileContent);
                    }
                    catch (Exception e) {
                        _log.error((Object)("Unable to replace tokens in CSS " + resourcePath), (Throwable)e);
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)stringFileContent);
                        }
                        response.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
                    }
                    String baseURL = "";
                    int slashIndex = resourcePath.lastIndexOf(47);
                    if (slashIndex != -1) {
                        baseURL = resourcePath.substring(0, slashIndex + 1);
                    }
                    stringFileContent = AggregateUtil.updateRelativeURLs(stringFileContent, baseURL);
                    stringFileContent = MinifierUtil.minifyCss(stringFileContent);
                } else if (minifierType.equals("js")) {
                    stringFileContent = MinifierUtil.minifyJavaScript(resourcePath, stringFileContent);
                    stringFileContent = stringFileContent.concat("\n");
                }
            }
            fileContentBag = new FileContentBag(stringFileContent.getBytes("UTF-8"), (Long)objectValuePair.getValue());
        }
        if (PropsValues.COMBO_CHECK_TIMESTAMP) {
            int timeToLive = (int)(PropsValues.COMBO_CHECK_TIMESTAMP_INTERVAL / 1000L);
            _fileContentBagPortalCache.put((Serializable)((Object)fileContentKey), (Object)fileContentBag, timeToLive);
        }
        return fileContentBag._fileContent;
    }

    protected RequestDispatcher getResourceRequestDispatcher(HttpServletRequest request, HttpServletResponse response, String modulePath) throws Exception {
        String portletId = ComboServlet.getModulePortletId(modulePath);
        Portlet portlet = PortletLocalServiceUtil.getPortletById((String)portletId);
        if (portlet == null || portlet.isUndeployedPortlet()) {
            return null;
        }
        PortletApp portletApp = portlet.getPortletApp();
        ServletContext servletContext = portletApp.getServletContext();
        String resourcePath = ComboServlet.getResourcePath(modulePath);
        if (!PortalUtil.isValidResourceId((String)resourcePath)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Invalid resource " + request.getRequestURL() + "?" + request.getQueryString()));
            }
            return null;
        }
        return servletContext.getRequestDispatcher(resourcePath);
    }

    protected boolean validateModuleExtension(String moduleName) throws Exception {
        String[] fileExtensions;
        int index = (moduleName = ComboServlet.getResourcePath(moduleName)).indexOf(63);
        if (index != -1) {
            moduleName = moduleName.substring(0, index);
        }
        boolean validModuleExtension = false;
        for (String fileExtension : fileExtensions = PrefsPropsUtil.getStringArray("combo.allowed.file.extensions", ",")) {
            if (!"*".equals(fileExtension) && !StringUtil.endsWith((String)moduleName, (String)fileExtension)) continue;
            validModuleExtension = true;
            break;
        }
        return validModuleExtension;
    }

    private String _getModulePathExtension(String modulePath) {
        String resourcePath = ComboServlet.getResourcePath(modulePath);
        int index = resourcePath.indexOf(63);
        if (index != -1) {
            resourcePath = resourcePath.substring(0, index);
        }
        return FileUtil.getExtension((String)resourcePath);
    }

    private static class FileContentBag
    implements Serializable {
        private final byte[] _fileContent;
        private final long _lastModified;

        public FileContentBag(byte[] fileContent, long lastModifiedTime) {
            this._fileContent = fileContent;
            this._lastModified = lastModifiedTime;
        }
    }
}

