/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.exportimport.kernel.staging.LayoutStagingUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetStagingHandler;
import com.liferay.portal.kernel.util.ClassLoaderUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portlet.exportimport.staging.StagingAdvicesThreadLocal;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class LayoutSetLocalServiceStagingAdvice
implements MethodInterceptor {
    private static final Log _log = LogFactoryUtil.getLog(LayoutSetLocalServiceStagingAdvice.class);

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        List list;
        List<LayoutSet> returnValue = methodInvocation.proceed();
        if (!StagingAdvicesThreadLocal.isEnabled()) {
            return returnValue;
        }
        if (returnValue instanceof LayoutSet) {
            return this.wrapLayoutSet((LayoutSet)returnValue);
        }
        if (returnValue instanceof List && !(list = (List)returnValue).isEmpty() && list.get(0) instanceof LayoutSet) {
            returnValue = this.wrapLayoutSets(returnValue);
        }
        return returnValue;
    }

    protected LayoutSet wrapLayoutSet(LayoutSet layoutSet) {
        try {
            if (!LayoutStagingUtil.isBranchingLayoutSet((Group)layoutSet.getGroup(), (boolean)layoutSet.getPrivateLayout())) {
                return layoutSet;
            }
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return layoutSet;
        }
        return (LayoutSet)ProxyUtil.newProxyInstance((ClassLoader)ClassLoaderUtil.getPortalClassLoader(), (Class[])new Class[]{LayoutSet.class}, (InvocationHandler)new LayoutSetStagingHandler(layoutSet));
    }

    protected List<LayoutSet> wrapLayoutSets(List<LayoutSet> layoutSets) {
        if (layoutSets.isEmpty()) {
            return layoutSets;
        }
        ArrayList<LayoutSet> wrappedLayoutSets = new ArrayList<LayoutSet>(layoutSets.size());
        for (LayoutSet layoutSet : layoutSets) {
            wrappedLayoutSets.add(this.wrapLayoutSet(layoutSet));
        }
        return wrappedLayoutSets;
    }
}

