/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.sql.transformer;

import com.liferay.portal.dao.sql.transformer.SQLTransformer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.function.Function;

public class DefaultSQLTransformer
implements SQLTransformer {
    private static final Log _log = LogFactoryUtil.getLog(DefaultSQLTransformer.class);
    private final Function<String, String>[] _functions;

    public DefaultSQLTransformer(Function<String, String>[] functions) {
        this._functions = functions;
    }

    @Override
    public String transform(String sql) {
        if (this._functions == null || sql == null) {
            return sql;
        }
        String transformedSQL = sql;
        for (Function<String, String> function : this._functions) {
            transformedSQL = function.apply(transformedSQL);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Original SQL: " + sql));
            _log.debug((Object)("Transformed SQL: " + transformedSQL));
        }
        return transformedSQL;
    }
}

