/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet.filters.invoker;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.DirectCallFilter;
import com.liferay.portal.kernel.servlet.LiferayFilter;
import com.liferay.portal.kernel.servlet.TryFilter;
import com.liferay.portal.kernel.servlet.TryFinallyFilter;
import com.liferay.portal.kernel.servlet.WrapHttpServletRequestFilter;
import com.liferay.portal.kernel.servlet.WrapHttpServletResponseFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class InvokerFilterChain
implements FilterChain {
    private static final Log _log = LogFactoryUtil.getLog(InvokerFilterChain.class);
    private ClassLoader _contextClassLoader;
    private final FilterChain _filterChain;
    private List<Filter> _filters;
    private int _index;

    public InvokerFilterChain(FilterChain filterChain) {
        this._filterChain = filterChain;
    }

    public void addFilter(Filter filter) {
        if (this._filters == null) {
            this._filters = new ArrayList<Filter>();
        }
        this._filters.add(filter);
    }

    public InvokerFilterChain clone(FilterChain filterChain) {
        InvokerFilterChain invokerFilterChain = new InvokerFilterChain(filterChain);
        invokerFilterChain._filters = this._filters;
        return invokerFilterChain;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        if (this._filters != null) {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            while (this._index < this._filters.size()) {
                LiferayFilter liferayFilter;
                Filter filter;
                if (!(!((filter = this._filters.get(this._index++)) instanceof LiferayFilter) || (liferayFilter = (LiferayFilter)filter).isFilterEnabled() && liferayFilter.isFilterEnabled(request, response))) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug("Skip disabled filter " + filter.getClass());
                    continue;
                }
                if (filter instanceof DirectCallFilter) {
                    try {
                        this.processDirectCallFilter(filter, request, response);
                    }
                    catch (IOException ioe) {
                        throw ioe;
                    }
                    catch (RuntimeException re) {
                        throw re;
                    }
                    catch (ServletException se) {
                        throw se;
                    }
                    catch (Exception e) {
                        throw new ServletException((Throwable)e);
                    }
                } else {
                    this.processDoFilter(filter, (ServletRequest)request, (ServletResponse)response);
                }
                return;
            }
        }
        this._filterChain.doFilter(servletRequest, servletResponse);
    }

    public void setContextClassLoader(ClassLoader contextClassLoader) {
        this._contextClassLoader = contextClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDirectCallFilter(Filter filter, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (filter instanceof WrapHttpServletRequestFilter) {
            if (_log.isDebugEnabled()) {
                _log.debug("Wrap response with filter " + filter.getClass());
            }
            WrapHttpServletRequestFilter wrapHttpServletRequestFilter = (WrapHttpServletRequestFilter)filter;
            request = wrapHttpServletRequestFilter.getWrappedHttpServletRequest(request, response);
        }
        if (filter instanceof WrapHttpServletResponseFilter) {
            if (_log.isDebugEnabled()) {
                _log.debug("Wrap request with filter " + filter.getClass());
            }
            WrapHttpServletResponseFilter wrapHttpServletResponseFilter = (WrapHttpServletResponseFilter)filter;
            response = wrapHttpServletResponseFilter.getWrappedHttpServletResponse(request, response);
        }
        if (filter instanceof TryFinallyFilter) {
            TryFinallyFilter tryFinallyFilter = (TryFinallyFilter)filter;
            Object object = null;
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug("Invoke try for filter " + filter.getClass());
                }
                object = tryFinallyFilter.doFilterTry(request, response);
                this.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            finally {
                if (_log.isDebugEnabled()) {
                    _log.debug("Invoke finally for filter " + filter.getClass());
                }
                tryFinallyFilter.doFilterFinally(request, response, object);
            }
        } else if (filter instanceof TryFilter) {
            TryFilter tryFilter = (TryFilter)filter;
            if (_log.isDebugEnabled()) {
                _log.debug("Invoke try for filter " + filter.getClass());
            }
            tryFilter.doFilterTry(request, response);
            this.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            this.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDoFilter(Filter filter, ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this._contextClassLoader);
        try {
            filter.doFilter(servletRequest, servletResponse, (FilterChain)this);
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }
}

