/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.concurrent;

import com.liferay.portal.kernel.util.StringBundler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ConcurrentLFUCache<K, V> {
    private final Map<K, ValueWrapper> _cache = new HashMap<K, ValueWrapper>();
    private final EntryComparator _entryComparator = new EntryComparator();
    private final AtomicLong _evictCount = new AtomicLong();
    private final int _expectedSize;
    private final AtomicLong _hitCount = new AtomicLong();
    private final int _maxSize;
    private final AtomicLong _missCount = new AtomicLong();
    private final AtomicLong _putCount = new AtomicLong();
    private final Lock _readLock;
    private final ReentrantReadWriteLock _readWriteLock = new ReentrantReadWriteLock();
    private final Lock _writeLock;

    public ConcurrentLFUCache(int maxSize) {
        this(maxSize, 0.75f);
    }

    public ConcurrentLFUCache(int maxSize, float loadFactor) {
        if (maxSize <= 0 || loadFactor <= 0.0f || loadFactor >= 1.0f) {
            throw new IllegalArgumentException();
        }
        this._maxSize = maxSize;
        this._expectedSize = (int)((float)maxSize * loadFactor);
        if (this._expectedSize == 0) {
            throw new IllegalArgumentException("maxSize and loadFactor are too small");
        }
        this._readLock = this._readWriteLock.readLock();
        this._writeLock = this._readWriteLock.writeLock();
    }

    public void clear() {
        this._writeLock.lock();
        try {
            this._cache.clear();
        }
        finally {
            this._writeLock.unlock();
        }
    }

    public long evictCount() {
        return this._evictCount.get();
    }

    public int expectedSize() {
        return this._expectedSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        this._readLock.lock();
        try {
            ValueWrapper valueWrapper = this._cache.get(key);
            if (valueWrapper != null) {
                valueWrapper._hitCount.getAndIncrement();
                this._hitCount.getAndIncrement();
                Object object = valueWrapper._value;
                return (V)object;
            }
        }
        finally {
            this._readLock.unlock();
        }
        this._missCount.getAndIncrement();
        return null;
    }

    public long hitCount() {
        return this._hitCount.get();
    }

    public int maxSize() {
        return this._maxSize;
    }

    public long missCount() {
        return this._missCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        ValueWrapper valueWrapper = new ValueWrapper(value);
        this._writeLock.lock();
        try {
            if (!this._cache.containsKey(key) && this._cache.size() >= this._maxSize) {
                this._cleanUp();
            }
            this._cache.put(key, valueWrapper);
        }
        finally {
            this._writeLock.unlock();
        }
        this._putCount.getAndIncrement();
    }

    public long putCount() {
        return this._putCount.get();
    }

    public int size() {
        this._readLock.lock();
        try {
            int n = this._cache.size();
            return n;
        }
        finally {
            this._readLock.unlock();
        }
    }

    public String toString() {
        StringBundler sb = new StringBundler(15);
        sb.append("{evictCount=");
        sb.append(this._evictCount.get());
        sb.append(", expectedSize=");
        sb.append(this._expectedSize);
        sb.append(", hitCount=");
        sb.append(this._hitCount.get());
        sb.append(", maxSize=");
        sb.append(this._maxSize);
        sb.append(", missCount=");
        sb.append(this._missCount.get());
        sb.append(", putCount=");
        sb.append(this._putCount.get());
        sb.append(", size=");
        sb.append(this.size());
        sb.append("}");
        return sb.toString();
    }

    protected void onRemove(K key, V value) {
    }

    private void _cleanUp() {
        ArrayList<Map.Entry<K, ValueWrapper>> valueWrappers = new ArrayList<Map.Entry<K, ValueWrapper>>(this._cache.entrySet());
        Collections.sort(valueWrappers, this._entryComparator);
        int cleanUpSize = this._cache.size() - this._expectedSize;
        this._evictCount.getAndAdd(cleanUpSize);
        Iterator itr = valueWrappers.iterator();
        while (cleanUpSize-- > 0 && itr.hasNext()) {
            Map.Entry entry = (Map.Entry)itr.next();
            Object key = entry.getKey();
            Object value = ((ValueWrapper)entry.getValue())._value;
            this._cache.remove(key);
            this.onRemove(key, value);
            itr.remove();
        }
    }

    private class ValueWrapper {
        private final AtomicLong _hitCount = new AtomicLong();
        private final V _value;

        public ValueWrapper(V v) {
            this._value = v;
        }
    }

    private class EntryComparator
    implements Comparator<Map.Entry<K, ValueWrapper>> {
        private EntryComparator() {
        }

        @Override
        public int compare(Map.Entry<K, ValueWrapper> entry1, Map.Entry<K, ValueWrapper> entry2) {
            ValueWrapper valueWrapper1 = entry1.getValue();
            ValueWrapper valueWrapper2 = entry2.getValue();
            long hitCount1 = valueWrapper1._hitCount.get();
            long hitCount2 = valueWrapper2._hitCount.get();
            return (int)(hitCount1 - hitCount2);
        }
    }
}

