/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cluster;

import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.io.Deserializer;
import com.liferay.portal.kernel.io.Serializer;
import com.liferay.portal.kernel.util.Base64;
import java.nio.ByteBuffer;

public class AddressSerializerUtil {
    public static Address deserialize(String serializedAddress) {
        byte[] bytes = Base64.decode(serializedAddress);
        Deserializer deserializer = new Deserializer(ByteBuffer.wrap(bytes));
        try {
            return (Address)deserializer.readObject();
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Unable to deserialize address " + serializedAddress, cnfe);
        }
    }

    public static String serialize(Address address) {
        Serializer serializer = new Serializer();
        serializer.writeObject(address);
        ByteBuffer byteBuffer = serializer.toByteBuffer();
        return Base64.encode(byteBuffer.array());
    }
}

