@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  portal-tools-service-builder startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Add default JVM options here. You can also use JAVA_OPTS and PORTAL_TOOLS_SERVICE_BUILDER_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto init

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto init

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:init
@rem Get command-line arguments, handling Windows variants

if not "%OS%" == "Windows_NT" goto win9xME_args

:win9xME_args
@rem Slurp the command line arguments.
set CMD_LINE_ARGS=
set _SKIP=2

:win9xME_args_slurp
if "x%~1" == "x" goto execute

set CMD_LINE_ARGS=%*

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\com.liferay.portal.tools.service.builder-1.0.155.jar;%APP_HOME%\lib\qdox-1.12.1.jar;%APP_HOME%\lib\dom4j-1.6.1.jar;%APP_HOME%\lib\jalopy-1.5rc3.jar;%APP_HOME%\lib\jaxen-1.1.1.jar;%APP_HOME%\lib\log4j-1.2.17.jar;%APP_HOME%\lib\freemarker-2.3.23.jar;%APP_HOME%\lib\com.liferay.portal.impl-2.13.0.jar;%APP_HOME%\lib\com.liferay.portal.kernel-2.27.0-SNAPSHOT.jar;%APP_HOME%\lib\com.liferay.util.java-2.0.0.jar;%APP_HOME%\lib\ant-1.9.4.jar;%APP_HOME%\lib\maven-plugin-api-3.0.4.jar;%APP_HOME%\lib\xercesImpl-2.11.0.jar

@rem Execute portal-tools-service-builder
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %PORTAL_TOOLS_SERVICE_BUILDER_OPTS%  -classpath "%CLASSPATH%" com.liferay.portal.tools.service.builder.ServiceBuilder %CMD_LINE_ARGS%

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable PORTAL_TOOLS_SERVICE_BUILDER_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%PORTAL_TOOLS_SERVICE_BUILDER_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
