/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.service.builder;

import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.service.builder.EntityColumn;
import com.liferay.portal.tools.service.builder.EntityFinder;
import com.liferay.portal.tools.service.builder.EntityOrder;
import com.liferay.portal.tools.service.builder.LocalizationColumn;
import com.liferay.portal.tools.service.builder.LocalizationEntity;
import com.liferay.portal.tools.service.builder.ServiceBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class Entity
implements Comparable<Entity> {
    public static final Accessor<Entity, String> NAME_ACCESSOR = new Accessor<Entity, String>(){

        @Override
        public String get(Entity entity) {
            return entity.getName();
        }

        @Override
        public Class<String> getAttributeClass() {
            return String.class;
        }

        @Override
        public Class<Entity> getTypeClass() {
            return Entity.class;
        }
    };
    private static final String _DATA_SOURCE_DEFAULT = "liferayDataSource";
    private static final String _SESSION_FACTORY_DEFAULT = "liferaySessionFactory";
    private static final String _TX_MANAGER_DEFAULT = "liferayTransactionManager";
    private final String _alias;
    private final String _apiPackagePath;
    private List<EntityColumn> _blobList;
    private final boolean _cacheEnabled;
    private final List<EntityColumn> _collectionList;
    private final List<EntityColumn> _columnList;
    private final boolean _containerModel;
    private final String _dataSource;
    private final boolean _deprecated;
    private final boolean _dynamicUpdateEnabled;
    private final String _finderClass;
    private final List<EntityColumn> _finderColumnsList;
    private final List<EntityFinder> _finderList;
    private final String _humanName;
    private final boolean _jsonEnabled;
    private final List<LocalizationColumn> _localizationColumns;
    private LocalizationEntity _localizationEntity;
    private final boolean _localService;
    private final boolean _mvccEnabled;
    private final String _name;
    private final EntityOrder _order;
    private final String _packagePath;
    private List<String> _parentTransients;
    private final String _persistenceClass;
    private final List<EntityColumn> _pkList;
    private boolean _portalReference;
    private final String _portletName;
    private final String _portletShortName;
    private final List<Entity> _referenceList;
    private final List<EntityColumn> _regularColList;
    private final boolean _remoteService;
    private final boolean _resourceActionModel;
    private final String _sessionFactory;
    private final String _table;
    private List<String> _transients;
    private final boolean _trashEnabled;
    private final String _txManager;
    private final List<String> _txRequiredList;
    private List<String> _unresolvedReferenceList;
    private final boolean _uuid;
    private final boolean _uuidAccessor;

    public static EntityColumn getColumn(String name, List<EntityColumn> columnList) {
        for (EntityColumn col : columnList) {
            if (!name.equals(col.getName())) continue;
            return col;
        }
        throw new RuntimeException("Column " + name + " not found");
    }

    public static boolean hasColumn(String name, List<EntityColumn> columnList) {
        return Entity.hasColumn(name, null, columnList);
    }

    public static boolean hasColumn(String name, String type, List<EntityColumn> columnList) {
        int index = columnList.indexOf(new EntityColumn(name));
        if (index != -1) {
            EntityColumn col = columnList.get(index);
            if (type == null || type.equals(col.getType())) {
                return true;
            }
        }
        return false;
    }

    public Entity(String name) {
        this(null, null, null, null, name, null, null, null, false, false, false, true, null, null, null, null, null, true, false, false, false, false, false, null, null, null, null, null, Collections.emptyList(), null, null, null, null, null, false);
    }

    public Entity(String packagePath, String apiPackagePath, String portletName, String portletShortName, String name, String humanName, String table, String alias, boolean uuid, boolean uuidAccessor, boolean localService, boolean remoteService, String persistenceClass, String finderClass, String dataSource, String sessionFactory, String txManager, boolean cacheEnabled, boolean dynamicUpdateEnabled, boolean jsonEnabled, boolean mvccEnabled, boolean trashEnabled, boolean deprecated, List<EntityColumn> pkList, List<EntityColumn> regularColList, List<EntityColumn> blobList, List<EntityColumn> collectionList, List<EntityColumn> columnList, List<LocalizationColumn> localizationColumns, EntityOrder order, List<EntityFinder> finderList, List<Entity> referenceList, List<String> unresolvedReferenceList, List<String> txRequiredList, boolean resourceActionModel) {
        this._packagePath = packagePath;
        this._apiPackagePath = apiPackagePath;
        this._portletName = portletName;
        this._portletShortName = portletShortName;
        this._name = name;
        this._humanName = GetterUtil.getString(humanName, ServiceBuilder.toHumanName(name));
        this._table = table;
        this._alias = alias;
        this._uuid = uuid;
        this._uuidAccessor = uuidAccessor;
        this._localService = localService;
        this._remoteService = remoteService;
        this._persistenceClass = persistenceClass;
        this._finderClass = finderClass;
        this._dataSource = GetterUtil.getString(dataSource, _DATA_SOURCE_DEFAULT);
        this._sessionFactory = GetterUtil.getString(sessionFactory, _SESSION_FACTORY_DEFAULT);
        this._txManager = GetterUtil.getString(txManager, _TX_MANAGER_DEFAULT);
        this._dynamicUpdateEnabled = dynamicUpdateEnabled;
        this._jsonEnabled = jsonEnabled;
        this._mvccEnabled = mvccEnabled;
        this._trashEnabled = trashEnabled;
        this._deprecated = deprecated;
        this._pkList = pkList;
        this._regularColList = regularColList;
        this._blobList = blobList;
        this._collectionList = collectionList;
        this._columnList = columnList;
        this._localizationColumns = localizationColumns;
        this._order = order;
        this._finderList = finderList;
        this._referenceList = referenceList;
        this._unresolvedReferenceList = unresolvedReferenceList;
        this._txRequiredList = txRequiredList;
        this._resourceActionModel = resourceActionModel;
        if (this._finderList != null) {
            HashSet finderColumns = new HashSet();
            for (EntityFinder entityFinder : this._finderList) {
                finderColumns.addAll(entityFinder.getColumns());
            }
            this._finderColumnsList = new ArrayList<EntityColumn>(finderColumns);
            Collections.sort(this._finderColumnsList);
        } else {
            this._finderColumnsList = Collections.emptyList();
        }
        if (this._blobList != null && !this._blobList.isEmpty()) {
            for (EntityColumn col : this._blobList) {
                if (col.isLazy()) continue;
                cacheEnabled = false;
                break;
            }
        }
        this._cacheEnabled = cacheEnabled;
        boolean containerModel = false;
        if (this._columnList != null && !this._columnList.isEmpty()) {
            for (EntityColumn col : this._columnList) {
                if (!col.isContainerModel() && !col.isParentContainerModel()) continue;
                containerModel = true;
                break;
            }
        }
        this._containerModel = containerModel;
        if (this.hasLocalizationColumns()) {
            this._referenceList.add(this.toLocalizationEntity());
        }
    }

    public void addReference(Entity reference) {
        this._referenceList.add(reference);
    }

    @Override
    public int compareTo(Entity entity) {
        return this._name.compareToIgnoreCase(entity._name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Entity)) {
            return false;
        }
        Entity entity = (Entity)obj;
        String name = entity.getName();
        return this._name.equals(name);
    }

    public String getAlias() {
        return this._alias;
    }

    public String getApiPackagePath() {
        return this._apiPackagePath;
    }

    public List<EntityColumn> getBadNamedColumnsList() {
        List<EntityColumn> badNamedColumnsList = ListUtil.copy(this._columnList);
        Iterator<EntityColumn> itr = badNamedColumnsList.iterator();
        while (itr.hasNext()) {
            EntityColumn col = itr.next();
            String name = col.getName();
            if (!name.equals(col.getDBName())) continue;
            itr.remove();
        }
        return badNamedColumnsList;
    }

    public List<EntityColumn> getBlobList() {
        return this._blobList;
    }

    public List<EntityFinder> getCollectionFinderList() {
        ArrayList<EntityFinder> finderList = new ArrayList<EntityFinder>(this._finderList.size());
        for (EntityFinder entityFinder : this._finderList) {
            if (!entityFinder.isCollection() || entityFinder.hasCustomComparator()) continue;
            finderList.add(entityFinder);
        }
        return finderList;
    }

    public List<EntityColumn> getCollectionList() {
        return this._collectionList;
    }

    public EntityColumn getColumn(String name) {
        return Entity.getColumn(name, this._columnList);
    }

    public EntityColumn getColumnByMappingTable(String mappingTable) {
        for (EntityColumn col : this._columnList) {
            if (col.getMappingTable() == null || !col.getMappingTable().equals(mappingTable)) continue;
            return col;
        }
        return null;
    }

    public List<EntityColumn> getColumnList() {
        return this._columnList;
    }

    public String getDataSource() {
        return this._dataSource;
    }

    public EntityColumn getFilterPKColumn() {
        for (EntityColumn col : this._columnList) {
            if (!col.isFilterPrimary()) continue;
            return col;
        }
        return this._getPKColumn();
    }

    public String getFinderClass() {
        return this._finderClass;
    }

    public List<EntityColumn> getFinderColumnsList() {
        return this._finderColumnsList;
    }

    public List<EntityFinder> getFinderList() {
        return this._finderList;
    }

    public String getHumanName() {
        return this._humanName;
    }

    public String getHumanNames() {
        return TextFormatter.formatPlural(this._humanName);
    }

    public List<LocalizationColumn> getLocalizationColumns() {
        return this._localizationColumns;
    }

    public String getName() {
        return this._name;
    }

    public String getNames() {
        return TextFormatter.formatPlural(this._name);
    }

    public EntityOrder getOrder() {
        return this._order;
    }

    public String getPackagePath() {
        return this._packagePath;
    }

    public List<String> getParentTransients() {
        return this._parentTransients;
    }

    public String getPersistenceClass() {
        return this._persistenceClass;
    }

    public String getPKClassName() {
        if (this.hasCompoundPK()) {
            return this._name + "PK";
        }
        EntityColumn col = this._getPKColumn();
        return col.getType();
    }

    public String getPKDBName() {
        if (this.hasCompoundPK()) {
            return this.getVarName() + "PK";
        }
        EntityColumn col = this._getPKColumn();
        return col.getDBName();
    }

    public List<EntityColumn> getPKList() {
        return this._pkList;
    }

    public String getPKVarName() {
        if (this.hasCompoundPK()) {
            return this.getVarName() + "PK";
        }
        EntityColumn col = this._getPKColumn();
        return col.getName();
    }

    public String getPKVarNames() {
        if (this.hasCompoundPK()) {
            return this.getVarName() + "PKs";
        }
        EntityColumn col = this._getPKColumn();
        return col.getNames();
    }

    public String getPortletName() {
        return this._portletName;
    }

    public String getPortletShortName() {
        return this._portletShortName;
    }

    public List<Entity> getReferenceList() {
        return this._referenceList;
    }

    public List<EntityColumn> getRegularColList() {
        return this._regularColList;
    }

    public String getSessionFactory() {
        return this._sessionFactory;
    }

    public String getShortName() {
        if (this._name.startsWith(this._portletShortName)) {
            return this._name.substring(this._portletShortName.length());
        }
        return this._name;
    }

    public String getSpringPropertyName() {
        return TextFormatter.format(this._name, 11);
    }

    public String getTable() {
        return this._table;
    }

    public List<String> getTransients() {
        return this._transients;
    }

    public String getTXManager() {
        return this._txManager;
    }

    public List<String> getTxRequiredList() {
        return this._txRequiredList;
    }

    public List<EntityFinder> getUniqueFinderList() {
        List<EntityFinder> finderList = ListUtil.copy(this._finderList);
        Iterator<EntityFinder> itr = finderList.iterator();
        while (itr.hasNext()) {
            EntityFinder finder = itr.next();
            if (!finder.isCollection() || finder.isUnique()) continue;
            itr.remove();
        }
        return finderList;
    }

    public List<String> getUnresolvedReferenceList() {
        if (this._unresolvedReferenceList == null) {
            return new ArrayList<String>();
        }
        return this._unresolvedReferenceList;
    }

    public String getVarName() {
        return TextFormatter.format(this._name, 8);
    }

    public String getVarNames() {
        return TextFormatter.formatPlural(this.getVarName());
    }

    public boolean hasActionableDynamicQuery() {
        if (this.hasColumns() && this.hasLocalService()) {
            if (this.hasCompoundPK()) {
                EntityColumn col = this._pkList.get(0);
                return col.isPrimitiveType();
            }
            return this.hasPrimitivePK();
        }
        return false;
    }

    public boolean hasArrayableOperator() {
        for (EntityFinder finder : this._finderList) {
            if (!finder.hasArrayableOperator()) continue;
            return true;
        }
        return false;
    }

    public boolean hasColumn(String name) {
        return Entity.hasColumn(name, this._columnList);
    }

    public boolean hasColumn(String name, String type) {
        return Entity.hasColumn(name, type, this._columnList);
    }

    public boolean hasColumns() {
        return !ListUtil.isEmpty(this._columnList);
    }

    public boolean hasCompoundPK() {
        return this._pkList.size() > 1;
    }

    public boolean hasEagerBlobColumn() {
        if (this._blobList == null || this._blobList.isEmpty()) {
            return false;
        }
        for (EntityColumn col : this._blobList) {
            if (col.isLazy()) continue;
            return true;
        }
        return false;
    }

    public boolean hasFinderClass() {
        return !Validator.isNull(this._finderClass);
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public boolean hasLazyBlobColumn() {
        if (this._blobList == null || this._blobList.isEmpty()) {
            return false;
        }
        for (EntityColumn col : this._blobList) {
            if (!col.isLazy()) continue;
            return true;
        }
        return false;
    }

    public boolean hasLocalizationColumns() {
        return !this._localizationColumns.isEmpty();
    }

    public boolean hasLocalService() {
        return this._localService;
    }

    public boolean hasPrimitivePK() {
        return this.hasPrimitivePK(true);
    }

    public boolean hasPrimitivePK(boolean includeWrappers) {
        if (this.hasCompoundPK()) {
            return false;
        }
        EntityColumn col = this._getPKColumn();
        return col.isPrimitiveType(includeWrappers);
    }

    public boolean hasRemoteService() {
        return this._remoteService;
    }

    public boolean hasUuid() {
        return this._uuid;
    }

    public boolean hasUuidAccessor() {
        return this._uuidAccessor;
    }

    public boolean isAttachedModel() {
        EntityColumn classPKCol;
        String classPKColType;
        if (!this.isTypedModel()) {
            return false;
        }
        return this.hasColumn("classPK") && (classPKColType = (classPKCol = this.getColumn("classPK")).getType()).equals("long");
    }

    public boolean isAuditedModel() {
        return this.hasColumn("companyId") && this.hasColumn("createDate", "Date") && this.hasColumn("modifiedDate", "Date") && this.hasColumn("userId") && this.hasColumn("userName");
    }

    public boolean isCacheEnabled() {
        return this._cacheEnabled;
    }

    public boolean isContainerModel() {
        return this._containerModel;
    }

    public boolean isDefaultDataSource() {
        return this._dataSource.equals(_DATA_SOURCE_DEFAULT);
    }

    public boolean isDefaultSessionFactory() {
        return this._sessionFactory.equals(_SESSION_FACTORY_DEFAULT);
    }

    public boolean isDefaultTXManager() {
        return this._txManager.equals(_TX_MANAGER_DEFAULT);
    }

    public boolean isDeprecated() {
        return this._deprecated;
    }

    public boolean isDynamicUpdateEnabled() {
        return this._dynamicUpdateEnabled;
    }

    public boolean isGroupedModel() {
        String pkVarName = this.getPKVarName();
        return this.isAuditedModel() && this.hasColumn("groupId") && !pkVarName.equals("groupId");
    }

    public boolean isHierarchicalTree() {
        if (!this.hasPrimitivePK()) {
            return false;
        }
        EntityColumn col = this._getPKColumn();
        return this._columnList.indexOf(new EntityColumn("parent" + col.getMethodName())) != -1 && this._columnList.indexOf(new EntityColumn("left" + col.getMethodName())) != -1 && this._columnList.indexOf(new EntityColumn("right" + col.getMethodName())) != -1;
    }

    public boolean isJsonEnabled() {
        return this._jsonEnabled;
    }

    public boolean isLocalizedModel() {
        for (EntityColumn col : this._columnList) {
            if (!col.isLocalized()) continue;
            return true;
        }
        return false;
    }

    public boolean isMvccEnabled() {
        return this._mvccEnabled;
    }

    public boolean isOrdered() {
        return this._order != null;
    }

    public boolean isPermissionCheckEnabled() {
        for (EntityFinder finder : this._finderList) {
            if (!this.isPermissionCheckEnabled(finder)) continue;
            return true;
        }
        return false;
    }

    public boolean isPermissionCheckEnabled(EntityFinder finder) {
        if (this._name.equals("Group") || this._name.equals("User") || finder.getName().equals("UUID_G") || !finder.isCollection() || !this.hasPrimitivePK() || !this._resourceActionModel) {
            return false;
        }
        if (this.hasColumn("groupId") && !finder.hasColumn("groupId")) {
            return false;
        }
        EntityColumn col = this._getPKColumn();
        return StringUtil.equalsIgnoreCase("long", col.getType());
    }

    public boolean isPermissionedModel() {
        return this.hasColumn("resourceBlockId");
    }

    public boolean isPortalReference() {
        return this._portalReference;
    }

    public boolean isResolved() {
        return this._unresolvedReferenceList != null && this._unresolvedReferenceList.isEmpty();
    }

    public boolean isResourcedModel() {
        String pkVarName = this.getPKVarName();
        return this.hasColumn("resourcePrimKey") && !pkVarName.equals("resourcePrimKey");
    }

    public boolean isShardedModel() {
        if (this._packagePath.equals("com.liferay.portal") && this._name.equals("Company")) {
            return false;
        }
        return this.hasColumn("companyId");
    }

    public boolean isStagedAuditedModel() {
        return this.isAuditedModel() && this.isStagedModel();
    }

    public boolean isStagedGroupedModel() {
        return this.isGroupedModel() && this.isStagedModel() && this.hasColumn("lastPublishDate", "Date");
    }

    public boolean isStagedModel() {
        return this.hasUuid() && this.hasColumn("companyId") && this.hasColumn("createDate", "Date") && this.hasColumn("modifiedDate", "Date");
    }

    public boolean isTrashEnabled() {
        return this._trashEnabled;
    }

    public boolean isTreeModel() {
        return this.hasColumn("treePath");
    }

    public boolean isTypedModel() {
        EntityColumn classNameIdCol;
        String classNameIdColType;
        return this.hasColumn("classNameId") && (classNameIdColType = (classNameIdCol = this.getColumn("classNameId")).getType()).equals("long");
    }

    public boolean isWorkflowEnabled() {
        return this.hasColumn("status") && this.hasColumn("statusByUserId") && this.hasColumn("statusByUserName") && this.hasColumn("statusDate");
    }

    public void setParentTransients(List<String> transients) {
        this._parentTransients = transients;
    }

    public void setPortalReference(boolean portalReference) {
        this._portalReference = portalReference;
    }

    public void setResolved() {
        this._unresolvedReferenceList = null;
    }

    public void setTransients(List<String> transients) {
        this._transients = transients;
    }

    public LocalizationEntity toLocalizationEntity() {
        if (this._localizationEntity != null) {
            return this._localizationEntity;
        }
        ArrayList<EntityColumn> regularColList = new ArrayList<EntityColumn>();
        ArrayList<EntityColumn> columnList = new ArrayList<EntityColumn>();
        EntityColumn mvccEntityColumn = new EntityColumn("mvccVersion", "mvccVersion", "long", false, false, false, null, null, true, true, false, null, null, null, null, false, false, false, false, false, false);
        regularColList.add(mvccEntityColumn);
        columnList.add(mvccEntityColumn);
        EntityColumn entityColumnPK = this._getPKColumn();
        String varName = this.getVarName();
        String entityLocalizationIdName = varName.concat("LocalizationId");
        EntityColumn entityLocalizationIDColumn = new EntityColumn(entityLocalizationIdName, entityLocalizationIdName, "long", true, false, false, null, null, entityColumnPK.isCaseSensitive(), entityColumnPK.isOrderByAscending(), false, null, null, null, null, false, false, false, false, false, false);
        regularColList.add(entityLocalizationIDColumn);
        columnList.add(entityLocalizationIDColumn);
        int index = this._columnList.indexOf(new EntityColumn("companyId"));
        if (index != -1) {
            EntityColumn companyIdEntityColumn = this._columnList.get(index);
            EntityColumn entityColumn = new EntityColumn(companyIdEntityColumn.getName(), companyIdEntityColumn.getDBName(), companyIdEntityColumn.getType(), false, false, false, companyIdEntityColumn.getEJBName(), null, companyIdEntityColumn.isCaseSensitive(), false, false, "=", null, companyIdEntityColumn.getIdType(), companyIdEntityColumn.getIdParam(), companyIdEntityColumn.isConvertNull(), false, false, false, false, false);
            regularColList.add(entityColumn);
            columnList.add(entityColumn);
        }
        String primaryEntityPKColumnName = varName.concat("PK");
        EntityColumn primaryEntityPKColumn = new EntityColumn(primaryEntityPKColumnName, primaryEntityPKColumnName, entityColumnPK.getType(), false, false, false, null, null, entityColumnPK.isCaseSensitive(), entityColumnPK.isOrderByAscending(), false, "=", null, entityColumnPK.getIdType(), entityColumnPK.getIdParam(), entityColumnPK.isConvertNull(), false, false, false, false, false);
        primaryEntityPKColumn.setArrayableOperator("");
        primaryEntityPKColumn.setCaseSensitive(entityColumnPK.isCaseSensitive());
        primaryEntityPKColumn.setFinderPath(true);
        primaryEntityPKColumn.setComparator("=");
        primaryEntityPKColumn.validate();
        regularColList.add(primaryEntityPKColumn);
        columnList.add(primaryEntityPKColumn);
        LocalizationColumn languageIdColumn = new LocalizationColumn("languageId", "languageId");
        languageIdColumn.setArrayableOperator("");
        languageIdColumn.setCaseSensitive(entityColumnPK.isCaseSensitive());
        languageIdColumn.setComparator("=");
        languageIdColumn.setFinderPath(true);
        languageIdColumn.validate();
        regularColList.add(languageIdColumn);
        columnList.add(languageIdColumn);
        regularColList.addAll(this._localizationColumns);
        columnList.addAll(this._localizationColumns);
        ArrayList<EntityFinder> finderList = new ArrayList<EntityFinder>(2);
        EntityFinder collectionFinder = new EntityFinder(this._name.concat("PK"), "Collection", false, null, true, Collections.singletonList(primaryEntityPKColumn));
        finderList.add(collectionFinder);
        ArrayList<EntityColumn> findByPKLanguageIdColumns = new ArrayList<EntityColumn>();
        findByPKLanguageIdColumns.add(primaryEntityPKColumn);
        findByPKLanguageIdColumns.add(languageIdColumn);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this._name.length(); ++i) {
            char c = this._name.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            sb.append(c);
        }
        sb.append("_L");
        String localizationFinderName = sb.toString();
        finderList.add(new EntityFinder(localizationFinderName, this._name.concat("Localization"), true, null, true, findByPKLanguageIdColumns));
        String persistenceClass = StringUtil.replace(this._persistenceClass, "PersistenceImpl", "LocalizationPersistenceImpl");
        this._localizationEntity = new LocalizationEntity(this._packagePath, this._apiPackagePath, this._portletName, this._portletShortName, this._name.concat("Localization"), this._humanName.concat(" localization"), this._table.concat("Localization"), this._alias.concat("Localization"), persistenceClass, this._dataSource, this._sessionFactory, this._txManager, this._cacheEnabled, this._dynamicUpdateEnabled, this._deprecated, Collections.singletonList(entityLocalizationIDColumn), regularColList, Collections.emptyList(), Collections.emptyList(), columnList, finderList, Collections.singletonList(this), this._txRequiredList);
        this._localizationEntity.setLocalizationFinderName(localizationFinderName);
        this._localizationEntity.setPrimaryKeyMethodName(primaryEntityPKColumn.getMethodName());
        return this._localizationEntity;
    }

    private EntityColumn _getPKColumn() {
        if (this._pkList.isEmpty()) {
            throw new RuntimeException("There is no primary key for entity " + this._name);
        }
        return this._pkList.get(0);
    }
}

