/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.transaction;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.transaction.NewTransactionLifecycleListener;
import com.liferay.portal.kernel.transaction.TransactionAttribute;
import com.liferay.portal.kernel.transaction.TransactionLifecycleListener;
import com.liferay.portal.kernel.transaction.TransactionStatus;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

public class TransactionCommitCallbackUtil {
    public static final TransactionLifecycleListener TRANSACTION_LIFECYCLE_LISTENER = new NewTransactionLifecycleListener(){

        @Override
        protected void doCommitted(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus) {
            List<Callable<?>> callables = TransactionCommitCallbackUtil.popCallbackList();
            for (Callable<?> callable : callables) {
                try {
                    callable.call();
                }
                catch (Exception e) {
                    _log.error("Unable to execute transaction commit callback", e);
                }
            }
        }

        @Override
        protected void doCreated(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus) {
            TransactionCommitCallbackUtil.pushCallbackList();
        }

        @Override
        protected void doRollbacked(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus, Throwable throwable) {
            TransactionCommitCallbackUtil.popCallbackList();
        }
    };
    private static final Log _log = LogFactoryUtil.getLog(TransactionCommitCallbackUtil.class);
    private static final ThreadLocal<List<List<Callable<?>>>> _callbackListListThreadLocal = new AutoResetThreadLocal<List<List<Callable<?>>>>(TransactionCommitCallbackUtil.class + "._callbackListListThreadLocal"){

        @Override
        protected List<List<Callable<?>>> initialValue() {
            return new ArrayList();
        }
    };

    public static void registerCallback(Callable<?> callable) {
        List<List<Callable<?>>> callbackListList = _callbackListListThreadLocal.get();
        if (callbackListList.isEmpty()) {
            try {
                callable.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            int index = callbackListList.size() - 1;
            List<Callable<?>> callableList = callbackListList.get(index);
            if (callableList == Collections.emptyList()) {
                callableList = new ArrayList();
                callbackListList.set(index, callableList);
            }
            callableList.add(callable);
        }
    }

    protected static List<Callable<?>> popCallbackList() {
        List<List<Callable<?>>> callbackListList = _callbackListListThreadLocal.get();
        return callbackListList.remove(callbackListList.size() - 1);
    }

    protected static void pushCallbackList() {
        List<List<Callable<?>>> callbackListList = _callbackListListThreadLocal.get();
        callbackListList.add(Collections.emptyList());
    }
}

