/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.theme;

import aQute.bnd.annotation.ProviderType;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.mobile.device.rules.kernel.MDRRuleGroupInstance;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mobile.device.Device;
import com.liferay.portal.kernel.model.Account;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.ThemeSetting;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.VirtualLayout;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutFriendlyURLLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.Mergeable;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.TimeZoneThreadLocal;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@JSON
@ProviderType
public class ThemeDisplay
implements Cloneable,
Mergeable<ThemeDisplay>,
Serializable {
    private static final Log _log = LogFactoryUtil.getLog(ThemeDisplay.class);
    private Account _account;
    private boolean _addSessionIdToURL;
    private boolean _ajax;
    private String _cdnBaseURL;
    private String _cdnDynamicResourcesHost = "";
    private String _cdnHost = "";
    private ColorScheme _colorScheme;
    private Company _company;
    private long _companyGroupId;
    private String _companyLogo = "";
    private int _companyLogoHeight;
    private int _companyLogoWidth;
    private Contact _contact;
    private Group _controlPanelGroup;
    private Layout _controlPanelLayout;
    private User _defaultUser;
    private Device _device;
    private long _doAsGroupId;
    private String _doAsUserId = "";
    private String _doAsUserLanguageId = "";
    @Deprecated
    private String _facebookCanvasPageURL;
    private boolean _freeformLayout;
    private boolean _i18n;
    private String _i18nLanguageId;
    private String _i18nPath;
    private boolean _includePortletCssJs;
    private boolean _isolated;
    private String _languageId;
    private Layout _layout;
    private transient Map<Long, String> _layoutFriendlyURLs;
    private transient Map<String, PortletPreferences> _layoutPortletPreferences;
    private List<Layout> _layouts;
    private LayoutSet _layoutSet;
    private String _layoutSetLogo = "";
    private LayoutTypePortlet _layoutTypePortlet;
    private String _lifecycle;
    private boolean _lifecycleAction;
    private boolean _lifecycleEvent;
    private boolean _lifecycleRender;
    private boolean _lifecycleResource;
    private Locale _locale;
    private MDRRuleGroupInstance _mdrRuleGroupInstance;
    private String _pathApplet = "";
    private String _pathCms = "";
    private String _pathColorSchemeImages = "";
    private String _pathContext = "";
    private String _pathFlash = "";
    private String _pathFriendlyURLPrivateGroup = "";
    private String _pathFriendlyURLPrivateUser = "";
    private String _pathFriendlyURLPublic = "";
    private String _pathImage = "";
    private String _pathJavaScript = "";
    private String _pathMain = "";
    private String _pathSound = "";
    private String _pathThemeCss = "";
    private String _pathThemeImages = "";
    private String _pathThemeJavaScript = "";
    private String _pathThemeRoot = "";
    private String _pathThemeTemplates = "";
    private transient PermissionChecker _permissionChecker;
    private long _plid;
    private String _portalDomain = "";
    private String _portalURL = "";
    private PortletDisplay _portletDisplay = new PortletDisplay();
    private String _ppid = "";
    private String _realCompanyLogo = "";
    private int _realCompanyLogoHeight;
    private int _realCompanyLogoWidth;
    private User _realUser;
    private Group _refererGroup;
    private long _refererGroupId;
    private long _refererPlid;
    private transient HttpServletRequest _request;
    private transient HttpServletResponse _response;
    private Group _scopeGroup;
    private long _scopeGroupId;
    private boolean _secure;
    private String _serverName;
    private int _serverPort;
    private String _sessionId = "";
    private boolean _showControlPanelIcon;
    private boolean _showHomeIcon;
    private boolean _showLayoutTemplatesIcon;
    private boolean _showMyAccountIcon;
    private boolean _showPageCustomizationIcon;
    private boolean _showPageSettingsIcon;
    private boolean _showPortalIcon;
    private boolean _showSignInIcon;
    private boolean _showSignOutIcon;
    private boolean _showSiteAdministrationIcon;
    private boolean _showStagingIcon;
    private boolean _signedIn;
    private Locale _siteDefaultLocale;
    private Group _siteGroup;
    private long _siteGroupId;
    private boolean _stateExclusive;
    private boolean _stateMaximized;
    private boolean _statePopUp;
    private Theme _theme;
    private boolean _themeCssFastLoad;
    private boolean _themeImagesFastLoad;
    private boolean _themeJsBarebone;
    private boolean _themeJsFastLoad;
    private String _tilesContent = "";
    private boolean _tilesSelectable;
    private String _tilesTitle = "";
    private TimeZone _timeZone;
    private List<Layout> _unfilteredLayouts;
    private String _urlControlPanel = "";
    private String _urlCurrent = "";
    private String _urlHome = "";
    private String _urlLayoutTemplates = "";
    private transient PortletURL _urlMyAccount;
    private transient PortletURL _urlPageSettings;
    private String _urlPortal = "";
    private transient PortletURL _urlPublishToLive;
    private String _urlSignIn = "";
    private String _urlSignOut = "";
    private transient PortletURL _urlUpdateManager;
    private User _user;
    private boolean _widget;

    public ThemeDisplay() {
        if (_log.isDebugEnabled()) {
            _log.debug("Creating new instance " + this.hashCode());
        }
        this._portletDisplay.setThemeDisplay(this);
    }

    public Object clone() throws CloneNotSupportedException {
        ThemeDisplay themeDisplay = (ThemeDisplay)super.clone();
        PortletDisplay portletDisplay = new PortletDisplay();
        this._portletDisplay.copyTo(portletDisplay);
        themeDisplay._portletDisplay = portletDisplay;
        portletDisplay.setThemeDisplay(themeDisplay);
        return themeDisplay;
    }

    public Account getAccount() {
        if (this._account == null && this._company != null) {
            try {
                this._account = this._company.getAccount();
            }
            catch (PortalException pe) {
                ReflectionUtil.throwException(pe);
            }
        }
        return this._account;
    }

    public String getCDNBaseURL() {
        if (this._cdnBaseURL != null) {
            return this._cdnBaseURL;
        }
        String host = this.getCDNHost();
        if (Validator.isNull(host)) {
            String portalURL = this.getPortalURL();
            try {
                portalURL = PortalUtil.getPortalURL(this.getLayout(), this);
            }
            catch (Exception e) {
                _log.error(e, e);
            }
            host = portalURL;
        }
        this._cdnBaseURL = host;
        return this._cdnBaseURL;
    }

    public String getCDNDynamicResourcesHost() {
        return this._cdnDynamicResourcesHost;
    }

    public String getCDNHost() {
        return this._cdnHost;
    }

    public ColorScheme getColorScheme() {
        return this._colorScheme;
    }

    public String getColorSchemeId() {
        return this._colorScheme.getColorSchemeId();
    }

    public Company getCompany() {
        return this._company;
    }

    public long getCompanyGroupId() {
        return this._companyGroupId;
    }

    public long getCompanyId() {
        return this._company.getCompanyId();
    }

    public String getCompanyLogo() {
        return this._companyLogo;
    }

    public int getCompanyLogoHeight() {
        return this._companyLogoHeight;
    }

    public int getCompanyLogoWidth() {
        return this._companyLogoWidth;
    }

    public Contact getContact() {
        if (this._contact == null) {
            if (this._user == null) {
                return null;
            }
            try {
                this._contact = this._user.getContact();
            }
            catch (PortalException pe) {
                ReflectionUtil.throwException(pe);
            }
        }
        return this._contact;
    }

    public Group getControlPanelGroup() {
        if (this._controlPanelGroup == null) {
            try {
                this._controlPanelGroup = GroupLocalServiceUtil.getGroup(this._company.getCompanyId(), "Control Panel");
            }
            catch (PortalException pe) {
                ReflectionUtil.throwException(pe);
            }
        }
        return this._controlPanelGroup;
    }

    public Layout getControlPanelLayout() {
        if (this._controlPanelLayout == null) {
            Group controlPanelGroup = this.getControlPanelGroup();
            this._controlPanelLayout = LayoutLocalServiceUtil.fetchDefaultLayout(controlPanelGroup.getGroupId(), true);
        }
        return this._controlPanelLayout;
    }

    public User getDefaultUser() throws PortalException {
        if (this._defaultUser == null) {
            this._defaultUser = this._company.getDefaultUser();
        }
        return this._defaultUser;
    }

    public long getDefaultUserId() throws PortalException {
        return this.getDefaultUser().getUserId();
    }

    public Device getDevice() {
        return this._device;
    }

    public long getDoAsGroupId() {
        return this._doAsGroupId;
    }

    public String getDoAsUserId() {
        return this._doAsUserId;
    }

    public String getDoAsUserLanguageId() {
        return this._doAsUserLanguageId;
    }

    @Deprecated
    public String getFacebookCanvasPageURL() {
        return this._facebookCanvasPageURL;
    }

    public String getI18nLanguageId() {
        return this._i18nLanguageId;
    }

    public String getI18nPath() {
        return this._i18nPath;
    }

    public String getLanguageId() {
        return this._languageId;
    }

    public Layout getLayout() {
        return this._layout;
    }

    public String getLayoutFriendlyURL(Layout layout) {
        if (layout instanceof VirtualLayout) {
            VirtualLayout virtualLayout = (VirtualLayout)layout;
            layout = virtualLayout.getSourceLayout();
            Group group = layout.getGroup();
            return "/~".concat(group.getFriendlyURL()).concat(this._getFriendlyURL(layout));
        }
        return this._getFriendlyURL(layout);
    }

    public List<Layout> getLayouts() {
        return this._layouts;
    }

    public LayoutSet getLayoutSet() {
        return this._layoutSet;
    }

    public String getLayoutSetLogo() {
        return this._layoutSetLogo;
    }

    public LayoutTypePortlet getLayoutTypePortlet() {
        return this._layoutTypePortlet;
    }

    public String getLifecycle() {
        return this._lifecycle;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public MDRRuleGroupInstance getMDRRuleGroupInstance() {
        return this._mdrRuleGroupInstance;
    }

    public String getPathApplet() {
        return this._pathApplet;
    }

    public String getPathCms() {
        return this._pathCms;
    }

    public String getPathColorSchemeImages() {
        return this._pathColorSchemeImages;
    }

    public String getPathContext() {
        return this._pathContext;
    }

    public String getPathFlash() {
        return this._pathFlash;
    }

    public String getPathFriendlyURLPrivateGroup() {
        return this._pathFriendlyURLPrivateGroup;
    }

    public String getPathFriendlyURLPrivateUser() {
        return this._pathFriendlyURLPrivateUser;
    }

    public String getPathFriendlyURLPublic() {
        return this._pathFriendlyURLPublic;
    }

    public String getPathImage() {
        return this._pathImage;
    }

    public String getPathJavaScript() {
        return this._pathJavaScript;
    }

    public String getPathMain() {
        return this._pathMain;
    }

    public String getPathSound() {
        return this._pathSound;
    }

    public String getPathThemeCss() {
        return this._pathThemeCss;
    }

    public String getPathThemeImages() {
        return this._pathThemeImages;
    }

    public String getPathThemeJavaScript() {
        return this._pathThemeJavaScript;
    }

    public String getPathThemeRoot() {
        return this._pathThemeRoot;
    }

    public String getPathThemeTemplates() {
        return this._pathThemeTemplates;
    }

    @JSON(include=false)
    public PermissionChecker getPermissionChecker() {
        return this._permissionChecker;
    }

    public long getPlid() {
        return this._plid;
    }

    public String getPortalDomain() {
        return this._portalDomain;
    }

    public String getPortalURL() {
        return this._portalURL;
    }

    @JSON(include=false)
    public PortletDisplay getPortletDisplay() {
        return this._portletDisplay;
    }

    public String getPpid() {
        return this._ppid;
    }

    public String getProtocol() {
        return HttpUtil.getProtocol(this._secure);
    }

    public String getRealCompanyLogo() {
        return this._realCompanyLogo;
    }

    public int getRealCompanyLogoHeight() {
        return this._realCompanyLogoHeight;
    }

    public int getRealCompanyLogoWidth() {
        return this._realCompanyLogoWidth;
    }

    public User getRealUser() {
        return this._realUser;
    }

    public long getRealUserId() {
        return this._realUser.getUserId();
    }

    public Group getRefererGroup() {
        return this._refererGroup;
    }

    public long getRefererGroupId() {
        return this._refererGroupId;
    }

    public long getRefererPlid() {
        return this._refererPlid;
    }

    @JSON(include=false)
    public HttpServletRequest getRequest() {
        return this._request;
    }

    @JSON(include=false)
    public HttpServletResponse getResponse() {
        return this._response;
    }

    public Group getScopeGroup() {
        return this._scopeGroup;
    }

    public long getScopeGroupId() {
        return this._scopeGroupId;
    }

    public String getScopeGroupName() throws PortalException {
        if (this._scopeGroup == null) {
            return "";
        }
        return this._scopeGroup.getDescriptiveName();
    }

    public Layout getScopeLayout() throws PortalException {
        if (this._layout.hasScopeGroup()) {
            return this._layout;
        }
        if (this._scopeGroup.isLayout()) {
            return LayoutLocalServiceUtil.getLayout(this._scopeGroup.getClassPK());
        }
        return null;
    }

    public String getServerName() {
        return this._serverName;
    }

    public int getServerPort() {
        return this._serverPort;
    }

    public String getSessionId() {
        return this._sessionId;
    }

    public Locale getSiteDefaultLocale() {
        return this._siteDefaultLocale;
    }

    public Group getSiteGroup() {
        return this._siteGroup;
    }

    public long getSiteGroupId() {
        return this._siteGroupId;
    }

    public long getSiteGroupIdOrLiveGroupId() {
        return StagingUtil.getLiveGroupId(this._siteGroupId);
    }

    public String getSiteGroupName() throws PortalException {
        if (this._siteGroup == null) {
            return "";
        }
        return this._siteGroup.getDescriptiveName();
    }

    public PortletPreferences getStrictLayoutPortletSetup(Layout layout, String portletId) {
        PortletPreferences portletPreferences = null;
        if (this._layout.getPlid() == layout.getPlid() && this._layout.getMvccVersion() == layout.getMvccVersion() && this._layoutTypePortlet != null) {
            if (this._layoutPortletPreferences == null) {
                this._layoutPortletPreferences = PortletPreferencesLocalServiceUtil.getStrictPreferences(this._layout, this._layoutTypePortlet.getAllPortlets());
            }
            portletPreferences = this._layoutPortletPreferences.get(portletId);
        }
        if (portletPreferences == null) {
            return PortletPreferencesFactoryUtil.getStrictLayoutPortletSetup(layout, portletId);
        }
        return portletPreferences;
    }

    public Theme getTheme() {
        return this._theme;
    }

    public String getThemeId() {
        return this._theme.getThemeId();
    }

    public String getThemeSetting(String key) {
        Theme theme = this.getTheme();
        String device = theme.getDevice();
        Layout layout = this.getLayout();
        return layout.getThemeSetting(key, device);
    }

    public Properties getThemeSettings() {
        Theme theme = this.getTheme();
        Properties properties = new Properties();
        Map<String, ThemeSetting> themeSettings = theme.getSettings();
        for (Map.Entry<String, ThemeSetting> entry : themeSettings.entrySet()) {
            String key = entry.getKey();
            ThemeSetting themeSetting = entry.getValue();
            String value = null;
            value = themeSetting.isConfigurable() ? this.getThemeSetting(key) : themeSetting.getValue();
            if (value == null) continue;
            properties.put(key, value);
        }
        return properties;
    }

    public String getTilesContent() {
        return this._tilesContent;
    }

    public String getTilesTitle() {
        return this._tilesTitle;
    }

    public TimeZone getTimeZone() {
        return this._timeZone;
    }

    public List<Layout> getUnfilteredLayouts() {
        return this._unfilteredLayouts;
    }

    @Deprecated
    public String getURLAddContent() {
        return "";
    }

    public String getURLControlPanel() {
        return this._urlControlPanel;
    }

    public String getURLCurrent() {
        return this._urlCurrent;
    }

    public String getURLHome() {
        return this._urlHome;
    }

    @Deprecated
    public String getURLLayoutTemplates() {
        if (Validator.isNull(this._urlLayoutTemplates)) {
            return this.getURLPageSettings() + "#layout";
        }
        return this._urlLayoutTemplates;
    }

    @JSON(include=false)
    public PortletURL getURLMyAccount() {
        if (this._urlMyAccount == null) {
            String portletId = PortletProviderUtil.getPortletId("com.liferay.admin.kernel.util.PortalMyAccountApplicationType$MyAccount", PortletProvider.Action.VIEW);
            this._urlMyAccount = PortalUtil.getControlPanelPortletURL(this.getRequest(), portletId, "RENDER_PHASE");
        }
        return this._urlMyAccount;
    }

    @Deprecated
    @JSON(include=false)
    public PortletURL getURLPageSettings() {
        if (this._urlPageSettings == null) {
            String portletId = PortletProviderUtil.getPortletId(Layout.class.getName(), PortletProvider.Action.EDIT);
            this._urlPageSettings = PortalUtil.getControlPanelPortletURL(this.getRequest(), portletId, "RENDER_PHASE");
        }
        return this._urlPageSettings;
    }

    public String getURLPortal() {
        return this._urlPortal;
    }

    @JSON(include=false)
    public PortletURL getURLPublishToLive() {
        return this._urlPublishToLive;
    }

    public String getURLSignIn() {
        return this._urlSignIn;
    }

    public String getURLSignOut() {
        return this._urlSignOut;
    }

    @JSON(include=false)
    public PortletURL getURLUpdateManager() {
        if (this._urlUpdateManager == null) {
            this._urlUpdateManager = PortalUtil.getControlPanelPortletURL(this.getRequest(), "1_WAR_marketplaceportlet", "RENDER_PHASE");
        }
        return this._urlUpdateManager;
    }

    public User getUser() {
        return this._user;
    }

    public long getUserId() {
        return this._user.getUserId();
    }

    public boolean isAddSessionIdToURL() {
        return this._addSessionIdToURL;
    }

    public boolean isAjax() {
        return this._ajax;
    }

    @Deprecated
    public boolean isFacebook() {
        return false;
    }

    public boolean isFreeformLayout() {
        return this._freeformLayout;
    }

    public boolean isI18n() {
        return this._i18n;
    }

    public boolean isImpersonated() {
        return this.getUserId() != this.getRealUserId();
    }

    public boolean isIncludedJs(String js) {
        String path = this.getPathJavaScript();
        return this.isIncludePortletCssJs() && js.startsWith(path + "/liferay/portlet_css.js");
    }

    public boolean isIncludePortletCssJs() {
        return this._includePortletCssJs;
    }

    public boolean isIsolated() {
        return this._isolated;
    }

    public boolean isLifecycleAction() {
        return this._lifecycleAction;
    }

    public boolean isLifecycleEvent() {
        return this._lifecycleEvent;
    }

    public boolean isLifecycleRender() {
        return this._lifecycleRender;
    }

    public boolean isLifecycleResource() {
        return this._lifecycleResource;
    }

    public boolean isSecure() {
        return this._secure;
    }

    @Deprecated
    public boolean isShowAddContentIcon() {
        return false;
    }

    @Deprecated
    public boolean isShowAddContentIconPermission() {
        return false;
    }

    public boolean isShowControlPanelIcon() {
        return this._showControlPanelIcon;
    }

    public boolean isShowHomeIcon() {
        return this._showHomeIcon;
    }

    public boolean isShowLayoutTemplatesIcon() {
        return this._showLayoutTemplatesIcon;
    }

    public boolean isShowMyAccountIcon() {
        return this._showMyAccountIcon;
    }

    public boolean isShowPageCustomizationIcon() {
        return this._showPageCustomizationIcon;
    }

    public boolean isShowPageSettingsIcon() {
        return this._showPageSettingsIcon;
    }

    public boolean isShowPortalIcon() {
        return this._showPortalIcon;
    }

    public boolean isShowSignInIcon() {
        return this._showSignInIcon;
    }

    public boolean isShowSignOutIcon() {
        return this._showSignOutIcon;
    }

    public boolean isShowSiteAdministrationIcon() {
        return this._showSiteAdministrationIcon;
    }

    public boolean isShowStagingIcon() {
        return this._showStagingIcon;
    }

    public boolean isSignedIn() {
        return this._signedIn;
    }

    public boolean isStateExclusive() {
        return this._stateExclusive;
    }

    public boolean isStateMaximized() {
        return this._stateMaximized;
    }

    public boolean isStatePopUp() {
        return this._statePopUp;
    }

    public boolean isThemeCssFastLoad() {
        return this._themeCssFastLoad;
    }

    public boolean isThemeImagesFastLoad() {
        return this._themeImagesFastLoad;
    }

    public boolean isThemeJsBarebone() {
        return this._themeJsBarebone;
    }

    public boolean isThemeJsFastLoad() {
        return this._themeJsFastLoad;
    }

    public boolean isTilesSelectable() {
        return this._tilesSelectable;
    }

    public boolean isWidget() {
        return this._widget;
    }

    @Override
    public ThemeDisplay merge(ThemeDisplay themeDisplay) {
        if (themeDisplay == null || themeDisplay == this) {
            return this;
        }
        this._includePortletCssJs = themeDisplay._includePortletCssJs;
        return this;
    }

    public void setAccount(Account account) {
        this._account = account;
    }

    public void setAddSessionIdToURL(boolean addSessionIdToURL) {
        this._addSessionIdToURL = addSessionIdToURL;
    }

    public void setAjax(boolean ajax) {
        this._ajax = ajax;
    }

    public void setCDNBaseURL(String cdnBase) {
        this._cdnBaseURL = cdnBase;
    }

    public void setCDNDynamicResourcesHost(String cdnDynamicResourcesHost) {
        this._cdnDynamicResourcesHost = cdnDynamicResourcesHost;
    }

    public void setCDNHost(String cdnHost) {
        this._cdnHost = cdnHost;
    }

    public void setCompany(Company company) throws PortalException {
        this._company = company;
        this._companyGroupId = company.getGroupId();
    }

    public void setCompanyLogo(String companyLogo) {
        this._companyLogo = companyLogo;
    }

    public void setCompanyLogoHeight(int companyLogoHeight) {
        this._companyLogoHeight = companyLogoHeight;
    }

    public void setCompanyLogoWidth(int companyLogoWidth) {
        this._companyLogoWidth = companyLogoWidth;
    }

    public void setContact(Contact contact) {
        this._contact = contact;
    }

    public void setDevice(Device device) {
        this._device = device;
    }

    public void setDoAsGroupId(long doAsGroupId) {
        this._doAsGroupId = doAsGroupId;
    }

    public void setDoAsUserId(String doAsUserId) {
        this._doAsUserId = doAsUserId;
    }

    public void setDoAsUserLanguageId(String doAsUserLanguageId) {
        this._doAsUserLanguageId = doAsUserLanguageId;
    }

    @Deprecated
    public void setFacebookCanvasPageURL(String facebookCanvasPageURL) {
        this._facebookCanvasPageURL = facebookCanvasPageURL;
    }

    public void setFreeformLayout(boolean freeformLayout) {
        this._freeformLayout = freeformLayout;
    }

    public void setI18nLanguageId(String i18nLanguageId) {
        this._i18nLanguageId = i18nLanguageId;
        this._i18n = Validator.isNotNull(i18nLanguageId);
    }

    public void setI18nPath(String i18nPath) {
        this._i18nPath = i18nPath;
        this._i18n = Validator.isNotNull(i18nPath);
    }

    public void setIncludePortletCssJs(boolean includePortletCssJs) {
        this._includePortletCssJs = includePortletCssJs;
    }

    public void setIsolated(boolean isolated) {
        this._isolated = isolated;
    }

    public void setLanguageId(String languageId) {
        this._languageId = languageId;
    }

    public void setLayout(Layout layout) {
        this._layout = layout;
    }

    public void setLayouts(List<Layout> layouts) {
        this._layouts = layouts;
    }

    public void setLayoutSet(LayoutSet layoutSet) {
        this._layoutSet = layoutSet;
    }

    public void setLayoutSetLogo(String layoutSetLogo) {
        this._layoutSetLogo = layoutSetLogo;
    }

    public void setLayoutTypePortlet(LayoutTypePortlet layoutTypePortlet) {
        this._layoutTypePortlet = layoutTypePortlet;
    }

    public void setLifecycle(String lifecycle) {
        this._lifecycle = lifecycle;
    }

    public void setLifecycleAction(boolean lifecycleAction) {
        this._lifecycleAction = lifecycleAction;
    }

    public void setLifecycleEvent(boolean lifecycleEvent) {
        this._lifecycleEvent = lifecycleEvent;
    }

    public void setLifecycleRender(boolean lifecycleRender) {
        this._lifecycleRender = lifecycleRender;
    }

    public void setLifecycleResource(boolean lifecycleResource) {
        this._lifecycleResource = lifecycleResource;
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
        LocaleThreadLocal.setThemeDisplayLocale(locale);
    }

    public void setLookAndFeel(Theme theme, ColorScheme colorScheme) {
        this._theme = theme;
        this._colorScheme = colorScheme;
        if (theme == null || colorScheme == null) {
            return;
        }
        String themeStaticResourcePath = theme.getStaticResourcePath();
        String cdnBaseURL = this.getCDNBaseURL();
        this.setPathColorSchemeImages(cdnBaseURL + themeStaticResourcePath + colorScheme.getColorSchemeImagesPath());
        String dynamicResourcesHost = this.getCDNDynamicResourcesHost();
        if (Validator.isNull(dynamicResourcesHost)) {
            String portalURL = this.getPortalURL();
            try {
                portalURL = PortalUtil.getPortalURL(this.getLayout(), this);
            }
            catch (Exception e) {
                _log.error(e, e);
            }
            dynamicResourcesHost = portalURL;
        }
        this.setPathThemeCss(dynamicResourcesHost + themeStaticResourcePath + theme.getCssPath());
        this.setPathThemeImages(cdnBaseURL + themeStaticResourcePath + theme.getImagesPath());
        this.setPathThemeJavaScript(cdnBaseURL + themeStaticResourcePath + theme.getJavaScriptPath());
        String rootPath = theme.getRootPath();
        if (rootPath.equals("/")) {
            this.setPathThemeRoot(themeStaticResourcePath);
        } else {
            this.setPathThemeRoot(themeStaticResourcePath + rootPath);
        }
        this.setPathThemeTemplates(cdnBaseURL + themeStaticResourcePath + theme.getTemplatesPath());
    }

    public void setMDRRuleGroupInstance(MDRRuleGroupInstance mdrRuleGroupInstance) {
        this._mdrRuleGroupInstance = mdrRuleGroupInstance;
    }

    public void setPathApplet(String pathApplet) {
        this._pathApplet = pathApplet;
    }

    public void setPathCms(String pathCms) {
        this._pathCms = pathCms;
    }

    public void setPathColorSchemeImages(String pathColorSchemeImages) {
        this._pathColorSchemeImages = pathColorSchemeImages;
    }

    public void setPathContext(String pathContext) {
        this._pathContext = pathContext;
    }

    public void setPathFlash(String pathFlash) {
        this._pathFlash = pathFlash;
    }

    public void setPathFriendlyURLPrivateGroup(String pathFriendlyURLPrivateGroup) {
        this._pathFriendlyURLPrivateGroup = pathFriendlyURLPrivateGroup;
    }

    public void setPathFriendlyURLPrivateUser(String pathFriendlyURLPrivateUser) {
        this._pathFriendlyURLPrivateUser = pathFriendlyURLPrivateUser;
    }

    public void setPathFriendlyURLPublic(String pathFriendlyURLPublic) {
        this._pathFriendlyURLPublic = pathFriendlyURLPublic;
    }

    public void setPathImage(String pathImage) {
        this._pathImage = pathImage;
    }

    public void setPathJavaScript(String pathJavaScript) {
        this._pathJavaScript = pathJavaScript;
    }

    public void setPathMain(String pathMain) {
        this._pathMain = pathMain;
    }

    public void setPathSound(String pathSound) {
        this._pathSound = pathSound;
    }

    public void setPathThemeCss(String pathThemeCss) {
        this._pathThemeCss = pathThemeCss;
    }

    public void setPathThemeImages(String pathThemeImages) {
        this._pathThemeImages = pathThemeImages;
    }

    public void setPathThemeJavaScript(String pathThemeJavaScript) {
        this._pathThemeJavaScript = pathThemeJavaScript;
    }

    public void setPathThemeRoot(String pathThemeRoot) {
        this._pathThemeRoot = pathThemeRoot;
    }

    public void setPathThemeTemplates(String pathThemeTemplates) {
        this._pathThemeTemplates = pathThemeTemplates;
    }

    public void setPermissionChecker(PermissionChecker permissionChecker) {
        this._permissionChecker = permissionChecker;
    }

    public void setPlid(long plid) {
        this._plid = plid;
    }

    public void setPortalDomain(String portalDomain) {
        this._portalDomain = portalDomain;
    }

    public void setPortalURL(String portalURL) {
        this._portalURL = portalURL;
    }

    public void setPpid(String ppid) {
        this._ppid = ppid;
    }

    public void setRealCompanyLogo(String realCompanyLogo) {
        this._realCompanyLogo = realCompanyLogo;
    }

    public void setRealCompanyLogoHeight(int realCompanyLogoHeight) {
        this._realCompanyLogoHeight = realCompanyLogoHeight;
    }

    public void setRealCompanyLogoWidth(int realCompanyLogoWidth) {
        this._realCompanyLogoWidth = realCompanyLogoWidth;
    }

    public void setRealUser(User realUser) {
        this._realUser = realUser;
    }

    public void setRefererGroupId(long refererGroupId) {
        this._refererGroupId = refererGroupId;
        if (this._refererGroupId > 0L) {
            try {
                this._refererGroup = GroupLocalServiceUtil.getGroup(this._refererGroupId);
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
    }

    public void setRefererPlid(long refererPlid) {
        this._refererPlid = refererPlid;
    }

    public void setRequest(HttpServletRequest request) {
        this._request = request;
    }

    public void setResponse(HttpServletResponse response) {
        this._response = response;
    }

    public void setScopeGroupId(long scopeGroupId) {
        this._scopeGroupId = scopeGroupId;
        if (this._scopeGroupId > 0L) {
            try {
                this._scopeGroup = GroupLocalServiceUtil.getGroup(this._scopeGroupId);
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
    }

    public void setSecure(boolean secure) {
        this._secure = secure;
    }

    public void setServerName(String serverName) {
        this._serverName = serverName;
    }

    public void setServerPort(int serverPort) {
        this._serverPort = serverPort;
    }

    public void setSessionId(String sessionId) {
        this._sessionId = sessionId;
    }

    @Deprecated
    public void setShowAddContentIcon(boolean showAddContentIcon) {
    }

    @Deprecated
    public void setShowAddContentIconPermission(boolean showAddContentIconPermission) {
    }

    public void setShowControlPanelIcon(boolean showControlPanelIcon) {
        this._showControlPanelIcon = showControlPanelIcon;
    }

    public void setShowHomeIcon(boolean showHomeIcon) {
        this._showHomeIcon = showHomeIcon;
    }

    public void setShowLayoutTemplatesIcon(boolean showLayoutTemplatesIcon) {
        this._showLayoutTemplatesIcon = showLayoutTemplatesIcon;
    }

    public void setShowMyAccountIcon(boolean showMyAccountIcon) {
        this._showMyAccountIcon = showMyAccountIcon;
    }

    public void setShowPageCustomizationIcon(boolean showPageCustomizationIcon) {
        this._showPageCustomizationIcon = showPageCustomizationIcon;
    }

    public void setShowPageSettingsIcon(boolean showPageSettingsIcon) {
        this._showPageSettingsIcon = showPageSettingsIcon;
    }

    public void setShowPortalIcon(boolean showPortalIcon) {
        this._showPortalIcon = showPortalIcon;
    }

    public void setShowSignInIcon(boolean showSignInIcon) {
        this._showSignInIcon = showSignInIcon;
    }

    public void setShowSignOutIcon(boolean showSignOutIcon) {
        this._showSignOutIcon = showSignOutIcon;
    }

    public void setShowSiteAdministrationIcon(boolean showSiteAdministrationIcon) {
        this._showSiteAdministrationIcon = showSiteAdministrationIcon;
    }

    public void setShowStagingIcon(boolean showStagingIcon) {
        this._showStagingIcon = showStagingIcon;
    }

    public void setSignedIn(boolean signedIn) {
        this._signedIn = signedIn;
    }

    public void setSiteDefaultLocale(Locale siteDefaultLocale) {
        this._siteDefaultLocale = siteDefaultLocale;
        LocaleThreadLocal.setSiteDefaultLocale(siteDefaultLocale);
    }

    public void setSiteGroupId(long siteGroupId) {
        this._siteGroupId = siteGroupId;
        if (this._siteGroupId > 0L) {
            try {
                this._siteGroup = GroupLocalServiceUtil.getGroup(this._siteGroupId);
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
    }

    public void setStateExclusive(boolean stateExclusive) {
        this._stateExclusive = stateExclusive;
    }

    public void setStateMaximized(boolean stateMaximized) {
        this._stateMaximized = stateMaximized;
    }

    public void setStatePopUp(boolean statePopUp) {
        this._statePopUp = statePopUp;
    }

    public void setThemeCssFastLoad(boolean themeCssFastLoad) {
        this._themeCssFastLoad = themeCssFastLoad;
    }

    public void setThemeImagesFastLoad(boolean themeImagesFastLoad) {
        this._themeImagesFastLoad = themeImagesFastLoad;
    }

    public void setThemeJsBarebone(boolean themeJsBarebone) {
        this._themeJsBarebone = themeJsBarebone;
    }

    public void setThemeJsFastLoad(boolean themeJsFastLoad) {
        this._themeJsFastLoad = themeJsFastLoad;
    }

    public void setTilesContent(String tilesContent) {
        this._tilesContent = tilesContent;
    }

    public void setTilesSelectable(boolean tilesSelectable) {
        this._tilesSelectable = tilesSelectable;
    }

    public void setTilesTitle(String tilesTitle) {
        this._tilesTitle = tilesTitle;
    }

    public void setTimeZone(TimeZone timeZone) {
        this._timeZone = timeZone;
        TimeZoneThreadLocal.setThemeDisplayTimeZone(timeZone);
    }

    public void setUnfilteredLayouts(List<Layout> unfilteredLayouts) {
        this._unfilteredLayouts = unfilteredLayouts;
    }

    @Deprecated
    public void setURLAddContent(String urlAddContent) {
    }

    public void setURLControlPanel(String urlControlPanel) {
        this._urlControlPanel = urlControlPanel;
    }

    public void setURLCurrent(String urlCurrent) {
        this._urlCurrent = urlCurrent;
    }

    public void setURLHome(String urlHome) {
        this._urlHome = urlHome;
    }

    public void setURLLayoutTemplates(String urlLayoutTemplates) {
        this._urlLayoutTemplates = urlLayoutTemplates;
    }

    @Deprecated
    public void setURLMyAccount(PortletURL urlMyAccount) {
        this._urlMyAccount = urlMyAccount;
    }

    @Deprecated
    public void setURLPageSettings(PortletURL urlPageSettings) {
        this._urlPageSettings = urlPageSettings;
    }

    public void setURLPortal(String urlPortal) {
        this._urlPortal = urlPortal;
    }

    public void setURLPublishToLive(PortletURL urlPublishToLive) {
        this._urlPublishToLive = urlPublishToLive;
    }

    public void setURLSignIn(String urlSignIn) {
        this._urlSignIn = urlSignIn;
    }

    public void setURLSignOut(String urlSignOut) {
        this._urlSignOut = urlSignOut;
    }

    @Deprecated
    public void setURLUpdateManager(PortletURL urlUpdateManager) {
        this._urlUpdateManager = urlUpdateManager;
    }

    public void setUser(User user) {
        this._user = user;
    }

    public void setWidget(boolean widget) {
        this._widget = widget;
    }

    @Override
    public ThemeDisplay split() {
        try {
            return (ThemeDisplay)this.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse);
        }
    }

    public String translate(String key) {
        return LanguageUtil.get(this.getLocale(), key);
    }

    public String translate(String pattern, Object ... arguments) {
        return LanguageUtil.format(this.getLocale(), pattern, arguments);
    }

    private String _getFriendlyURL(Layout layout) {
        String layoutFriendlyURL;
        if (this._layoutFriendlyURLs == null) {
            this._layoutFriendlyURLs = this._layouts == null ? new HashMap<Long, String>() : LayoutFriendlyURLLocalServiceUtil.getLayoutFriendlyURLs(this._siteGroup, this._layouts, this._languageId);
        }
        if ((layoutFriendlyURL = this._layoutFriendlyURLs.get(layout.getPlid())) == null) {
            layoutFriendlyURL = layout.getFriendlyURL(this._locale);
            this._layoutFriendlyURLs.put(layout.getPlid(), layoutFriendlyURL);
        }
        return layoutFriendlyURL;
    }
}

