/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.URLUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;

public class FileTimestampUtil {
    private static final Log _log = LogFactoryUtil.getLog(FileTimestampUtil.class);
    private static final Map<String, Long> _timestamps = new ConcurrentHashMap<String, Long>();

    public static long getTimestamp(ServletContext servletContext, String path) {
        File uriFile;
        if (Validator.isNull(path)) {
            return 0L;
        }
        if (path.charAt(0) != '/') {
            return 0L;
        }
        Long timestamp = _timestamps.get(path);
        if (timestamp != null) {
            return timestamp;
        }
        timestamp = 0L;
        String uriRealPath = servletContext.getRealPath(path);
        if (uriRealPath != null && (uriFile = new File(uriRealPath)).exists()) {
            timestamp = uriFile.lastModified();
            _timestamps.put(path, timestamp);
            return timestamp;
        }
        try {
            URL url = servletContext.getResource(path);
            if (url == null) {
                _log.error("Resource URL for " + path + " is null");
            } else {
                timestamp = URLUtil.getLastModifiedTime(url);
            }
        }
        catch (IOException ioe) {
            _log.error(ioe, ioe);
        }
        _timestamps.put(path, timestamp);
        return timestamp;
    }

    public static void reset() {
        _timestamps.clear();
    }
}

