/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.servlet.PortalWebResourcesUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.registry.collections.ServiceTrackerCollections;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.servlet.ServletContext;

public class DynamicResourceIncludeUtil {
    private static final List<ServletContext> _servletContexts = ServiceTrackerCollections.openList(ServletContext.class);

    public static ServletContext getPathServletContext(String path) {
        for (ServletContext servletContext : _servletContexts) {
            if (!Validator.isNotNull(servletContext.getContextPath()) || !path.startsWith(servletContext.getContextPath())) continue;
            return servletContext;
        }
        return null;
    }

    public static URL getResource(ServletContext servletContext, String path) {
        path = PortalWebResourcesUtil.stripContextPath(servletContext, path);
        try {
            URL url = servletContext.getResource(path);
            if (url != null) {
                return url;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    public static URL getResource(String path) {
        ServletContext servletContext = DynamicResourceIncludeUtil.getPathServletContext(path);
        if (servletContext != null) {
            return DynamicResourceIncludeUtil.getResource(servletContext, path);
        }
        return null;
    }
}

