/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.portal.kernel.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.concurrent.RejectedExecutionHandler;
import com.liferay.portal.kernel.concurrent.ThreadPoolExecutor;
import com.liferay.portal.kernel.concurrent.ThreadPoolHandlerAdapter;
import com.liferay.portal.kernel.executor.PortalExecutorManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseDestination;
import com.liferay.portal.kernel.messaging.DestinationStatistics;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageRunnable;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GroupThreadLocal;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.NamedThreadFactory;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public abstract class BaseAsyncDestination
extends BaseDestination {
    protected volatile PortalExecutorManager portalExecutorManager;
    protected ServiceTracker<PortalExecutorManager, PortalExecutorManager> serviceTracker;
    private static final int _WORKERS_CORE_SIZE = 2;
    private static final int _WORKERS_MAX_SIZE = 5;
    private static final Log _log = LogFactoryUtil.getLog(BaseAsyncDestination.class);
    private int _maximumQueueSize = Integer.MAX_VALUE;
    private RejectedExecutionHandler _rejectedExecutionHandler;
    private ThreadPoolExecutor _threadPoolExecutor;
    private int _workersCoreSize = 2;
    private int _workersMaxSize = 5;

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Registry registry = RegistryUtil.getRegistry();
        this.serviceTracker = registry.trackServices(PortalExecutorManager.class, (ServiceTrackerCustomizer)new PortalExecutorManagerServiceTrackerCustomizer());
        this.serviceTracker.open();
    }

    @Override
    public void close(boolean force) {
        if (this._threadPoolExecutor == null || this._threadPoolExecutor.isShutdown()) {
            return;
        }
        if (force) {
            this._threadPoolExecutor.shutdownNow();
        } else {
            this._threadPoolExecutor.shutdown();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.serviceTracker.close();
    }

    @Override
    public DestinationStatistics getDestinationStatistics() {
        DestinationStatistics destinationStatistics = new DestinationStatistics();
        destinationStatistics.setActiveThreadCount(this._threadPoolExecutor.getActiveCount());
        destinationStatistics.setCurrentThreadCount(this._threadPoolExecutor.getPoolSize());
        destinationStatistics.setLargestThreadCount(this._threadPoolExecutor.getLargestPoolSize());
        destinationStatistics.setMaxThreadPoolSize(this._threadPoolExecutor.getMaxPoolSize());
        destinationStatistics.setMinThreadPoolSize(this._threadPoolExecutor.getCorePoolSize());
        destinationStatistics.setPendingMessageCount(this._threadPoolExecutor.getPendingTaskCount());
        destinationStatistics.setSentMessageCount(this._threadPoolExecutor.getCompletedTaskCount());
        return destinationStatistics;
    }

    public int getMaximumQueueSize() {
        return this._maximumQueueSize;
    }

    public int getWorkersCoreSize() {
        return this._workersCoreSize;
    }

    public int getWorkersMaxSize() {
        return this._workersMaxSize;
    }

    @Override
    public void open() {
        if (this._threadPoolExecutor != null && !this._threadPoolExecutor.isShutdown()) {
            return;
        }
        ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
        if (this._rejectedExecutionHandler == null) {
            this._rejectedExecutionHandler = this.createRejectionExecutionHandler();
        }
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(this._workersCoreSize, this._workersMaxSize, 60L, TimeUnit.SECONDS, false, this._maximumQueueSize, this._rejectedExecutionHandler, new NamedThreadFactory(this.getName(), 5, classLoader), new ThreadPoolHandlerAdapter());
        ThreadPoolExecutor oldThreadPoolExecutor = this.portalExecutorManager.registerPortalExecutor(this.getName(), threadPoolExecutor);
        if (oldThreadPoolExecutor != null) {
            if (_log.isWarnEnabled()) {
                _log.warn("Abort creating a new thread pool for destination " + this.getName() + " and reuse previous one");
            }
            threadPoolExecutor.shutdownNow();
            threadPoolExecutor = oldThreadPoolExecutor;
        }
        this._threadPoolExecutor = threadPoolExecutor;
    }

    @Override
    public void send(Message message) {
        if (this.messageListeners.isEmpty()) {
            if (_log.isDebugEnabled()) {
                _log.debug("No message listeners for destination " + this.getName());
            }
            return;
        }
        ThreadPoolExecutor threadPoolExecutor = this.getThreadPoolExecutor();
        if (threadPoolExecutor.isShutdown()) {
            throw new IllegalStateException("Destination " + this.getName() + " is shutdown and cannot receive more messages");
        }
        this.populateMessageFromThreadLocals(message);
        if (_log.isDebugEnabled()) {
            _log.debug("Sending message " + message + " from destination " + this.getName() + " to message listeners " + this.messageListeners);
        }
        this.dispatch(this.messageListeners, message);
    }

    public void setMaximumQueueSize(int maximumQueueSize) {
        this._maximumQueueSize = maximumQueueSize;
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this._rejectedExecutionHandler = rejectedExecutionHandler;
    }

    public void setWorkersCoreSize(int workersCoreSize) {
        this._workersCoreSize = workersCoreSize;
        if (this._threadPoolExecutor != null) {
            this._threadPoolExecutor.adjustPoolSize(workersCoreSize, this._workersMaxSize);
        }
    }

    public void setWorkersMaxSize(int workersMaxSize) {
        this._workersMaxSize = workersMaxSize;
        if (this._threadPoolExecutor != null) {
            this._threadPoolExecutor.adjustPoolSize(this._workersCoreSize, workersMaxSize);
        }
    }

    protected RejectedExecutionHandler createRejectionExecutionHandler() {
        return new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                if (!_log.isWarnEnabled()) {
                    return;
                }
                MessageRunnable messageRunnable = (MessageRunnable)runnable;
                _log.warn("Discarding message " + messageRunnable.getMessage() + " because it exceeds the maximum queue size of " + BaseAsyncDestination.this._maximumQueueSize);
            }
        };
    }

    protected abstract void dispatch(Set<MessageListener> var1, Message var2);

    protected ThreadPoolExecutor getThreadPoolExecutor() {
        return this._threadPoolExecutor;
    }

    protected void populateMessageFromThreadLocals(Message message) {
        if (!message.contains("companyId")) {
            message.put("companyId", CompanyThreadLocal.getCompanyId());
        }
        if (!ClusterInvokeThreadLocal.isEnabled()) {
            message.put("clusterInvoke", Boolean.FALSE);
        }
        if (!message.contains("defaultLocale")) {
            message.put("defaultLocale", LocaleThreadLocal.getDefaultLocale());
        }
        if (!message.contains("groupId")) {
            message.put("groupId", GroupThreadLocal.getGroupId());
        }
        if (!message.contains("permissionChecker")) {
            message.put("permissionChecker", PermissionThreadLocal.getPermissionChecker());
        }
        if (!message.contains("principalName")) {
            message.put("principalName", PrincipalThreadLocal.getName());
        }
        if (!message.contains("principalPassword")) {
            message.put("principalPassword", PrincipalThreadLocal.getPassword());
        }
        if (!message.contains("siteDefaultLocale")) {
            message.put("siteDefaultLocale", LocaleThreadLocal.getSiteDefaultLocale());
        }
        if (!message.contains("themeDisplayLocale")) {
            message.put("themeDisplayLocale", LocaleThreadLocal.getThemeDisplayLocale());
        }
    }

    protected void populateThreadLocalsFromMessage(Message message) {
        Locale themeDisplayLocale;
        Locale siteDefaultLocale;
        String principalPassword;
        long groupId;
        Locale defaultLocale;
        Boolean clusterInvoke;
        long companyId = message.getLong("companyId");
        if (companyId > 0L) {
            CompanyThreadLocal.setCompanyId(companyId);
        }
        if ((clusterInvoke = (Boolean)message.get("clusterInvoke")) != null) {
            ClusterInvokeThreadLocal.setEnabled(clusterInvoke);
        }
        if ((defaultLocale = (Locale)message.get("defaultLocale")) != null) {
            LocaleThreadLocal.setDefaultLocale(defaultLocale);
        }
        if ((groupId = message.getLong("groupId")) > 0L) {
            GroupThreadLocal.setGroupId(groupId);
        }
        PermissionChecker permissionChecker = (PermissionChecker)message.get("permissionChecker");
        String principalName = message.getString("principalName");
        if (Validator.isNotNull(principalName)) {
            PrincipalThreadLocal.setName(principalName);
        }
        if (permissionChecker == null && Validator.isNotNull(principalName)) {
            try {
                User user = UserLocalServiceUtil.fetchUser(PrincipalThreadLocal.getUserId());
                permissionChecker = PermissionCheckerFactoryUtil.create(user);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (permissionChecker != null) {
            PermissionThreadLocal.setPermissionChecker(permissionChecker);
        }
        if (Validator.isNotNull(principalPassword = message.getString("principalPassword"))) {
            PrincipalThreadLocal.setPassword(principalPassword);
        }
        if ((siteDefaultLocale = (Locale)message.get("siteDefaultLocale")) != null) {
            LocaleThreadLocal.setSiteDefaultLocale(siteDefaultLocale);
        }
        if ((themeDisplayLocale = (Locale)message.get("themeDisplayLocale")) != null) {
            LocaleThreadLocal.setThemeDisplayLocale(themeDisplayLocale);
        }
    }

    private class PortalExecutorManagerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<PortalExecutorManager, PortalExecutorManager> {
        private PortalExecutorManagerServiceTrackerCustomizer() {
        }

        public PortalExecutorManager addingService(ServiceReference<PortalExecutorManager> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            BaseAsyncDestination.this.portalExecutorManager = (PortalExecutorManager)registry.getService(serviceReference);
            BaseAsyncDestination.this.open();
            return BaseAsyncDestination.this.portalExecutorManager;
        }

        public void modifiedService(ServiceReference<PortalExecutorManager> serviceReference, PortalExecutorManager portalExecutorManager) {
        }

        public void removedService(ServiceReference<PortalExecutorManager> serviceReference, PortalExecutorManager portalExecutorManager) {
            portalExecutorManager = null;
        }
    }
}

