/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.deploy.auto;

import com.liferay.portal.kernel.deploy.auto.AutoDeployDir;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

public class AutoDeployScanner
extends Thread {
    private static final Log _log = LogFactoryUtil.getLog(AutoDeployScanner.class);
    private final AutoDeployDir _autoDeployDir;
    private boolean _started = true;

    public AutoDeployScanner(ThreadGroup threadGroup, String name, AutoDeployDir autoDeployDir) {
        super(threadGroup, name);
        this._autoDeployDir = autoDeployDir;
        Class<?> clazz = this.getClass();
        this.setContextClassLoader(clazz.getClassLoader());
        this.setDaemon(true);
        this.setPriority(1);
    }

    public void pause() {
        this._started = false;
    }

    @Override
    public void run() {
        try {
            AutoDeployScanner.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (this._started) {
            try {
                AutoDeployScanner.sleep(this._autoDeployDir.getInterval());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                this._autoDeployDir.scanDirectory();
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn("Unable to scan the auto deploy directory", e);
            }
        }
    }
}

