/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.db;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DBInspector {
    private static final Log _log = LogFactoryUtil.getLog(DBInspector.class);
    private static final Pattern _columnSizePattern = Pattern.compile("^\\w+(?:\\((\\d+)\\))?.*", 2);
    private final Connection _connection;

    public DBInspector(Connection connection) {
        this._connection = connection;
    }

    public String getCatalog() throws SQLException {
        return this._connection.getCatalog();
    }

    public String getSchema() {
        try {
            return this._connection.getSchema();
        }
        catch (Throwable t) {
            if (_log.isDebugEnabled()) {
                _log.debug(t, t);
            }
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasColumn(String tableName, String columnName) throws Exception {
        try (PreparedStatement ps = this._connection.prepareStatement("select * from " + tableName);
             ResultSet rs = ps.executeQuery();){
            ResultSetMetaData rsmd = rs.getMetaData();
            int i = 0;
            while (i < rsmd.getColumnCount()) {
                String curColumnName = rsmd.getColumnName(i + 1);
                if (StringUtil.equalsIgnoreCase(curColumnName, columnName)) {
                    boolean bl = true;
                    return bl;
                }
                ++i;
            }
            return false;
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        return false;
    }

    public boolean hasColumnType(Class<?> tableClass, String columnName, String columnType) throws Exception {
        Field tableNameField = tableClass.getField("TABLE_NAME");
        String tableName = (String)tableNameField.get(null);
        DatabaseMetaData databaseMetaData = this._connection.getMetaData();
        try (ResultSet rs = databaseMetaData.getColumns(this.getCatalog(), this.getSchema(), tableName, columnName);){
            if (!rs.next()) {
                boolean bl = false;
                return bl;
            }
            int expectedColumnDataType = this._getColumnDataType(tableClass, columnName);
            int expectedColumnSize = this._getColumnSize(columnType);
            boolean expectedColumnNullable = this._isColumnNullable(columnType);
            int actualColumnDataType = rs.getInt("DATA_TYPE");
            int actualColumnSize = rs.getInt("COLUMN_SIZE");
            int actualColumnNullable = rs.getInt("NULLABLE");
            if (expectedColumnSize != -1 && expectedColumnSize != actualColumnSize) {
                boolean bl = false;
                return bl;
            }
            if (actualColumnDataType != expectedColumnDataType) {
                boolean bl = false;
                return bl;
            }
            if (expectedColumnNullable && actualColumnNullable != 1 || !expectedColumnNullable && actualColumnNullable != 0) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasRows(String tableName) {
        try (PreparedStatement ps = this._connection.prepareStatement("select count(*) from " + tableName);
             ResultSet rs = ps.executeQuery();){
            int count;
            do {
                if (!rs.next()) return false;
            } while ((count = rs.getInt(1)) <= 0);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        return false;
    }

    public boolean hasTable(String tableName) throws Exception {
        return this.hasTable(tableName, false);
    }

    public boolean hasTable(String tableName, boolean caseSensitive) throws Exception {
        if (caseSensitive) {
            return this._hasTable(tableName);
        }
        return this._hasTable(StringUtil.toLowerCase(tableName)) || this._hasTable(StringUtil.toUpperCase(tableName)) || this._hasTable(tableName);
    }

    private int _getColumnDataType(Class<?> tableClass, String columnName) throws Exception {
        Object[][] tableColumns;
        Field tableColumnsField = tableClass.getField("TABLE_COLUMNS");
        for (Object[] tableColumn : tableColumns = (Object[][])tableColumnsField.get(null)) {
            if (!tableColumn[0].equals(columnName)) continue;
            return (Integer)tableColumn[1];
        }
        throw new UpgradeException("Table class " + tableClass + " does not have column " + columnName);
    }

    private int _getColumnSize(String columnType) throws UpgradeException {
        Matcher matcher = _columnSizePattern.matcher(columnType);
        if (!matcher.matches()) {
            return -1;
        }
        String columnSize = matcher.group(1);
        if (Validator.isNotNull(columnSize)) {
            try {
                return Integer.parseInt(columnSize);
            }
            catch (NumberFormatException nfe) {
                throw new UpgradeException("Column type " + columnType + " has an invalid column size " + columnSize, nfe);
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _hasTable(String tableName) throws Exception {
        ResultSet rs;
        Statement ps;
        block2: {
            boolean bl;
            ps = null;
            rs = null;
            try {
                DatabaseMetaData metadata = this._connection.getMetaData();
                rs = metadata.getTables(this.getCatalog(), this.getSchema(), tableName, null);
                if (!rs.next()) break block2;
                bl = true;
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp(ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp(ps, rs);
            return bl;
        }
        DataAccess.cleanUp(ps, rs);
        return false;
    }

    private boolean _isColumnNullable(String typeName) {
        int i = (typeName = typeName.trim()).indexOf("null");
        if (i == -1) {
            return false;
        }
        if (i > 0 && !Character.isSpaceChar(typeName.charAt(i - 1))) {
            return false;
        }
        return i + 4 >= typeName.length();
    }
}

