/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cluster;

import com.liferay.portal.kernel.cluster.ClusterEventType;
import com.liferay.portal.kernel.cluster.ClusterNode;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ClusterEvent
implements Serializable {
    private final ClusterEventType _clusterEventType;
    private final List<ClusterNode> _clusterNodes;

    public static ClusterEvent depart(ClusterNode ... clusterNodes) {
        return new ClusterEvent(ClusterEventType.DEPART, Arrays.asList(clusterNodes));
    }

    public static ClusterEvent depart(List<ClusterNode> clusterNodes) {
        return new ClusterEvent(ClusterEventType.DEPART, clusterNodes);
    }

    public static ClusterEvent join(ClusterNode ... clusterNodes) {
        return new ClusterEvent(ClusterEventType.JOIN, Arrays.asList(clusterNodes));
    }

    public static ClusterEvent join(List<ClusterNode> clusterNodes) {
        return new ClusterEvent(ClusterEventType.JOIN, clusterNodes);
    }

    public ClusterEvent(ClusterEventType clusterEventType) {
        this(clusterEventType, Collections.emptyList());
    }

    public ClusterEvent(ClusterEventType clusterEventType, List<ClusterNode> clusterNodes) {
        this._clusterEventType = clusterEventType;
        this._clusterNodes = clusterNodes;
    }

    public ClusterEventType getClusterEventType() {
        return this._clusterEventType;
    }

    public List<ClusterNode> getClusterNodes() {
        return this._clusterNodes;
    }
}

