/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.trash.service.impl;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.SystemEvent;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portlet.trash.service.base.TrashEntryLocalServiceBaseImpl;
import com.liferay.trash.kernel.model.TrashEntry;
import com.liferay.trash.kernel.model.TrashVersion;
import com.liferay.trash.kernel.util.TrashUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class TrashEntryLocalServiceImpl
extends TrashEntryLocalServiceBaseImpl {
    public TrashEntry addTrashEntry(long userId, long groupId, String className, long classPK, String classUuid, String referrerClassName, int status, List<ObjectValuePair<Long, Integer>> statusOVPs, UnicodeProperties typeSettingsProperties) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long classNameId = this.classNameLocalService.getClassNameId(className);
        TrashEntry trashEntry = this.trashEntryPersistence.fetchByC_C(classNameId, classPK);
        if (trashEntry != null) {
            return trashEntry;
        }
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className);
        SystemEvent systemEvent = trashHandler.addDeletionSystemEvent(userId, groupId, classPK, classUuid, referrerClassName);
        long entryId = this.counterLocalService.increment();
        trashEntry = this.trashEntryPersistence.create(entryId);
        trashEntry.setGroupId(groupId);
        trashEntry.setCompanyId(user.getCompanyId());
        trashEntry.setUserId(user.getUserId());
        trashEntry.setUserName(user.getFullName());
        trashEntry.setCreateDate(new Date());
        trashEntry.setClassNameId(classNameId);
        trashEntry.setClassPK(classPK);
        trashEntry.setSystemEventSetKey(systemEvent.getSystemEventSetKey());
        if (typeSettingsProperties != null) {
            trashEntry.setTypeSettingsProperties(typeSettingsProperties);
        }
        trashEntry.setStatus(status);
        this.trashEntryPersistence.update((BaseModel)trashEntry);
        if (statusOVPs != null) {
            for (ObjectValuePair<Long, Integer> statusOVP : statusOVPs) {
                long versionId = this.counterLocalService.increment();
                TrashVersion trashVersion = this.trashVersionPersistence.create(versionId);
                trashVersion.setEntryId(entryId);
                trashVersion.setClassNameId(classNameId);
                trashVersion.setClassPK(((Long)statusOVP.getKey()).longValue());
                trashVersion.setStatus(((Integer)statusOVP.getValue()).intValue());
                this.trashVersionPersistence.update((BaseModel)trashVersion);
            }
        }
        return trashEntry;
    }

    public void checkEntries() throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this.trashEntryLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<TrashEntry>(){

            public void performAction(TrashEntry trashEntry) throws PortalException {
                TrashHandler trashHandler;
                Date createDate = trashEntry.getCreateDate();
                Group group = TrashEntryLocalServiceImpl.this.groupPersistence.fetchByPrimaryKey(trashEntry.getGroupId());
                if (group == null) {
                    return;
                }
                Date date = TrashEntryLocalServiceImpl.this.getMaxAge(group);
                if ((createDate.before(date) || !TrashUtil.isTrashEnabled((Group)group)) && (trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)trashEntry.getClassName())) != null) {
                    trashHandler.deleteTrashEntry(trashEntry.getClassPK());
                }
            }
        });
        actionableDynamicQuery.setTransactionConfig(DefaultActionableDynamicQuery.REQUIRES_NEW_TRANSACTION_CONFIG);
        actionableDynamicQuery.performActions();
    }

    public void deleteEntries(long groupId) {
        List<TrashEntry> entries = this.getEntries(groupId);
        for (TrashEntry entry : entries) {
            this.deleteEntry(entry);
        }
    }

    public TrashEntry deleteEntry(long entryId) {
        TrashEntry entry = this.trashEntryPersistence.fetchByPrimaryKey(entryId);
        return this.deleteEntry(entry);
    }

    public TrashEntry deleteEntry(String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        TrashEntry entry = this.trashEntryPersistence.fetchByC_C(classNameId, classPK);
        return this.deleteEntry(entry);
    }

    @Indexable(type=IndexableType.DELETE)
    public TrashEntry deleteEntry(TrashEntry trashEntry) {
        if (trashEntry != null) {
            this.trashVersionPersistence.removeByEntryId(trashEntry.getEntryId());
            trashEntry = (TrashEntry)this.trashEntryPersistence.remove((BaseModel)trashEntry);
            this.systemEventLocalService.deleteSystemEvents(trashEntry.getGroupId(), trashEntry.getSystemEventSetKey());
        }
        return trashEntry;
    }

    public TrashEntry fetchEntry(long entryId) {
        return this.trashEntryPersistence.fetchByPrimaryKey(entryId);
    }

    public TrashEntry fetchEntry(String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.trashEntryPersistence.fetchByC_C(classNameId, classPK);
    }

    public List<TrashEntry> getEntries(long groupId) {
        return this.trashEntryPersistence.findByGroupId(groupId);
    }

    public List<TrashEntry> getEntries(long groupId, int start, int end) {
        return this.trashEntryPersistence.findByGroupId(groupId, start, end);
    }

    public List<TrashEntry> getEntries(long groupId, int start, int end, OrderByComparator<TrashEntry> obc) {
        return this.trashEntryPersistence.findByGroupId(groupId, start, end, obc);
    }

    public List<TrashEntry> getEntries(long groupId, String className) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.trashEntryPersistence.findByG_C(groupId, classNameId);
    }

    public int getEntriesCount(long groupId) {
        return this.trashEntryPersistence.countByGroupId(groupId);
    }

    public TrashEntry getEntry(long entryId) throws PortalException {
        return this.trashEntryPersistence.findByPrimaryKey(entryId);
    }

    public TrashEntry getEntry(String className, long classPK) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.trashEntryPersistence.findByC_C(classNameId, classPK);
    }

    public Hits search(long companyId, long groupId, long userId, String keywords, int start, int end, Sort sort) {
        try {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(TrashEntry.class);
            SearchContext searchContext = this.buildSearchContext(companyId, groupId, userId, keywords, start, end, sort);
            return indexer.search(searchContext);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public BaseModelSearchResult<TrashEntry> searchTrashEntries(long companyId, long groupId, long userId, String keywords, int start, int end, Sort sort) {
        try {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(TrashEntry.class);
            SearchContext searchContext = this.buildSearchContext(companyId, groupId, userId, keywords, start, end, sort);
            Hits hits = indexer.search(searchContext);
            List trashEntries = TrashUtil.getEntries((Hits)hits);
            return new BaseModelSearchResult(trashEntries, hits.getLength());
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    protected SearchContext buildSearchContext(long companyId, long groupId, long userId, String keywords, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setKeywords(keywords);
        searchContext.setGroupIds(new long[]{groupId});
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        searchContext.setUserId(userId);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected Date getMaxAge(Group group) throws PortalException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int maxAge = TrashUtil.getMaxAge((Group)group);
        calendar.add(12, -maxAge);
        return calendar.getTime();
    }
}

