/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.document.library.kernel.exception.DuplicateFileEntryException;
import com.liferay.document.library.kernel.exception.DuplicateFolderNameException;
import com.liferay.document.library.kernel.exception.FolderNameException;
import com.liferay.document.library.kernel.exception.InvalidFolderException;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.exception.RequiredFileEntryTypeException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.model.DLFolderConstants;
import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.document.library.kernel.util.DLValidatorUtil;
import com.liferay.document.library.kernel.util.comparator.FolderIdComparator;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.increment.BufferedIncrement;
import com.liferay.portal.kernel.increment.DateOverrideIncrement;
import com.liferay.portal.kernel.lock.ExpiredLockException;
import com.liferay.portal.kernel.lock.InvalidLockException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.LockManagerUtil;
import com.liferay.portal.kernel.lock.NoSuchLockException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.repository.event.RepositoryEventTrigger;
import com.liferay.portal.kernel.repository.event.RepositoryEventType;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.tree.TreeModelTasks;
import com.liferay.portal.kernel.tree.TreeModelTasksAdapter;
import com.liferay.portal.kernel.tree.TreePathUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portal.util.RepositoryUtil;
import com.liferay.portlet.documentlibrary.model.impl.DLFolderImpl;
import com.liferay.portlet.documentlibrary.service.base.DLFolderLocalServiceBaseImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DLFolderLocalServiceImpl
extends DLFolderLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(DLFolderLocalServiceImpl.class);

    public DLFolder addFolder(long userId, long groupId, long repositoryId, boolean mountPoint, long parentFolderId, String name, String description, boolean hidden, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        parentFolderId = this.getParentFolderId(groupId, repositoryId, parentFolderId);
        Date now = new Date();
        this.validateFolder(groupId, parentFolderId, name);
        long folderId = this.counterLocalService.increment();
        DLFolder dlFolder = this.dlFolderPersistence.create(folderId);
        dlFolder.setUuid(serviceContext.getUuid());
        dlFolder.setGroupId(groupId);
        dlFolder.setCompanyId(user.getCompanyId());
        dlFolder.setUserId(user.getUserId());
        dlFolder.setUserName(user.getFullName());
        dlFolder.setRepositoryId(repositoryId);
        dlFolder.setMountPoint(mountPoint);
        dlFolder.setParentFolderId(parentFolderId);
        dlFolder.setTreePath(dlFolder.buildTreePath());
        dlFolder.setName(name);
        dlFolder.setDescription(description);
        dlFolder.setLastPostDate(now);
        dlFolder.setHidden(hidden);
        dlFolder.setRestrictionType(0);
        dlFolder.setExpandoBridgeAttributes(serviceContext);
        this.dlFolderPersistence.update((BaseModel)dlFolder);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addFolderResources(dlFolder, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            if (serviceContext.isDeriveDefaultPermissions()) {
                serviceContext.deriveDefaultPermissions(repositoryId, DLFolderConstants.getClassName());
            }
            this.addFolderResources(dlFolder, serviceContext.getModelPermissions());
        }
        if (parentFolderId != 0L) {
            this.dlFolderLocalService.updateLastPostDate(parentFolderId, now);
        }
        return dlFolder;
    }

    @Deprecated
    public void deleteAll(long groupId) throws PortalException {
        this.deleteAllByGroup(groupId);
    }

    public void deleteAllByGroup(long groupId) throws PortalException {
        Group group = this.groupLocalService.getGroup(groupId);
        List dlFolders = this.dlFolderPersistence.findByGroupId(groupId);
        for (DLFolder dlFolder : dlFolders) {
            this.dlFolderLocalService.deleteFolder(dlFolder);
        }
        this.dlFileEntryLocalService.deleteFileEntries(groupId, 0L);
        this.dlFileEntryTypeLocalService.deleteFileEntryTypes(groupId);
        this.dlFileShortcutLocalService.deleteFileShortcuts(groupId, 0L);
        DLStoreUtil.deleteDirectory((long)group.getCompanyId(), (long)groupId, (String)"");
    }

    public void deleteAllByRepository(long repositoryId) throws PortalException {
        Repository repository = this.repositoryLocalService.fetchRepository(repositoryId);
        long groupId = repositoryId;
        if (repository != null) {
            groupId = repository.getGroupId();
        }
        Group group = this.groupLocalService.getGroup(groupId);
        RepositoryEventTrigger repositoryEventTrigger = RepositoryUtil.getRepositoryEventTrigger(repositoryId);
        List dlFolders = this.dlFolderPersistence.findByRepositoryId(repositoryId);
        for (DLFolder dlFolder : dlFolders) {
            this.deleteFolderDependencies(dlFolder, true);
            repositoryEventTrigger.trigger(RepositoryEventType.Delete.class, Folder.class, (Object)new LiferayFolder(dlFolder));
        }
        if (repository != null) {
            this.dlFileEntryLocalService.deleteRepositoryFileEntries(repository.getRepositoryId(), repository.getDlFolderId());
        } else {
            this.dlFileEntryLocalService.deleteFileEntries(groupId, 0L);
            this.dlFileShortcutLocalService.deleteFileShortcuts(groupId, 0L);
        }
        DLStoreUtil.deleteDirectory((long)group.getCompanyId(), (long)repositoryId, (String)"");
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(action=1, type=1)
    public DLFolder deleteFolder(DLFolder dlFolder) throws PortalException {
        return this.deleteFolder(dlFolder, true);
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(action=1, type=1)
    public DLFolder deleteFolder(DLFolder dlFolder, boolean includeTrashedEntries) throws PortalException {
        this.deleteSubfolders(dlFolder, includeTrashedEntries);
        this.deleteFolderDependencies(dlFolder, includeTrashedEntries);
        return dlFolder;
    }

    @Indexable(type=IndexableType.DELETE)
    public DLFolder deleteFolder(long folderId) throws PortalException {
        return this.dlFolderLocalService.deleteFolder(folderId, true);
    }

    @Indexable(type=IndexableType.DELETE)
    public DLFolder deleteFolder(long folderId, boolean includeTrashedEntries) throws PortalException {
        DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        return this.dlFolderLocalService.deleteFolder(dlFolder, includeTrashedEntries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Indexable(type=IndexableType.DELETE)
    public DLFolder deleteFolder(long userId, long folderId, boolean includeTrashedEntries) throws PortalException {
        boolean hasLock = this.hasFolderLock(userId, folderId);
        Lock lock = null;
        if (!hasLock) {
            lock = this.lockFolder(userId, folderId, null, false, DLFolderImpl.LOCK_EXPIRATION_TIME);
        }
        try {
            DLFolder dLFolder = this.deleteFolder(folderId, includeTrashedEntries);
            return dLFolder;
        }
        finally {
            if (!hasLock) {
                this.unlockFolder(folderId, lock.getUuid());
            }
        }
    }

    public DLFolder fetchFolder(long folderId) {
        return this.dlFolderPersistence.fetchByPrimaryKey(folderId);
    }

    public DLFolder fetchFolder(long groupId, long parentFolderId, String name) {
        return this.dlFolderPersistence.fetchByG_P_N(groupId, parentFolderId, name);
    }

    public DLFolder fetchFolder(String uuid, long groupId) {
        return this.dlFolderPersistence.fetchByUUID_G(uuid, groupId);
    }

    public List<DLFolder> getCompanyFolders(long companyId, int start, int end) {
        return this.dlFolderPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyFoldersCount(long companyId) {
        return this.dlFolderPersistence.countByCompanyId(companyId);
    }

    public List<Object> getFileEntriesAndFileShortcuts(long groupId, long folderId, QueryDefinition<?> queryDefinition) {
        return this.dlFolderFinder.findFE_FS_ByG_F(groupId, folderId, queryDefinition);
    }

    public int getFileEntriesAndFileShortcutsCount(long groupId, long folderId, QueryDefinition<?> queryDefinition) {
        return this.dlFolderFinder.countFE_FS_ByG_F(groupId, folderId, queryDefinition);
    }

    public DLFolder getFolder(long folderId) throws PortalException {
        return this.dlFolderPersistence.findByPrimaryKey(folderId);
    }

    public DLFolder getFolder(long groupId, long parentFolderId, String name) throws PortalException {
        return this.dlFolderPersistence.findByG_P_N(groupId, parentFolderId, name);
    }

    public long getFolderId(long companyId, long folderId) {
        DLFolder dlFolder;
        if (folderId != 0L && ((dlFolder = this.dlFolderPersistence.fetchByPrimaryKey(folderId)) == null || companyId != dlFolder.getCompanyId())) {
            folderId = 0L;
        }
        return folderId;
    }

    @Deprecated
    public List<Long> getFolderIds(long groupId, long parentFolderId) {
        return this.getGroupFolderIds(groupId, parentFolderId);
    }

    public List<DLFolder> getFolders(long groupId, long parentFolderId) {
        return this.getFolders(groupId, parentFolderId, true);
    }

    public List<DLFolder> getFolders(long groupId, long parentFolderId, boolean includeMountfolders) {
        if (includeMountfolders) {
            return this.dlFolderPersistence.findByG_P(groupId, parentFolderId);
        }
        return this.dlFolderPersistence.findByG_M_P_H(groupId, false, parentFolderId, false);
    }

    public List<DLFolder> getFolders(long groupId, long parentFolderId, boolean includeMountfolders, int start, int end, OrderByComparator<DLFolder> obc) {
        if (includeMountfolders) {
            return this.dlFolderPersistence.findByG_P(groupId, parentFolderId, start, end, obc);
        }
        return this.dlFolderPersistence.findByG_M_P_H(groupId, false, parentFolderId, false, start, end, obc);
    }

    public List<DLFolder> getFolders(long groupId, long parentFolderId, int status, boolean includeMountfolders, int start, int end, OrderByComparator<DLFolder> obc) {
        if (includeMountfolders) {
            return this.dlFolderPersistence.findByG_P_H_S(groupId, parentFolderId, false, status, start, end, obc);
        }
        return this.dlFolderPersistence.findByG_M_P_H_S(groupId, false, parentFolderId, false, status, start, end, obc);
    }

    public List<DLFolder> getFolders(long groupId, long parentFolderId, int start, int end, OrderByComparator<DLFolder> obc) {
        return this.getFolders(groupId, parentFolderId, true, start, end, obc);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long groupId, long folderId, String[] mimeTypes, boolean includeMountFolders, QueryDefinition<?> queryDefinition) {
        return this.dlFolderFinder.findF_FE_FS_ByG_F_M_M(groupId, folderId, mimeTypes, includeMountFolders, queryDefinition);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long groupId, long folderId, String[] mimeTypes, boolean includeMountFolders, QueryDefinition<?> queryDefinition) {
        return this.dlFolderFinder.countF_FE_FS_ByG_F_M_M(groupId, folderId, mimeTypes, includeMountFolders, queryDefinition);
    }

    public int getFoldersCount(long groupId, long parentFolderId) {
        return this.getFoldersCount(groupId, parentFolderId, true);
    }

    public int getFoldersCount(long groupId, long parentFolderId, boolean includeMountfolders) {
        if (includeMountfolders) {
            return this.dlFolderPersistence.countByG_P(groupId, parentFolderId);
        }
        return this.dlFolderPersistence.countByG_M_P_H(groupId, false, parentFolderId, false);
    }

    public int getFoldersCount(long groupId, long parentFolderId, int status, boolean includeMountfolders) {
        if (status == -1) {
            return this.getFoldersCount(groupId, parentFolderId, includeMountfolders);
        }
        if (includeMountfolders) {
            return this.dlFolderPersistence.countByG_P_H_S(groupId, parentFolderId, false, status);
        }
        return this.dlFolderPersistence.countByG_M_P_H_S(groupId, false, parentFolderId, false, status);
    }

    public List<Long> getGroupFolderIds(long groupId, long parentFolderId) {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(parentFolderId);
        this.getGroupSubfolderIds(folderIds, groupId, parentFolderId);
        return folderIds;
    }

    public void getGroupSubfolderIds(List<Long> folderIds, long groupId, long folderId) {
        List dlFolders = this.dlFolderPersistence.findByG_P(groupId, folderId);
        for (DLFolder dlFolder : dlFolders) {
            folderIds.add(dlFolder.getFolderId());
            this.getGroupSubfolderIds(folderIds, dlFolder.getGroupId(), dlFolder.getFolderId());
        }
    }

    public DLFolder getMountFolder(long repositoryId) throws PortalException {
        return this.dlFolderPersistence.findByR_M(repositoryId, true);
    }

    public List<DLFolder> getMountFolders(long groupId, long parentFolderId, int start, int end, OrderByComparator<DLFolder> obc) {
        return this.dlFolderPersistence.findByG_M_P_H(groupId, true, parentFolderId, false, start, end, obc);
    }

    public int getMountFoldersCount(long groupId, long parentFolderId) {
        return this.dlFolderPersistence.countByG_M_P_H(groupId, true, parentFolderId, false);
    }

    public List<DLFolder> getNoAssetFolders() {
        return this.dlFolderFinder.findF_ByNoAssets();
    }

    public List<Long> getRepositoryFolderIds(long repositoryId, long parentFolderId) {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(parentFolderId);
        this.getRepositorySubfolderIds(folderIds, repositoryId, parentFolderId);
        return folderIds;
    }

    public List<DLFolder> getRepositoryFolders(long repositoryId, int start, int end) {
        return this.dlFolderPersistence.findByRepositoryId(repositoryId, start, end);
    }

    public int getRepositoryFoldersCount(long repositoryId) {
        return this.dlFolderPersistence.countByRepositoryId(repositoryId);
    }

    public void getRepositorySubfolderIds(List<Long> folderIds, long repositoryId, long folderId) {
        List dlFolders = this.dlFolderPersistence.findByR_P(repositoryId, folderId);
        for (DLFolder dlFolder : dlFolders) {
            folderIds.add(dlFolder.getFolderId());
            this.getRepositorySubfolderIds(folderIds, dlFolder.getRepositoryId(), dlFolder.getFolderId());
        }
    }

    @Deprecated
    public void getSubfolderIds(List<Long> folderIds, long groupId, long folderId) {
        this.getGroupSubfolderIds(folderIds, groupId, folderId);
    }

    public boolean hasFolderLock(long userId, long folderId) {
        return LockManagerUtil.hasLock((long)userId, (String)DLFolder.class.getName(), (long)folderId);
    }

    public boolean hasInheritableLock(long folderId) throws PortalException {
        boolean inheritable;
        block4: {
            inheritable = false;
            try {
                Lock lock = LockManagerUtil.getLock((String)DLFolder.class.getName(), (long)folderId);
                inheritable = lock.isInheritable();
            }
            catch (ExpiredLockException ele) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)ele, (Throwable)ele);
                }
            }
            catch (NoSuchLockException nsle) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)nsle, (Throwable)nsle);
            }
        }
        return inheritable;
    }

    public Lock lockFolder(long userId, long folderId) throws PortalException {
        return this.lockFolder(userId, folderId, null, false, DLFolderImpl.LOCK_EXPIRATION_TIME);
    }

    public Lock lockFolder(long userId, long folderId, String owner, boolean inheritable, long expirationTime) throws PortalException {
        if (expirationTime <= 0L || expirationTime > DLFolderImpl.LOCK_EXPIRATION_TIME) {
            expirationTime = DLFolderImpl.LOCK_EXPIRATION_TIME;
        }
        return LockManagerUtil.lock((long)userId, (String)DLFolder.class.getName(), (long)folderId, (String)owner, (boolean)inheritable, (long)expirationTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Indexable(type=IndexableType.REINDEX)
    public DLFolder moveFolder(long userId, long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        parentFolderId = this.getParentFolderId(dlFolder, parentFolderId);
        if (dlFolder.getParentFolderId() == parentFolderId) {
            return dlFolder;
        }
        boolean hasLock = this.hasFolderLock(userId, folderId);
        Lock lock = null;
        if (!hasLock) {
            lock = this.lockFolder(userId, folderId);
        }
        try {
            this.validateFolder(dlFolder.getFolderId(), dlFolder.getGroupId(), parentFolderId, dlFolder.getName());
            dlFolder.setParentFolderId(parentFolderId);
            dlFolder.setTreePath(dlFolder.buildTreePath());
            dlFolder.setExpandoBridgeAttributes(serviceContext);
            this.dlFolderPersistence.update((BaseModel)dlFolder);
            this.rebuildTree(dlFolder.getCompanyId(), folderId, dlFolder.getTreePath(), true);
            DLFolder dLFolder = dlFolder;
            return dLFolder;
        }
        finally {
            if (!hasLock) {
                this.unlockFolder(folderId, lock.getUuid());
            }
        }
    }

    public void rebuildTree(long companyId) throws PortalException {
        this.rebuildTree(companyId, 0L, "/", false);
    }

    public void rebuildTree(long companyId, long parentFolderId, String parentTreePath, boolean reindex) throws PortalException {
        TreePathUtil.rebuildTree((long)companyId, (long)parentFolderId, (String)parentTreePath, (TreeModelTasks)new TreeModelTasksAdapter<DLFolder>(){

            public List<DLFolder> findTreeModels(long previousId, long companyId, long parentPrimaryKey, int size) {
                return DLFolderLocalServiceImpl.this.dlFolderPersistence.findByF_C_P_NotS(previousId, companyId, parentPrimaryKey, 8, -1, size, (OrderByComparator)new FolderIdComparator(true));
            }

            public void rebuildDependentModelsTreePaths(long parentPrimaryKey, String treePath) throws PortalException {
                DLFolderLocalServiceImpl.this.dlFileEntryLocalService.setTreePaths(parentPrimaryKey, treePath, false);
                DLFolderLocalServiceImpl.this.dlFileShortcutLocalService.setTreePaths(parentPrimaryKey, treePath);
                DLFolderLocalServiceImpl.this.dlFileVersionLocalService.setTreePaths(parentPrimaryKey, treePath);
            }
        });
    }

    public void unlockFolder(long groupId, long parentFolderId, String name, String lockUuid) throws PortalException {
        DLFolder dlFolder = this.getFolder(groupId, parentFolderId, name);
        this.unlockFolder(dlFolder.getFolderId(), lockUuid);
    }

    public void unlockFolder(long folderId, String lockUuid) throws PortalException {
        if (Validator.isNotNull((String)lockUuid)) {
            try {
                Lock lock = LockManagerUtil.getLock((String)DLFolder.class.getName(), (long)folderId);
                if (!lockUuid.equals(lock.getUuid())) {
                    throw new InvalidLockException("UUIDs do not match");
                }
            }
            catch (ExpiredLockException | NoSuchLockException throwable) {
                // empty catch block
            }
        }
        LockManagerUtil.unlock((String)DLFolder.class.getName(), (long)folderId);
    }

    @Deprecated
    public DLFolder updateFolder(long folderId, long parentFolderId, String name, String description, long defaultFileEntryTypeId, List<Long> fileEntryTypeIds, boolean overrideFileEntryTypes, ServiceContext serviceContext) throws PortalException {
        int restrictionType = 0;
        if (overrideFileEntryTypes) {
            restrictionType = 1;
        }
        return this.updateFolder(folderId, name, description, defaultFileEntryTypeId, fileEntryTypeIds, restrictionType, serviceContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Indexable(type=IndexableType.REINDEX)
    public DLFolder updateFolder(long folderId, long parentFolderId, String name, String description, long defaultFileEntryTypeId, List<Long> fileEntryTypeIds, int restrictionType, ServiceContext serviceContext) throws PortalException {
        boolean hasLock = this.hasFolderLock(serviceContext.getUserId(), folderId);
        Lock lock = null;
        if (!hasLock) {
            lock = this.lockFolder(serviceContext.getUserId(), folderId, null, false, DLFolderImpl.LOCK_EXPIRATION_TIME);
        }
        try {
            DLFolder dLFolder;
            DLFolder dlFolder = null;
            Set<Object> originalFileEntryTypeIds = new HashSet();
            if (folderId > 0L) {
                originalFileEntryTypeIds = this.getFileEntryTypeIds(this.dlFolderPersistence.getDLFileEntryTypes(folderId));
                dlFolder = this.dlFolderLocalService.updateFolderAndFileEntryTypes(serviceContext.getUserId(), folderId, parentFolderId, name, description, defaultFileEntryTypeId, fileEntryTypeIds, restrictionType, serviceContext);
                if (!ExportImportThreadLocal.isImportInProcess()) {
                    this.dlFileEntryTypeLocalService.cascadeFileEntryTypes(serviceContext.getUserId(), dlFolder);
                }
            }
            ArrayList<ObjectValuePair> workflowDefinitionOVPs = new ArrayList<ObjectValuePair>();
            if (restrictionType == 1) {
                workflowDefinitionOVPs.add(new ObjectValuePair((Object)-1L, (Object)""));
                dLFolder = fileEntryTypeIds.iterator();
                while (dLFolder.hasNext()) {
                    long fileEntryTypeId = (Long)dLFolder.next();
                    String workflowDefinition = ParamUtil.getString((ServiceContext)serviceContext, (String)("workflowDefinition" + fileEntryTypeId));
                    workflowDefinitionOVPs.add(new ObjectValuePair((Object)fileEntryTypeId, (Object)workflowDefinition));
                }
            } else if (restrictionType == 0) {
                if (originalFileEntryTypeIds.isEmpty()) {
                    originalFileEntryTypeIds.add(-1L);
                }
                dLFolder = originalFileEntryTypeIds.iterator();
                while (dLFolder.hasNext()) {
                    long originalFileEntryTypeId = (Long)dLFolder.next();
                    workflowDefinitionOVPs.add(new ObjectValuePair((Object)originalFileEntryTypeId, (Object)""));
                }
            } else if (restrictionType == 2) {
                String workflowDefinition = ParamUtil.getString((ServiceContext)serviceContext, (String)"workflowDefinition-1");
                workflowDefinitionOVPs.add(new ObjectValuePair((Object)-1L, (Object)workflowDefinition));
                Iterator<Object> iterator = originalFileEntryTypeIds.iterator();
                while (iterator.hasNext()) {
                    long originalFileEntryTypeId = (Long)iterator.next();
                    workflowDefinitionOVPs.add(new ObjectValuePair((Object)originalFileEntryTypeId, (Object)""));
                }
            }
            this.workflowDefinitionLinkLocalService.updateWorkflowDefinitionLinks(serviceContext.getUserId(), serviceContext.getCompanyId(), serviceContext.getScopeGroupId(), DLFolder.class.getName(), folderId, workflowDefinitionOVPs);
            dLFolder = dlFolder;
            return dLFolder;
        }
        finally {
            if (!hasLock) {
                this.unlockFolder(folderId, lock.getUuid());
            }
        }
    }

    @Deprecated
    public DLFolder updateFolder(long folderId, String name, String description, long defaultFileEntryTypeId, List<Long> fileEntryTypeIds, boolean overrideFileEntryTypes, ServiceContext serviceContext) throws PortalException {
        int restrictionType = 0;
        if (overrideFileEntryTypes) {
            restrictionType = 1;
        }
        return this.updateFolder(serviceContext.getScopeGroupId(), folderId, name, description, defaultFileEntryTypeId, fileEntryTypeIds, restrictionType, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public DLFolder updateFolder(long folderId, String name, String description, long defaultFileEntryTypeId, List<Long> fileEntryTypeIds, int restrictionType, ServiceContext serviceContext) throws PortalException {
        long parentFolderId = 0L;
        if (folderId != 0L) {
            DLFolder dlFolder = this.getDLFolder(folderId);
            parentFolderId = dlFolder.getParentFolderId();
        }
        return this.updateFolder(folderId, parentFolderId, name, description, defaultFileEntryTypeId, fileEntryTypeIds, restrictionType, serviceContext);
    }

    @Deprecated
    public DLFolder updateFolderAndFileEntryTypes(long userId, long folderId, long parentFolderId, String name, String description, long defaultFileEntryTypeId, List<Long> fileEntryTypeIds, boolean overrideFileEntryTypes, ServiceContext serviceContext) throws PortalException {
        int restrictionType = 0;
        if (overrideFileEntryTypes) {
            restrictionType = 1;
        }
        return this.updateFolderAndFileEntryTypes(userId, folderId, parentFolderId, name, description, defaultFileEntryTypeId, fileEntryTypeIds, restrictionType, serviceContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DLFolder updateFolderAndFileEntryTypes(long userId, long folderId, long parentFolderId, String name, String description, long defaultFileEntryTypeId, List<Long> fileEntryTypeIds, int restrictionType, ServiceContext serviceContext) throws PortalException {
        if (restrictionType == 1 && fileEntryTypeIds.isEmpty()) {
            throw new RequiredFileEntryTypeException("File entry type IDs is empty");
        }
        boolean hasLock = this.hasFolderLock(userId, folderId);
        Lock lock = null;
        if (!hasLock) {
            lock = this.lockFolder(userId, folderId, null, false, DLFolderImpl.LOCK_EXPIRATION_TIME);
        }
        try {
            if (restrictionType == 0) {
                fileEntryTypeIds = Collections.emptyList();
            }
            DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
            parentFolderId = this.getParentFolderId(dlFolder, parentFolderId);
            this.validateFolder(folderId, dlFolder.getGroupId(), parentFolderId, name);
            long oldParentFolderId = dlFolder.getParentFolderId();
            if (oldParentFolderId != parentFolderId) {
                dlFolder.setParentFolderId(parentFolderId);
                dlFolder.setTreePath(dlFolder.buildTreePath());
            }
            dlFolder.setName(name);
            dlFolder.setDescription(description);
            dlFolder.setExpandoBridgeAttributes(serviceContext);
            dlFolder.setRestrictionType(restrictionType);
            dlFolder.setDefaultFileEntryTypeId(defaultFileEntryTypeId);
            this.dlFolderPersistence.update((BaseModel)dlFolder);
            if (fileEntryTypeIds != null) {
                this.dlFileEntryTypeLocalService.updateFolderFileEntryTypes(dlFolder, fileEntryTypeIds, defaultFileEntryTypeId, serviceContext);
            }
            if (oldParentFolderId != parentFolderId) {
                this.rebuildTree(dlFolder.getCompanyId(), folderId, dlFolder.getTreePath(), true);
            }
            DLFolder dLFolder = dlFolder;
            return dLFolder;
        }
        finally {
            if (!hasLock) {
                this.unlockFolder(folderId, lock.getUuid());
            }
        }
    }

    @BufferedIncrement(configuration="DLFolderEntry", incrementClass=DateOverrideIncrement.class)
    public void updateLastPostDate(long folderId, Date lastPostDate) throws PortalException {
        if (ExportImportThreadLocal.isImportInProcess() || folderId == 0L || lastPostDate == null) {
            return;
        }
        DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        if (lastPostDate.before(dlFolder.getLastPostDate())) {
            return;
        }
        dlFolder.setModifiedDate(dlFolder.getModifiedDate());
        dlFolder.setLastPostDate(lastPostDate);
        this.dlFolderPersistence.update((BaseModel)dlFolder);
    }

    public DLFolder updateStatus(long userId, long folderId, int status, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        int oldStatus = dlFolder.getStatus();
        dlFolder.setStatus(status);
        dlFolder.setStatusByUserId(user.getUserId());
        dlFolder.setStatusByUserName(user.getFullName());
        dlFolder.setStatusDate(new Date());
        this.dlFolderPersistence.update((BaseModel)dlFolder);
        if (status == 0) {
            this.assetEntryLocalService.updateVisible(DLFolder.class.getName(), dlFolder.getFolderId(), true);
        } else if (status == 8) {
            this.assetEntryLocalService.updateVisible(DLFolder.class.getName(), dlFolder.getFolderId(), false);
        }
        if (!(status != 0 && status != 8 && oldStatus != 8 || serviceContext != null && !serviceContext.isIndexingEnabled())) {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFolder.class);
            indexer.reindex((Object)dlFolder);
        }
        return dlFolder;
    }

    public boolean verifyInheritableLock(long folderId, String lockUuid) throws PortalException {
        boolean verified = false;
        try {
            Lock lock = LockManagerUtil.getLock((String)DLFolder.class.getName(), (long)folderId);
            if (!lock.isInheritable()) {
                throw new NoSuchLockException("{folderId=" + folderId + "}");
            }
            if (lock.getUuid().equals(lockUuid)) {
                verified = true;
            }
        }
        catch (ExpiredLockException ele) {
            throw new NoSuchLockException((Throwable)ele);
        }
        return verified;
    }

    protected void addFolderResources(DLFolder dlFolder, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourceLocalService.addResources(dlFolder.getCompanyId(), dlFolder.getGroupId(), dlFolder.getUserId(), DLFolder.class.getName(), dlFolder.getFolderId(), false, addGroupPermissions, addGuestPermissions);
    }

    protected void addFolderResources(DLFolder dlFolder, ModelPermissions modelPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(dlFolder.getCompanyId(), dlFolder.getGroupId(), dlFolder.getUserId(), DLFolder.class.getName(), dlFolder.getFolderId(), modelPermissions);
    }

    protected void addFolderResources(long folderId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        this.addFolderResources(dlFolder, addGroupPermissions, addGuestPermissions);
    }

    protected void addFolderResources(long folderId, ModelPermissions modelPermissions) throws PortalException {
        DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        this.addFolderResources(dlFolder, modelPermissions);
    }

    protected void deleteFolderDependencies(DLFolder dlFolder, boolean includeTrashedEntries) throws PortalException {
        this.resourceLocalService.deleteResource(dlFolder.getCompanyId(), DLFolder.class.getName(), 4, dlFolder.getFolderId());
        this.webDAVPropsLocalService.deleteWebDAVProps(DLFolder.class.getName(), dlFolder.getFolderId());
        this.dlFileEntryLocalService.deleteFileEntries(dlFolder.getGroupId(), dlFolder.getFolderId(), includeTrashedEntries);
        ArrayList<Long> fileEntryTypeIds = new ArrayList<Long>();
        for (DLFileEntryType dlFileEntryType : this.dlFileEntryTypeLocalService.getDLFolderDLFileEntryTypes(dlFolder.getFolderId())) {
            fileEntryTypeIds.add(dlFileEntryType.getFileEntryTypeId());
        }
        if (fileEntryTypeIds.isEmpty()) {
            fileEntryTypeIds.add(-1L);
        }
        this.dlFileEntryTypeLocalService.unsetFolderFileEntryTypes(dlFolder.getFolderId());
        this.dlFileShortcutLocalService.deleteFileShortcuts(dlFolder.getGroupId(), dlFolder.getFolderId(), includeTrashedEntries);
        this.expandoRowLocalService.deleteRows(dlFolder.getFolderId());
        this.ratingsStatsLocalService.deleteStats(DLFolder.class.getName(), dlFolder.getFolderId());
        this.dlFolderPersistence.remove((BaseModel)dlFolder);
        if (includeTrashedEntries) {
            DLStoreUtil.deleteDirectory((long)dlFolder.getCompanyId(), (long)dlFolder.getFolderId(), (String)"");
        }
        Iterator iterator = fileEntryTypeIds.iterator();
        while (iterator.hasNext()) {
            long fileEntryTypeId = (Long)iterator.next();
            WorkflowDefinitionLink workflowDefinitionLink = this.workflowDefinitionLinkLocalService.fetchWorkflowDefinitionLink(dlFolder.getCompanyId(), dlFolder.getGroupId(), DLFolder.class.getName(), dlFolder.getFolderId(), fileEntryTypeId);
            if (workflowDefinitionLink == null) continue;
            this.workflowDefinitionLinkLocalService.deleteWorkflowDefinitionLink(workflowDefinitionLink);
        }
    }

    protected void deleteSubfolders(DLFolder dlFolder, boolean includeTrashedEntries) throws PortalException {
        RepositoryEventTrigger repositoryEventTrigger = RepositoryUtil.getRepositoryEventTrigger(dlFolder.getRepositoryId());
        List dlFolders = this.dlFolderPersistence.findByG_P(dlFolder.getGroupId(), dlFolder.getFolderId());
        for (DLFolder curDLFolder : dlFolders) {
            if (!includeTrashedEntries && curDLFolder.isInTrashExplicitly()) continue;
            repositoryEventTrigger.trigger(RepositoryEventType.Delete.class, Folder.class, (Object)new LiferayFolder(curDLFolder));
            this.dlFolderLocalService.deleteFolder(curDLFolder, includeTrashedEntries);
        }
    }

    protected Set<Long> getFileEntryTypeIds(List<DLFileEntryType> dlFileEntryTypes) {
        HashSet<Long> fileEntryTypeIds = new HashSet<Long>();
        for (DLFileEntryType dlFileEntryType : dlFileEntryTypes) {
            fileEntryTypeIds.add(dlFileEntryType.getFileEntryTypeId());
        }
        return fileEntryTypeIds;
    }

    protected long getParentFolderId(DLFolder dlFolder, long parentFolderId) throws PortalException {
        parentFolderId = this.getParentFolderId(dlFolder.getGroupId(), dlFolder.getRepositoryId(), parentFolderId);
        if (parentFolderId == 0L) {
            return parentFolderId;
        }
        if (dlFolder.getFolderId() == parentFolderId) {
            throw new InvalidFolderException(2, parentFolderId);
        }
        ArrayList<Long> subfolderIds = new ArrayList<Long>();
        this.getGroupSubfolderIds(subfolderIds, dlFolder.getGroupId(), dlFolder.getFolderId());
        if (subfolderIds.contains(parentFolderId)) {
            throw new InvalidFolderException(1, parentFolderId);
        }
        return parentFolderId;
    }

    protected long getParentFolderId(long groupId, long repositoryId, long parentFolderId) throws PortalException {
        Repository repository;
        if (parentFolderId == 0L) {
            return parentFolderId;
        }
        DLFolder parentDLFolder = this.dlFolderPersistence.findByPrimaryKey(parentFolderId);
        if (parentDLFolder.getGroupId() != groupId) {
            throw new NoSuchFolderException(String.format("No folder exists with the primary key %s in group %s", parentFolderId, groupId));
        }
        if (parentDLFolder.getRepositoryId() != repositoryId && parentDLFolder.getRepositoryId() != groupId && (repository = this.repositoryLocalService.getRepository(repositoryId)).getGroupId() != parentDLFolder.getGroupId()) {
            throw new NoSuchFolderException(String.format("No folder exists with the primary key %s in repository %s", parentFolderId, repositoryId));
        }
        return parentDLFolder.getFolderId();
    }

    protected void validateFolder(long folderId, long groupId, long parentFolderId, String name) throws PortalException {
        this.validateFolderName(name);
        DLValidatorUtil.validateDirectoryName((String)name);
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.fetchFileEntry(groupId, parentFolderId, name);
        if (dlFileEntry != null) {
            throw new DuplicateFileEntryException(name);
        }
        DLFolder dlFolder = this.dlFolderPersistence.fetchByG_P_N(groupId, parentFolderId, name);
        if (dlFolder != null && dlFolder.getFolderId() != folderId) {
            throw new DuplicateFolderNameException(name);
        }
    }

    protected void validateFolder(long groupId, long parentFolderId, String name) throws PortalException {
        long folderId = 0L;
        this.validateFolder(folderId, groupId, parentFolderId, name);
    }

    protected void validateFolderName(String folderName) throws PortalException {
        if (folderName.contains("/")) {
            throw new FolderNameException(folderName);
        }
    }
}

