/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_2_0;

import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.upgrade.v6_2_0.util.DLFileEntryTypeTable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Locale;

public class UpgradeDocumentLibrary
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeDocumentLibrary.class);

    protected void deleteChecksumDirectory() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select distinct companyId from DLFileEntry");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long companyId = rs.getLong("companyId");
                DLStoreUtil.deleteDirectory((long)companyId, (long)0L, (String)"checksum");
            }
        }
    }

    protected void deleteTempDirectory() {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            DLStoreUtil.deleteDirectory((long)0L, (long)0L, (String)"liferay_temp/");
        }
    }

    protected void doUpgrade() throws Exception {
        this.alter(DLFileEntryTypeTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "fileEntryTypeKey STRING"), new UpgradeProcess.AlterColumnType((UpgradeProcess)this, "name", "STRING null")});
        this.updateFileEntryTypes();
        this.deleteChecksumDirectory();
        this.deleteTempDirectory();
        this.updateDLFolderUserName();
    }

    /*
     * Exception decompiling
     */
    protected String getUserName(long userId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String localize(long companyId, String content, String key) throws Exception {
        String languageId = UpgradeProcessUtil.getDefaultLanguageId((long)companyId);
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        HashMap<Locale, String> localizationMap = new HashMap<Locale, String>();
        localizationMap.put(locale, content);
        return LocalizationUtil.updateLocalization(localizationMap, (String)"", (String)key, (String)languageId);
    }

    protected void updateDLFolderUserName() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps1 = this.connection.prepareStatement("select distinct userId from DLFolder where userName is null or userName = ''");
             ResultSet rs = ps1.executeQuery();
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement("update DLFolder set userName = ? where userId = ? and (userName is null or userName = '')"));){
            while (rs.next()) {
                long userId = rs.getLong("userId");
                String userName = this.getUserName(userId);
                if (Validator.isNotNull((String)userName)) {
                    ps2.setString(1, userName);
                    ps2.setLong(2, userId);
                    ps2.addBatch();
                    continue;
                }
                if (!_log.isInfoEnabled()) continue;
                _log.info((Object)("User " + userId + " does not exist"));
            }
            ps2.executeBatch();
        }
    }

    protected void updateFileEntryType(long fileEntryTypeId, long companyId, String fileEntryTypeKey, String name, String description) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("update DLFileEntryType set fileEntryTypeKey = ?, name = ?, description = ? where fileEntryTypeId = ?");){
            ps.setString(1, fileEntryTypeKey);
            ps.setString(2, this.localize(companyId, name, "Name"));
            ps.setString(3, this.localize(companyId, description, "Description"));
            ps.setLong(4, fileEntryTypeId);
            ps.executeUpdate();
        }
    }

    protected void updateFileEntryTypes() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select fileEntryTypeId, companyId, name, description from DLFileEntryType");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long fileEntryTypeId = rs.getLong("fileEntryTypeId");
                long companyId = rs.getLong("companyId");
                String name = GetterUtil.getString((String)rs.getString("name"));
                String description = rs.getString("description");
                if (fileEntryTypeId == 0L) {
                    name = "basic-document";
                }
                this.updateFileEntryType(fileEntryTypeId, companyId, StringUtil.toUpperCase((String)name), name, description);
            }
        }
    }
}

