/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.util.xml.XMLUtil;
import java.util.Collections;
import java.util.Map;
import javax.portlet.ReadOnlyException;

public class TemplatePortletPreferences {
    private static final Log _log = LogFactoryUtil.getLog(TemplatePortletPreferences.class);

    public String getPreferences(Map<String, Object> preferences) throws ReadOnlyException {
        StringBundler sb = new StringBundler();
        sb.append("<portlet-preferences>");
        for (Map.Entry<String, Object> entry : preferences.entrySet()) {
            sb.append("<preference><name>");
            sb.append(entry.getKey());
            sb.append("</name>");
            Object valueObject = entry.getValue();
            if (valueObject instanceof String) {
                sb.append("<value>");
                sb.append(XMLUtil.toCompactSafe((String)((String)valueObject)));
                sb.append("</value>");
            } else if (valueObject instanceof String[]) {
                for (String value : (String[])valueObject) {
                    sb.append("<value>");
                    sb.append(XMLUtil.toCompactSafe((String)value));
                    sb.append("</value>");
                }
            } else {
                sb.setIndex(sb.index() - 3);
                continue;
            }
            sb.append("</preference>");
        }
        sb.append("</portlet-preferences>");
        return sb.toString();
    }

    public String getPreferences(String key, String value) throws ReadOnlyException {
        return this.getPreferences(Collections.singletonMap(key, value));
    }

    @Deprecated
    public void reset() {
    }

    @Deprecated
    public void setValue(String key, String value) throws ReadOnlyException {
    }

    @Deprecated
    public void setValues(String key, String[] values) throws ReadOnlyException {
    }
}

