/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template;

import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.template.TemplateContextHelper;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractTemplate
implements Template {
    protected Map<String, Object> context;
    protected TemplateResource errorTemplateResource;
    private final TemplateContextHelper _templateContextHelper;

    public AbstractTemplate(TemplateResource errorTemplateResource, Map<String, Object> context, TemplateContextHelper templateContextHelper, String templateManagerName) {
        if (templateContextHelper == null) {
            throw new IllegalArgumentException("Template context helper is null");
        }
        if (templateManagerName == null) {
            throw new IllegalArgumentException("Template manager name is null");
        }
        this.errorTemplateResource = errorTemplateResource;
        this.context = new HashMap<String, Object>();
        if (context != null) {
            for (Map.Entry<String, Object> entry : context.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
        this._templateContextHelper = templateContextHelper;
    }

    public void clear() {
        this.context.clear();
    }

    public boolean containsKey(Object key) {
        return this.context.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.context.containsValue(value);
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.context.entrySet();
    }

    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        return this.context.get(key);
    }

    public Object get(String key) {
        if (key == null) {
            return null;
        }
        return this.context.get(key);
    }

    public String[] getKeys() {
        Set<String> keys = this.context.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    public boolean isEmpty() {
        return this.context.isEmpty();
    }

    public Set<String> keySet() {
        return this.context.keySet();
    }

    public void prepare(HttpServletRequest request) {
        this._templateContextHelper.prepare((Map<String, Object>)((Object)this), request);
    }

    public Object put(String key, Object value) {
        if (key == null || value == null) {
            return null;
        }
        return this.context.put(key, value);
    }

    public void putAll(Map<? extends String, ? extends Object> map) {
        this.context.putAll(map);
    }

    public Object remove(Object key) {
        return this.context.remove(key);
    }

    public int size() {
        return this.context.size();
    }

    public Collection<Object> values() {
        return this.context.values();
    }

    @Deprecated
    protected void _write(Writer writer) throws TemplateException {
        this.write(writer);
    }

    protected String getTemplateResourceUUID(TemplateResource templateResource) {
        return "TEMPLATE_RESOURCE_UUID".concat("#").concat(templateResource.getTemplateId());
    }

    protected abstract void handleException(Exception var1, Writer var2) throws TemplateException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(Writer writer) throws TemplateException {
        Writer oldWriter = (Writer)this.get("writer");
        try {
            this.doProcessTemplate(writer);
        }
        catch (Exception e) {
            this.put("writer", (Object)writer);
            this.handleException(e, writer);
        }
        finally {
            this.put("writer", (Object)oldWriter);
        }
    }
}

