/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.util;

import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.spring.util.FactoryBean;
import com.liferay.portal.kernel.spring.util.SpringFactory;
import com.liferay.portal.kernel.spring.util.SpringFactoryException;
import com.liferay.portal.kernel.util.ClassLoaderUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@DoPrivileged
public class SpringFactoryImpl
implements SpringFactory {
    private Map<String, Set<String>> _beanDefinitions;

    public Object newBean(String className) throws SpringFactoryException {
        return this.newBean(className, null);
    }

    public Object newBean(String className, Map<String, Object> properties) throws SpringFactoryException {
        try {
            return this.doNewBean(className, properties);
        }
        catch (SpringFactoryException sfe) {
            throw sfe;
        }
        catch (Exception e) {
            throw new SpringFactoryException((Throwable)e);
        }
    }

    public void setBeanDefinitions(Map<String, String> beanDefinitions) {
        this._beanDefinitions = new HashMap<String, Set<String>>();
        for (Map.Entry<String, String> entry : beanDefinitions.entrySet()) {
            String className = entry.getKey();
            Set properties = SetUtil.fromArray((Object[])StringUtil.split((String)entry.getValue()));
            this._beanDefinitions.put(className, properties);
        }
    }

    protected Object doNewBean(String className, Map<String, Object> properties) throws Exception {
        Set<String> allowedProperties = this._beanDefinitions.get(className);
        if (allowedProperties == null) {
            throw new SpringFactoryException("Undefined class " + className);
        }
        Object bean = InstanceFactory.newInstance((ClassLoader)ClassLoaderUtil.getPortalClassLoader(), (String)className);
        FactoryBean factoryBean = null;
        if (bean instanceof FactoryBean) {
            factoryBean = (FactoryBean)bean;
            bean = factoryBean.create();
        }
        if (properties != null) {
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                String name = entry.getKey();
                if (!allowedProperties.contains(name)) {
                    throw new SpringFactoryException("Undefined property " + name + " for class " + className);
                }
                Object value = entry.getValue();
                BeanPropertiesUtil.setProperty((Object)bean, (String)name, (Object)value);
            }
        }
        if (factoryBean != null) {
            bean = factoryBean.postProcessing(bean);
        }
        return bean;
    }
}

