/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.transaction;

import com.liferay.portal.spring.transaction.TransactionAttributeAdapter;
import com.liferay.portal.spring.transaction.TransactionExecutor;
import com.liferay.portal.spring.transaction.TransactionHandler;
import com.liferay.portal.spring.transaction.TransactionStatusAdapter;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;

public class CounterTransactionExecutor
implements TransactionExecutor,
TransactionHandler {
    @Override
    public void commit(PlatformTransactionManager platformTransactionManager, TransactionAttributeAdapter transactionAttributeAdapter, TransactionStatusAdapter transactionStatusAdapter) {
        platformTransactionManager.commit(transactionStatusAdapter.getTransactionStatus());
    }

    @Override
    public Object execute(PlatformTransactionManager platformTransactionManager, TransactionAttributeAdapter transactionAttributeAdapter, MethodInvocation methodInvocation) throws Throwable {
        TransactionStatusAdapter transactionStatusAdapter = this.start(platformTransactionManager, transactionAttributeAdapter);
        Object returnValue = null;
        try {
            returnValue = methodInvocation.proceed();
        }
        catch (Throwable throwable) {
            this.rollback(platformTransactionManager, throwable, transactionAttributeAdapter, transactionStatusAdapter);
        }
        this.commit(platformTransactionManager, transactionAttributeAdapter, transactionStatusAdapter);
        return returnValue;
    }

    @Override
    public void rollback(PlatformTransactionManager platformTransactionManager, Throwable throwable, TransactionAttributeAdapter transactionAttributeAdapter, TransactionStatusAdapter transactionStatusAdapter) throws Throwable {
        if (transactionAttributeAdapter.rollbackOn(throwable)) {
            try {
                platformTransactionManager.rollback(transactionStatusAdapter.getTransactionStatus());
            }
            catch (Throwable t) {
                t.addSuppressed(throwable);
                throw t;
            }
        }
        try {
            platformTransactionManager.commit(transactionStatusAdapter.getTransactionStatus());
        }
        catch (Throwable t) {
            t.addSuppressed(throwable);
            throw t;
        }
        throw throwable;
    }

    @Override
    public TransactionStatusAdapter start(PlatformTransactionManager platformTransactionManager, TransactionAttributeAdapter transactionAttributeAdapter) {
        return new TransactionStatusAdapter(platformTransactionManager, platformTransactionManager.getTransaction((TransactionDefinition)transactionAttributeAdapter));
    }
}

