/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.servlet.BrowserSniffer;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.servlet.http.HttpServletRequest;

@DoPrivileged
public class BrowserSnifferImpl
implements BrowserSniffer {
    protected static String[] revisionLeadings = new String[]{"rv", "it", "ra", "ie"};
    protected static char[] revisionSeparators = new char[]{'\\', ':', '/', ' '};
    protected static String[] versionLeadings = new String[]{"version", "firefox", "minefield", "chrome"};
    protected static char[] versionSeparators = new char[]{'\\', '/'};
    private static final String[] _FIREFOX_ALIASES = new String[]{"firefox", "minefield", "granparadiso", "bonecho", "firebird", "phoenix", "camino"};
    private static final String[] _WEBKIT_ALIASES = new String[]{"khtml", "applewebkit"};
    private static final String[] _WINDOWS_ALIASES = new String[]{"windows", "win32", "16bit"};

    public boolean acceptsGzip(HttpServletRequest request) {
        String acceptEncoding = request.getHeader("Accept-Encoding");
        return acceptEncoding != null && acceptEncoding.contains("gzip");
    }

    public String getBrowserId(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        if (this.isIe(userAgent)) {
            return "ie";
        }
        if (this._isFirefox(userAgent)) {
            return "firefox";
        }
        return "other";
    }

    public float getMajorVersion(HttpServletRequest request) {
        return GetterUtil.getFloat((String)this.getVersion(request));
    }

    public String getRevision(HttpServletRequest request) {
        String revision = (String)request.getAttribute("BROWSER_SNIFFER_REVISION");
        if (revision != null) {
            return revision;
        }
        revision = BrowserSnifferImpl.parseVersion(this.getUserAgent(request), revisionLeadings, revisionSeparators);
        request.setAttribute("BROWSER_SNIFFER_REVISION", (Object)revision);
        return revision;
    }

    public String getVersion(HttpServletRequest request) {
        String version = (String)request.getAttribute("BROWSER_SNIFFER_VERSION");
        if (version != null) {
            return version;
        }
        String userAgent = this.getUserAgent(request);
        version = BrowserSnifferImpl.parseVersion(userAgent, versionLeadings, versionSeparators);
        if (version.isEmpty()) {
            version = BrowserSnifferImpl.parseVersion(userAgent, revisionLeadings, revisionSeparators);
        }
        request.setAttribute("BROWSER_SNIFFER_VERSION", (Object)version);
        return version;
    }

    public boolean isAir(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("adobeair");
    }

    public boolean isAndroid(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("android");
    }

    public boolean isChrome(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("chrome");
    }

    public boolean isFirefox(HttpServletRequest request) {
        return this._isFirefox(this.getUserAgent(request));
    }

    public boolean isGecko(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("gecko");
    }

    public boolean isIe(HttpServletRequest request) {
        return this.isIe(this.getUserAgent(request));
    }

    public boolean isIeOnWin32(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return this.isIe(userAgent) && !userAgent.contains("wow64") && !userAgent.contains("win64");
    }

    public boolean isIeOnWin64(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return this.isIe(userAgent) && (userAgent.contains("wow64") || userAgent.contains("win64"));
    }

    public boolean isIphone(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("iphone");
    }

    public boolean isLinux(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("linux");
    }

    public boolean isMac(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("mac");
    }

    public boolean isMobile(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("mobile") || userAgent.contains("android") && userAgent.contains("nexus");
    }

    public boolean isMozilla(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("mozilla") && !userAgent.contains("compatible") && !userAgent.contains("webkit");
    }

    public boolean isOpera(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("opera");
    }

    public boolean isRtf(HttpServletRequest request) {
        if (this.isAndroid(request)) {
            return true;
        }
        if (this.isChrome(request)) {
            return true;
        }
        float majorVersion = this.getMajorVersion(request);
        if (this.isIe(request) && (double)majorVersion >= 5.5) {
            return true;
        }
        if (this.isMozilla(request) && (double)majorVersion >= 1.3) {
            return true;
        }
        if (this.isOpera(request)) {
            if (this.isMobile(request) && (double)majorVersion >= 10.0) {
                return true;
            }
            if (!this.isMobile(request)) {
                return true;
            }
        }
        if (this.isSafari(request)) {
            if (this.isMobile(request) && (double)majorVersion >= 5.0) {
                return true;
            }
            if (!this.isMobile(request) && (double)majorVersion >= 3.0) {
                return true;
            }
        }
        return false;
    }

    public boolean isSafari(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return this.isWebKit(request) && userAgent.contains("safari");
    }

    public boolean isSun(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("sunos");
    }

    public boolean isWebKit(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        for (String webKitAlias : _WEBKIT_ALIASES) {
            if (!userAgent.contains(webKitAlias)) continue;
            return true;
        }
        return false;
    }

    public boolean isWindows(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        for (String windowsAlias : _WINDOWS_ALIASES) {
            if (!userAgent.contains(windowsAlias)) continue;
            return true;
        }
        return false;
    }

    protected static String parseVersion(String userAgent, String[] leadings, char[] separators) {
        for (String leading : leadings) {
            int index = 0;
            while ((index = userAgent.indexOf(leading, index)) >= 0 && (index += leading.length()) + 2 <= userAgent.length()) {
                char c2;
                char c1 = userAgent.charAt(index);
                if (((c2 = userAgent.charAt(++index)) < '0' || c2 > '9') && c2 != '.') continue;
                for (char separator : separators) {
                    if (c1 != separator) {
                        continue;
                    }
                    int majorStart = index;
                    int majorEnd = index + 1;
                    for (int i = majorStart; i < userAgent.length(); ++i) {
                        char c = userAgent.charAt(i);
                        if (c >= '0' && c <= '9') continue;
                        majorEnd = i;
                        break;
                    }
                    String major = userAgent.substring(majorStart, majorEnd);
                    if (userAgent.charAt(majorEnd) != '.') {
                        return major;
                    }
                    int minorStart = majorEnd + 1;
                    int minorEnd = userAgent.length();
                    for (int i = minorStart; i < userAgent.length(); ++i) {
                        char c = userAgent.charAt(i);
                        if (c >= '0' && c <= '9') continue;
                        minorEnd = i;
                        break;
                    }
                    String minor = userAgent.substring(minorStart, minorEnd);
                    return major.concat(".").concat(minor);
                }
            }
        }
        return "";
    }

    protected String getAccept(HttpServletRequest request) {
        String accept = "";
        if (request == null) {
            return accept;
        }
        accept = String.valueOf(request.getAttribute("ACCEPT"));
        if (Validator.isNotNull((String)accept)) {
            return accept;
        }
        accept = request.getHeader("ACCEPT");
        accept = accept != null ? StringUtil.toLowerCase((String)accept) : "";
        request.setAttribute("ACCEPT", (Object)accept);
        return accept;
    }

    protected String getUserAgent(HttpServletRequest request) {
        if (request == null) {
            return "";
        }
        Object userAgentObject = request.getAttribute("User-Agent");
        if (userAgentObject != null) {
            return userAgentObject.toString();
        }
        String userAgent = request.getHeader("User-Agent");
        userAgent = userAgent != null ? StringUtil.toLowerCase((String)userAgent) : "";
        request.setAttribute("User-Agent", (Object)userAgent);
        return userAgent;
    }

    protected boolean isIe(String userAgent) {
        return (userAgent.contains("msie") || userAgent.contains("trident")) && !userAgent.contains("opera");
    }

    private boolean _isFirefox(String userAgent) {
        if (!this._isMozilla(userAgent)) {
            return false;
        }
        for (String firefoxAlias : _FIREFOX_ALIASES) {
            if (!userAgent.contains(firefoxAlias)) continue;
            return true;
        }
        return false;
    }

    private boolean _isMozilla(String userAgent) {
        if (userAgent.contains("compatible")) {
            return false;
        }
        if (userAgent.contains("webkit")) {
            return false;
        }
        return userAgent.contains("mozilla");
    }
}

