/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.NoSuchRegionException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.service.persistence.RegionPersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.impl.RegionImpl;
import com.liferay.portal.model.impl.RegionModelImpl;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ProviderType
public class RegionPersistenceImpl
extends BasePersistenceImpl<Region>
implements RegionPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = RegionImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionModelImpl.FINDER_CACHE_ENABLED, RegionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionModelImpl.FINDER_CACHE_ENABLED, RegionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_COUNTRYID = new FinderPath(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionModelImpl.FINDER_CACHE_ENABLED, RegionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCountryId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_COUNTRYID = new FinderPath(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionModelImpl.FINDER_CACHE_ENABLED, RegionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCountryId", new String[]{Long.class.getName()}, 10L);
    public static final FinderPath FINDER_PATH_COUNT_BY_COUNTRYID = new FinderPath(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCountryId", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_COUNTRYID_COUNTRYID_2 = "region.countryId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_ACTIVE = new FinderPath(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionModelImpl.FINDER_CACHE_ENABLED, RegionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByActive", new String[]{Boolean.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ACTIVE = new FinderPath(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionModelImpl.FINDER_CACHE_ENABLED, RegionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByActive", new String[]{Boolean.class.getName()}, 9L);
    public static final FinderPath FINDER_PATH_COUNT_BY_ACTIVE = new FinderPath(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByActive", new String[]{Boolean.class.getName()});
    private static final String _FINDER_COLUMN_ACTIVE_ACTIVE_2 = "region.active = ?";
    public static final FinderPath FINDER_PATH_FETCH_BY_C_R = new FinderPath(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionModelImpl.FINDER_CACHE_ENABLED, RegionImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByC_R", new String[]{Long.class.getName(), String.class.getName()}, 6L);
    public static final FinderPath FINDER_PATH_COUNT_BY_C_R = new FinderPath(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_R", new String[]{Long.class.getName(), String.class.getName()});
    private static final String _FINDER_COLUMN_C_R_COUNTRYID_2 = "region.countryId = ? AND ";
    private static final String _FINDER_COLUMN_C_R_REGIONCODE_1 = "region.regionCode IS NULL";
    private static final String _FINDER_COLUMN_C_R_REGIONCODE_2 = "region.regionCode = ?";
    private static final String _FINDER_COLUMN_C_R_REGIONCODE_3 = "(region.regionCode IS NULL OR region.regionCode = '')";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_C_A = new FinderPath(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionModelImpl.FINDER_CACHE_ENABLED, RegionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_A", new String[]{Long.class.getName(), Boolean.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_A = new FinderPath(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionModelImpl.FINDER_CACHE_ENABLED, RegionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_A", new String[]{Long.class.getName(), Boolean.class.getName()}, 11L);
    public static final FinderPath FINDER_PATH_COUNT_BY_C_A = new FinderPath(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_A", new String[]{Long.class.getName(), Boolean.class.getName()});
    private static final String _FINDER_COLUMN_C_A_COUNTRYID_2 = "region.countryId = ? AND ";
    private static final String _FINDER_COLUMN_C_A_ACTIVE_2 = "region.active = ?";
    protected EntityCache entityCache = EntityCacheUtil.getEntityCache();
    protected FinderCache finderCache = FinderCacheUtil.getFinderCache();
    private static final String _SQL_SELECT_REGION = "SELECT region FROM Region region";
    private static final String _SQL_SELECT_REGION_WHERE_PKS_IN = "SELECT region FROM Region region WHERE regionId IN (";
    private static final String _SQL_SELECT_REGION_WHERE = "SELECT region FROM Region region WHERE ";
    private static final String _SQL_COUNT_REGION = "SELECT COUNT(region) FROM Region region";
    private static final String _SQL_COUNT_REGION_WHERE = "SELECT COUNT(region) FROM Region region WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "region.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Region exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Region exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(RegionPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"active"});

    public List<Region> findByCountryId(long countryId) {
        return this.findByCountryId(countryId, -1, -1, null);
    }

    public List<Region> findByCountryId(long countryId, int start, int end) {
        return this.findByCountryId(countryId, start, end, null);
    }

    public List<Region> findByCountryId(long countryId, int start, int end, OrderByComparator<Region> orderByComparator) {
        return this.findByCountryId(countryId, start, end, orderByComparator, true);
    }

    public List<Region> findByCountryId(long countryId, int start, int end, OrderByComparator<Region> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_COUNTRYID;
            finderArgs = new Object[]{countryId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_COUNTRYID;
            finderArgs = new Object[]{countryId, start, end, orderByComparator};
        }
        List<Region> list = null;
        if (retrieveFromCache && (list = (List<Region>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Region region : list) {
                if (countryId == region.getCountryId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_REGION_WHERE);
            query.append(_FINDER_COLUMN_COUNTRYID_COUNTRYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY region.name ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(countryId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Region findByCountryId_First(long countryId, OrderByComparator<Region> orderByComparator) throws NoSuchRegionException {
        Region region = this.fetchByCountryId_First(countryId, orderByComparator);
        if (region != null) {
            return region;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("countryId=");
        msg.append(countryId);
        msg.append("}");
        throw new NoSuchRegionException(msg.toString());
    }

    public Region fetchByCountryId_First(long countryId, OrderByComparator<Region> orderByComparator) {
        List<Region> list = this.findByCountryId(countryId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Region findByCountryId_Last(long countryId, OrderByComparator<Region> orderByComparator) throws NoSuchRegionException {
        Region region = this.fetchByCountryId_Last(countryId, orderByComparator);
        if (region != null) {
            return region;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("countryId=");
        msg.append(countryId);
        msg.append("}");
        throw new NoSuchRegionException(msg.toString());
    }

    public Region fetchByCountryId_Last(long countryId, OrderByComparator<Region> orderByComparator) {
        int count = this.countByCountryId(countryId);
        if (count == 0) {
            return null;
        }
        List<Region> list = this.findByCountryId(countryId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Region[] findByCountryId_PrevAndNext(long regionId, long countryId, OrderByComparator<Region> orderByComparator) throws NoSuchRegionException {
        Region region = this.findByPrimaryKey(regionId);
        Session session = null;
        try {
            session = this.openSession();
            Region[] array = new RegionImpl[]{this.getByCountryId_PrevAndNext(session, region, countryId, orderByComparator, true), region, this.getByCountryId_PrevAndNext(session, region, countryId, orderByComparator, false)};
            Region[] regionArray = array;
            return regionArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Region getByCountryId_PrevAndNext(Session session, Region region, long countryId, OrderByComparator<Region> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_REGION_WHERE);
        query.append(_FINDER_COLUMN_COUNTRYID_COUNTRYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY region.name ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(countryId);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)region)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Region)list.get(1);
        }
        return null;
    }

    public void removeByCountryId(long countryId) {
        for (Region region : this.findByCountryId(countryId, -1, -1, null)) {
            this.remove((BaseModel)region);
        }
    }

    public int countByCountryId(long countryId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_COUNTRYID;
        Object[] finderArgs = new Object[]{countryId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_REGION_WHERE);
            query.append(_FINDER_COLUMN_COUNTRYID_COUNTRYID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(countryId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Region> findByActive(boolean active) {
        return this.findByActive(active, -1, -1, null);
    }

    public List<Region> findByActive(boolean active, int start, int end) {
        return this.findByActive(active, start, end, null);
    }

    public List<Region> findByActive(boolean active, int start, int end, OrderByComparator<Region> orderByComparator) {
        return this.findByActive(active, start, end, orderByComparator, true);
    }

    public List<Region> findByActive(boolean active, int start, int end, OrderByComparator<Region> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ACTIVE;
            finderArgs = new Object[]{active};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_ACTIVE;
            finderArgs = new Object[]{active, start, end, orderByComparator};
        }
        List<Region> list = null;
        if (retrieveFromCache && (list = (List<Region>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Region region : list) {
                if (active == region.getActive()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_REGION_WHERE);
            query.append("region.active = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY region.name ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(active);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Region findByActive_First(boolean active, OrderByComparator<Region> orderByComparator) throws NoSuchRegionException {
        Region region = this.fetchByActive_First(active, orderByComparator);
        if (region != null) {
            return region;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("active=");
        msg.append(active);
        msg.append("}");
        throw new NoSuchRegionException(msg.toString());
    }

    public Region fetchByActive_First(boolean active, OrderByComparator<Region> orderByComparator) {
        List<Region> list = this.findByActive(active, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Region findByActive_Last(boolean active, OrderByComparator<Region> orderByComparator) throws NoSuchRegionException {
        Region region = this.fetchByActive_Last(active, orderByComparator);
        if (region != null) {
            return region;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("active=");
        msg.append(active);
        msg.append("}");
        throw new NoSuchRegionException(msg.toString());
    }

    public Region fetchByActive_Last(boolean active, OrderByComparator<Region> orderByComparator) {
        int count = this.countByActive(active);
        if (count == 0) {
            return null;
        }
        List<Region> list = this.findByActive(active, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Region[] findByActive_PrevAndNext(long regionId, boolean active, OrderByComparator<Region> orderByComparator) throws NoSuchRegionException {
        Region region = this.findByPrimaryKey(regionId);
        Session session = null;
        try {
            session = this.openSession();
            Region[] array = new RegionImpl[]{this.getByActive_PrevAndNext(session, region, active, orderByComparator, true), region, this.getByActive_PrevAndNext(session, region, active, orderByComparator, false)};
            Region[] regionArray = array;
            return regionArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Region getByActive_PrevAndNext(Session session, Region region, boolean active, OrderByComparator<Region> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_REGION_WHERE);
        query.append("region.active = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY region.name ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(active);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)region)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Region)list.get(1);
        }
        return null;
    }

    public void removeByActive(boolean active) {
        for (Region region : this.findByActive(active, -1, -1, null)) {
            this.remove((BaseModel)region);
        }
    }

    public int countByActive(boolean active) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_ACTIVE;
        Object[] finderArgs = new Object[]{active};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_REGION_WHERE);
            query.append("region.active = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(active);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Region findByC_R(long countryId, String regionCode) throws NoSuchRegionException {
        Region region = this.fetchByC_R(countryId, regionCode);
        if (region == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("countryId=");
            msg.append(countryId);
            msg.append(", regionCode=");
            msg.append(regionCode);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchRegionException(msg.toString());
        }
        return region;
    }

    public Region fetchByC_R(long countryId, String regionCode) {
        return this.fetchByC_R(countryId, regionCode, true);
    }

    public Region fetchByC_R(long countryId, String regionCode, boolean retrieveFromCache) {
        Region region;
        Object[] finderArgs = new Object[]{countryId, regionCode};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(FINDER_PATH_FETCH_BY_C_R, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof Region && (countryId != (region = (Region)result).getCountryId() || !Objects.equals(regionCode, region.getRegionCode()))) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_REGION_WHERE);
            query.append("region.countryId = ? AND ");
            boolean bindRegionCode = false;
            if (regionCode == null) {
                query.append(_FINDER_COLUMN_C_R_REGIONCODE_1);
            } else if (regionCode.equals("")) {
                query.append(_FINDER_COLUMN_C_R_REGIONCODE_3);
            } else {
                bindRegionCode = true;
                query.append(_FINDER_COLUMN_C_R_REGIONCODE_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(countryId);
                if (bindRegionCode) {
                    qPos.add(regionCode);
                }
                if ((list = q.list()).isEmpty()) {
                    this.finderCache.putResult(FINDER_PATH_FETCH_BY_C_R, finderArgs, (Object)list);
                } else {
                    Region region2 = (Region)list.get(0);
                    result = region2;
                    this.cacheResult(region2);
                    if (region2.getCountryId() != countryId || region2.getRegionCode() == null || !region2.getRegionCode().equals(regionCode)) {
                        this.finderCache.putResult(FINDER_PATH_FETCH_BY_C_R, finderArgs, (Object)region2);
                    }
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_FETCH_BY_C_R, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Region)result;
    }

    public Region removeByC_R(long countryId, String regionCode) throws NoSuchRegionException {
        Region region = this.findByC_R(countryId, regionCode);
        return (Region)this.remove((BaseModel)region);
    }

    public int countByC_R(long countryId, String regionCode) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_C_R;
        Object[] finderArgs = new Object[]{countryId, regionCode};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_REGION_WHERE);
            query.append("region.countryId = ? AND ");
            boolean bindRegionCode = false;
            if (regionCode == null) {
                query.append(_FINDER_COLUMN_C_R_REGIONCODE_1);
            } else if (regionCode.equals("")) {
                query.append(_FINDER_COLUMN_C_R_REGIONCODE_3);
            } else {
                bindRegionCode = true;
                query.append(_FINDER_COLUMN_C_R_REGIONCODE_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(countryId);
                if (bindRegionCode) {
                    qPos.add(regionCode);
                }
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Region> findByC_A(long countryId, boolean active) {
        return this.findByC_A(countryId, active, -1, -1, null);
    }

    public List<Region> findByC_A(long countryId, boolean active, int start, int end) {
        return this.findByC_A(countryId, active, start, end, null);
    }

    public List<Region> findByC_A(long countryId, boolean active, int start, int end, OrderByComparator<Region> orderByComparator) {
        return this.findByC_A(countryId, active, start, end, orderByComparator, true);
    }

    public List<Region> findByC_A(long countryId, boolean active, int start, int end, OrderByComparator<Region> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_A;
            finderArgs = new Object[]{countryId, active};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_C_A;
            finderArgs = new Object[]{countryId, active, start, end, orderByComparator};
        }
        List<Region> list = null;
        if (retrieveFromCache && (list = (List<Region>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Region region : list) {
                if (countryId == region.getCountryId() && active == region.getActive()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_REGION_WHERE);
            query.append("region.countryId = ? AND ");
            query.append("region.active = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY region.name ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(countryId);
                qPos.add(active);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Region findByC_A_First(long countryId, boolean active, OrderByComparator<Region> orderByComparator) throws NoSuchRegionException {
        Region region = this.fetchByC_A_First(countryId, active, orderByComparator);
        if (region != null) {
            return region;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("countryId=");
        msg.append(countryId);
        msg.append(", active=");
        msg.append(active);
        msg.append("}");
        throw new NoSuchRegionException(msg.toString());
    }

    public Region fetchByC_A_First(long countryId, boolean active, OrderByComparator<Region> orderByComparator) {
        List<Region> list = this.findByC_A(countryId, active, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Region findByC_A_Last(long countryId, boolean active, OrderByComparator<Region> orderByComparator) throws NoSuchRegionException {
        Region region = this.fetchByC_A_Last(countryId, active, orderByComparator);
        if (region != null) {
            return region;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("countryId=");
        msg.append(countryId);
        msg.append(", active=");
        msg.append(active);
        msg.append("}");
        throw new NoSuchRegionException(msg.toString());
    }

    public Region fetchByC_A_Last(long countryId, boolean active, OrderByComparator<Region> orderByComparator) {
        int count = this.countByC_A(countryId, active);
        if (count == 0) {
            return null;
        }
        List<Region> list = this.findByC_A(countryId, active, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Region[] findByC_A_PrevAndNext(long regionId, long countryId, boolean active, OrderByComparator<Region> orderByComparator) throws NoSuchRegionException {
        Region region = this.findByPrimaryKey(regionId);
        Session session = null;
        try {
            session = this.openSession();
            Region[] array = new RegionImpl[]{this.getByC_A_PrevAndNext(session, region, countryId, active, orderByComparator, true), region, this.getByC_A_PrevAndNext(session, region, countryId, active, orderByComparator, false)};
            Region[] regionArray = array;
            return regionArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Region getByC_A_PrevAndNext(Session session, Region region, long countryId, boolean active, OrderByComparator<Region> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_REGION_WHERE);
        query.append("region.countryId = ? AND ");
        query.append("region.active = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY region.name ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(countryId);
        qPos.add(active);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)region)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Region)list.get(1);
        }
        return null;
    }

    public void removeByC_A(long countryId, boolean active) {
        for (Region region : this.findByC_A(countryId, active, -1, -1, null)) {
            this.remove((BaseModel)region);
        }
    }

    public int countByC_A(long countryId, boolean active) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_C_A;
        Object[] finderArgs = new Object[]{countryId, active};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_REGION_WHERE);
            query.append("region.countryId = ? AND ");
            query.append("region.active = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(countryId);
                qPos.add(active);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public RegionPersistenceImpl() {
        this.setModelClass(Region.class);
    }

    public void cacheResult(Region region) {
        this.entityCache.putResult(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionImpl.class, (Serializable)Long.valueOf(region.getPrimaryKey()), (Serializable)region);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_C_R, new Object[]{region.getCountryId(), region.getRegionCode()}, (Object)region);
        region.resetOriginalValues();
    }

    public void cacheResult(List<Region> regions) {
        for (Region region : regions) {
            if (this.entityCache.getResult(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionImpl.class, (Serializable)Long.valueOf(region.getPrimaryKey())) == null) {
                this.cacheResult(region);
                continue;
            }
            region.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(RegionImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(Region region) {
        this.entityCache.removeResult(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionImpl.class, (Serializable)Long.valueOf(region.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((RegionModelImpl)region, true);
    }

    public void clearCache(List<Region> regions) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Region region : regions) {
            this.entityCache.removeResult(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionImpl.class, (Serializable)Long.valueOf(region.getPrimaryKey()));
            this.clearUniqueFindersCache((RegionModelImpl)region, true);
        }
    }

    protected void cacheUniqueFindersCache(RegionModelImpl regionModelImpl) {
        Object[] args = new Object[]{regionModelImpl.getCountryId(), regionModelImpl.getRegionCode()};
        this.finderCache.putResult(FINDER_PATH_COUNT_BY_C_R, args, (Object)1L, false);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_C_R, args, (Object)regionModelImpl, false);
    }

    protected void clearUniqueFindersCache(RegionModelImpl regionModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{regionModelImpl.getCountryId(), regionModelImpl.getRegionCode()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_C_R, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_C_R, args);
        }
        if ((regionModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_C_R.getColumnBitmask()) != 0L) {
            args = new Object[]{regionModelImpl.getOriginalCountryId(), regionModelImpl.getOriginalRegionCode()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_C_R, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_C_R, args);
        }
    }

    public Region create(long regionId) {
        RegionImpl region = new RegionImpl();
        region.setNew(true);
        region.setPrimaryKey(regionId);
        return region;
    }

    public Region remove(long regionId) throws NoSuchRegionException {
        return this.remove(Long.valueOf(regionId));
    }

    public Region remove(Serializable primaryKey) throws NoSuchRegionException {
        Session session = null;
        try {
            session = this.openSession();
            Region region = (Region)session.get(RegionImpl.class, primaryKey);
            if (region == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchRegionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Region region2 = (Region)this.remove((BaseModel)region);
            return region2;
        }
        catch (NoSuchRegionException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Region removeImpl(Region region) {
        region = this.toUnwrappedModel(region);
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)region)) {
                region = (Region)session.get(RegionImpl.class, region.getPrimaryKeyObj());
            }
            if (region != null) {
                session.delete((Object)region);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (region != null) {
            this.clearCache(region);
        }
        return region;
    }

    public Region updateImpl(Region region) {
        region = this.toUnwrappedModel(region);
        boolean isNew = region.isNew();
        RegionModelImpl regionModelImpl = (RegionModelImpl)region;
        Session session = null;
        try {
            session = this.openSession();
            if (region.isNew()) {
                session.save((Object)region);
                region.setNew(false);
            } else {
                region = (Region)session.merge((Object)region);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!RegionModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{regionModelImpl.getCountryId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_COUNTRYID, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_COUNTRYID, args);
            args = new Object[]{regionModelImpl.getActive()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_ACTIVE, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ACTIVE, args);
            args = new Object[]{regionModelImpl.getCountryId(), regionModelImpl.getActive()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_C_A, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_A, args);
            this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((regionModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_COUNTRYID.getColumnBitmask()) != 0L) {
                args = new Object[]{regionModelImpl.getOriginalCountryId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_COUNTRYID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_COUNTRYID, args);
                args = new Object[]{regionModelImpl.getCountryId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_COUNTRYID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_COUNTRYID, args);
            }
            if ((regionModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ACTIVE.getColumnBitmask()) != 0L) {
                args = new Object[]{regionModelImpl.getOriginalActive()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_ACTIVE, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ACTIVE, args);
                args = new Object[]{regionModelImpl.getActive()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_ACTIVE, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ACTIVE, args);
            }
            if ((regionModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_A.getColumnBitmask()) != 0L) {
                args = new Object[]{regionModelImpl.getOriginalCountryId(), regionModelImpl.getOriginalActive()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_C_A, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_A, args);
                args = new Object[]{regionModelImpl.getCountryId(), regionModelImpl.getActive()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_C_A, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_A, args);
            }
        }
        this.entityCache.putResult(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionImpl.class, (Serializable)Long.valueOf(region.getPrimaryKey()), (Serializable)region, false);
        this.clearUniqueFindersCache(regionModelImpl, false);
        this.cacheUniqueFindersCache(regionModelImpl);
        region.resetOriginalValues();
        return region;
    }

    protected Region toUnwrappedModel(Region region) {
        if (region instanceof RegionImpl) {
            return region;
        }
        RegionImpl regionImpl = new RegionImpl();
        regionImpl.setNew(region.isNew());
        regionImpl.setPrimaryKey(region.getPrimaryKey());
        regionImpl.setMvccVersion(region.getMvccVersion());
        regionImpl.setRegionId(region.getRegionId());
        regionImpl.setCountryId(region.getCountryId());
        regionImpl.setRegionCode(region.getRegionCode());
        regionImpl.setName(region.getName());
        regionImpl.setActive(region.isActive());
        return regionImpl;
    }

    public Region findByPrimaryKey(Serializable primaryKey) throws NoSuchRegionException {
        Region region = this.fetchByPrimaryKey(primaryKey);
        if (region == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchRegionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return region;
    }

    public Region findByPrimaryKey(long regionId) throws NoSuchRegionException {
        return this.findByPrimaryKey(Long.valueOf(regionId));
    }

    public Region fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        Region region = (Region)serializable;
        if (region == null) {
            Session session = null;
            try {
                session = this.openSession();
                region = (Region)session.get(RegionImpl.class, primaryKey);
                if (region != null) {
                    this.cacheResult(region);
                } else {
                    this.entityCache.putResult(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception e) {
                this.entityCache.removeResult(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionImpl.class, primaryKey);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return region;
    }

    public Region fetchByPrimaryKey(long regionId) {
        return this.fetchByPrimaryKey(Long.valueOf(regionId));
    }

    public Map<Serializable, Region> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, Region> map = new HashMap<Serializable, Region>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            Region region = this.fetchByPrimaryKey(primaryKey);
            if (region != null) {
                map.put(primaryKey, region);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map.put(serializable, (Region)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler query = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        query.append(_SQL_SELECT_REGION_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            query.append(((Long)serializable).longValue());
            query.append(",");
        }
        query.setIndex(query.index() - 1);
        query.append(")");
        String string = query.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query q = session.createQuery(string);
            for (Region region : q.list()) {
                map.put(region.getPrimaryKeyObj(), region);
                this.cacheResult(region);
                uncachedPrimaryKeys.remove(region.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception e) {
            try {
                throw this.processException(e);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map;
    }

    public List<Region> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<Region> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<Region> findAll(int start, int end, OrderByComparator<Region> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<Region> findAll(int start, int end, OrderByComparator<Region> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (retrieveFromCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_REGION);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_REGION;
                if (pagination) {
                    sql = sql.concat(" ORDER BY region.name ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (Region region : this.findAll()) {
            this.remove((BaseModel)region);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_REGION);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return RegionModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
    }

    public void destroy() {
        this.entityCache.removeCache(RegionImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

