/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.NoSuchResourcePermissionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Resource;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionUpdateHandler;
import com.liferay.portal.kernel.security.permission.PermissionUpdateHandlerRegistryUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ExceptionRetryAcceptor;
import com.liferay.portal.kernel.spring.aop.Property;
import com.liferay.portal.kernel.spring.aop.Retry;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.base.ResourcePermissionLocalServiceBaseImpl;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.ResourcePermissionsThreadLocal;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class ResourcePermissionLocalServiceImpl
extends ResourcePermissionLocalServiceBaseImpl {
    public static final String[] EMPTY_ACTION_IDS = new String[]{null};
    private static final String _FIND_MISSING_RESOURCE_PERMISSIONS = ResourcePermissionLocalServiceImpl.class.getName() + ".findMissingResourcePermissions";
    private static final String _UPDATE_ACTION_IDS = ResourcePermissionLocalServiceImpl.class.getName() + ".updateActionIds";

    @Retry(acceptor=ExceptionRetryAcceptor.class, properties={@Property(name="EXCEPTION_NAME", value="org.springframework.dao.DataIntegrityViolationException")})
    public void addResourcePermission(long companyId, String name, int scope, String primKey, long roleId, String actionId) throws PortalException {
        if (scope == 1) {
            this.removeResourcePermissions(companyId, name, 2, roleId, actionId);
        } else if (scope == 2) {
            this.removeResourcePermissions(companyId, name, 1, roleId, actionId);
        } else if (scope == 4) {
            throw new NoSuchResourcePermissionException();
        }
        this.updateResourcePermission(companyId, name, scope, primKey, roleId, 0L, new String[]{actionId}, 1);
    }

    public void addResourcePermissions(String resourceName, String roleName, int scope, long resourceActionBitwiseValue) {
        List roles = this.rolePersistence.findByName(roleName);
        if (roles.isEmpty()) {
            return;
        }
        Session session = this.resourcePermissionPersistence.openSession();
        try {
            String sql = CustomSQLUtil.get((String)_UPDATE_ACTION_IDS);
            sql = StringUtil.replace((String)sql, (String)"[$ROLE_ID$]", (String)ListUtil.toString((List)roles, (Accessor)Role.ROLE_ID_ACCESSOR));
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            QueryPos qPos = QueryPos.getInstance((Query)sqlQuery);
            qPos.add(resourceActionBitwiseValue);
            qPos.add(resourceActionBitwiseValue);
            qPos.add(resourceName);
            qPos.add(scope);
            sqlQuery.executeUpdate();
            sql = CustomSQLUtil.get((String)_FIND_MISSING_RESOURCE_PERMISSIONS);
            sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("companyId", Type.LONG);
            sqlQuery.addScalar("name", Type.STRING);
            sqlQuery.addScalar("scope", Type.INTEGER);
            sqlQuery.addScalar("primKey", Type.STRING);
            sqlQuery.addScalar("roleId", Type.LONG);
            qPos = QueryPos.getInstance((Query)sqlQuery);
            qPos.add(resourceName);
            qPos.add(scope);
            qPos.add(roleName);
            List resourcePermissionArrays = sqlQuery.list(true);
            if (resourcePermissionArrays.isEmpty()) {
                return;
            }
            for (Object[] resourcePermissionArray : resourcePermissionArrays) {
                long resourcePermissionId = this.counterLocalService.increment(ResourcePermission.class.getName());
                ResourcePermission resourcePermission = this.resourcePermissionPersistence.create(resourcePermissionId);
                resourcePermission.setCompanyId(((Long)resourcePermissionArray[0]).longValue());
                resourcePermission.setName((String)resourcePermissionArray[1]);
                resourcePermission.setScope(((Integer)resourcePermissionArray[2]).intValue());
                String primKey = (String)resourcePermissionArray[3];
                resourcePermission.setPrimKey(primKey);
                resourcePermission.setPrimKeyId(GetterUtil.getLong((String)primKey));
                resourcePermission.setRoleId(((Long)resourcePermissionArray[4]).longValue());
                resourcePermission.setActionIds(resourceActionBitwiseValue);
                resourcePermission.setViewActionId(resourceActionBitwiseValue % 2L == 1L);
                session.save((Object)resourcePermission);
                PermissionCacheUtil.clearResourcePermissionCache(resourcePermission.getScope(), resourcePermission.getName(), resourcePermission.getPrimKey());
            }
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.resourcePermissionPersistence.closeSession(session);
            this.resourcePermissionPersistence.clearCache();
        }
    }

    public void deleteResourcePermissions(long companyId, String name, int scope, long primKey) throws PortalException {
        this.deleteResourcePermissions(companyId, name, scope, String.valueOf(primKey));
    }

    public void deleteResourcePermissions(long companyId, String name, int scope, String primKey) throws PortalException {
        List resourcePermissions = this.resourcePermissionPersistence.findByC_N_S_P(companyId, name, scope, primKey);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            this.deleteResourcePermission(resourcePermission.getResourcePermissionId());
        }
    }

    public ResourcePermission fetchResourcePermission(long companyId, String name, int scope, String primKey, long roleId) {
        return this.resourcePermissionPersistence.fetchByC_N_S_P_R(companyId, name, scope, primKey, roleId);
    }

    public Map<Long, Set<String>> getAvailableResourcePermissionActionIds(long companyId, String name, int scope, String primKey, Collection<String> actionIds) {
        if (actionIds.isEmpty()) {
            return Collections.emptyMap();
        }
        List<ResourcePermission> resourcePermissions = this.getResourcePermissions(companyId, name, scope, primKey);
        HashMap<Long, Set<String>> roleIdsToActionIds = new HashMap<Long, Set<String>>(resourcePermissions.size());
        for (ResourcePermission resourcePermission : resourcePermissions) {
            if (resourcePermission.getActionIds() == 0L) {
                roleIdsToActionIds.put(resourcePermission.getRoleId(), Collections.emptySet());
                continue;
            }
            HashSet<String> availableActionIds = new HashSet<String>(actionIds.size());
            for (String actionId : actionIds) {
                if (!resourcePermission.hasActionId(actionId)) continue;
                availableActionIds.add(actionId);
            }
            if (availableActionIds.isEmpty()) continue;
            roleIdsToActionIds.put(resourcePermission.getRoleId(), availableActionIds);
        }
        return roleIdsToActionIds;
    }

    public List<String> getAvailableResourcePermissionActionIds(long companyId, String name, int scope, String primKey, long roleId, Collection<String> actionIds) throws PortalException {
        ResourcePermission resourcePermission = this.resourcePermissionPersistence.fetchByC_N_S_P_R(companyId, name, scope, primKey, roleId);
        if (resourcePermission == null) {
            return Collections.emptyList();
        }
        ArrayList<String> availableActionIds = new ArrayList<String>(actionIds.size());
        for (String actionId : actionIds) {
            ResourceAction resourceAction = this.resourceActionLocalService.getResourceAction(name, actionId);
            if (!this.hasActionId(resourcePermission, resourceAction)) continue;
            availableActionIds.add(actionId);
        }
        return availableActionIds;
    }

    @Deprecated
    public Map<Long, Set<String>> getAvailableResourcePermissionActionIds(long companyId, String name, int scope, String primKey, long[] roleIds, Collection<String> actionIds) {
        return this.getAvailableResourcePermissionActionIds(companyId, name, scope, primKey, new ArrayList<String>(actionIds));
    }

    public ResourcePermission getResourcePermission(long companyId, String name, int scope, String primKey, long roleId) throws PortalException {
        return this.resourcePermissionPersistence.findByC_N_S_P_R(companyId, name, scope, primKey, roleId);
    }

    public List<ResourcePermission> getResourcePermissions(long companyId, String name, int scope, String primKey) {
        return this.resourcePermissionPersistence.findByC_N_S_P(companyId, name, scope, primKey);
    }

    public int getResourcePermissionsCount(long companyId, String name, int scope, String primKey) {
        return this.resourcePermissionPersistence.countByC_N_S_P(companyId, name, scope, primKey);
    }

    public List<ResourcePermission> getResourceResourcePermissions(long companyId, long groupId, String name, String primKey) {
        return this.resourcePermissionFinder.findByResource(companyId, groupId, name, primKey);
    }

    public List<ResourcePermission> getRoleResourcePermissions(long roleId) {
        return this.resourcePermissionPersistence.findByRoleId(roleId);
    }

    public List<ResourcePermission> getRoleResourcePermissions(long roleId, int[] scopes, int start, int end) {
        return this.resourcePermissionFinder.findByR_S(roleId, scopes, start, end);
    }

    public List<Role> getRoles(long companyId, String name, int scope, String primKey, String actionId) throws PortalException {
        List resourcePermissions = this.resourcePermissionPersistence.findByC_N_S_P(companyId, name, scope, primKey);
        if (resourcePermissions.isEmpty()) {
            return Collections.emptyList();
        }
        ResourceAction resourceAction = this.resourceActionLocalService.getResourceAction(name, actionId);
        HashSet<Long> rolesIds = new HashSet<Long>();
        for (ResourcePermission resourcePermission : resourcePermissions) {
            if (!resourcePermission.hasAction(resourceAction)) continue;
            rolesIds.add(resourcePermission.getRoleId());
        }
        ArrayList<Role> roles = new ArrayList<Role>(rolesIds.size());
        Iterator iterator = rolesIds.iterator();
        while (iterator.hasNext()) {
            long roleId = (Long)iterator.next();
            roles.add(this.roleLocalService.getRole(roleId));
        }
        return roles;
    }

    public List<ResourcePermission> getScopeResourcePermissions(int[] scopes) {
        return this.resourcePermissionPersistence.findByScope(scopes);
    }

    public boolean hasActionId(ResourcePermission resourcePermission, ResourceAction resourceAction) {
        long bitwiseValue;
        long actionIds = resourcePermission.getActionIds();
        return (actionIds & (bitwiseValue = resourceAction.getBitwiseValue())) == bitwiseValue;
    }

    public boolean hasResourcePermission(List<Resource> resources, long[] roleIds, String actionId) throws PortalException {
        if (roleIds.length == 0) {
            return false;
        }
        int size = resources.size();
        if (size < 2) {
            throw new IllegalArgumentException("The list of resources must contain at least two values");
        }
        Resource individualResource = resources.get(0);
        if (individualResource.getScope() != 4) {
            throw new IllegalArgumentException("The first resource must be an individual scope");
        }
        Resource companyResource = resources.get(size - 1);
        if (companyResource.getScope() != 1) {
            throw new IllegalArgumentException("The last resource must be a company scope");
        }
        if (this.resourcePermissionPersistence.countByC_N_S_P(individualResource.getCompanyId(), individualResource.getName(), individualResource.getScope(), individualResource.getPrimKey()) < 1) {
            StringBundler sb = new StringBundler(9);
            sb.append("{companyId=");
            sb.append(individualResource.getCompanyId());
            sb.append(", name=");
            sb.append(individualResource.getName());
            sb.append(", primKey=");
            sb.append(individualResource.getPrimKey());
            sb.append(", scope=");
            sb.append(individualResource.getScope());
            sb.append("}");
            throw new NoSuchResourcePermissionException(sb.toString());
        }
        for (int i = size - 1; i >= 0; --i) {
            Resource resource = resources.get(i);
            if (!this.hasResourcePermission(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), roleIds, actionId)) continue;
            return true;
        }
        return false;
    }

    public boolean hasResourcePermission(long companyId, String name, int scope, String primKey, long roleId, String actionId) throws PortalException {
        ResourcePermission resourcePermission = this.resourcePermissionPersistence.fetchByC_N_S_P_R(companyId, name, scope, primKey, roleId);
        if (resourcePermission == null) {
            return false;
        }
        ResourceAction resourceAction = this.resourceActionLocalService.getResourceAction(name, actionId);
        return this.hasActionId(resourcePermission, resourceAction);
    }

    public boolean hasResourcePermission(long companyId, String name, int scope, String primKey, long[] roleIds, String actionId) throws PortalException {
        if (roleIds.length == 0) {
            return false;
        }
        ResourceAction resourceAction = this.resourceActionLocalService.getResourceAction(name, actionId);
        if (roleIds.length > PropsValues.PERMISSIONS_ROLE_RESOURCE_PERMISSION_QUERY_THRESHOLD) {
            int count = this.resourcePermissionFinder.countByC_N_S_P_R_A(companyId, name, scope, primKey, roleIds, resourceAction.getBitwiseValue());
            if (count > 0) {
                return true;
            }
        } else {
            List resourcePermissions = this.resourcePermissionPersistence.findByC_N_S_P_R(companyId, name, scope, primKey, roleIds);
            if (resourcePermissions.isEmpty()) {
                return false;
            }
            for (ResourcePermission resourcePermission : resourcePermissions) {
                if (!this.hasActionId(resourcePermission, resourceAction)) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public boolean[] hasResourcePermissions(long companyId, String name, int scope, String primKey, long[] roleIds, String actionId) throws PortalException {
        boolean[] hasResourcePermissions = new boolean[roleIds.length];
        if (roleIds.length == 0) {
            return hasResourcePermissions;
        }
        ResourceAction resourceAction = this.resourceActionLocalService.getResourceAction(name, actionId);
        List resourcePermissions = this.resourcePermissionPersistence.findByC_N_S_P_R(companyId, name, scope, primKey, roleIds);
        if (resourcePermissions.isEmpty()) {
            return hasResourcePermissions;
        }
        block0: for (ResourcePermission resourcePermission : resourcePermissions) {
            if (!this.hasActionId(resourcePermission, resourceAction)) continue;
            long roleId = resourcePermission.getRoleId();
            for (int i = 0; i < roleIds.length; ++i) {
                if (roleIds[i] != roleId) continue;
                hasResourcePermissions[i] = true;
                continue block0;
            }
        }
        return hasResourcePermissions;
    }

    public boolean hasScopeResourcePermission(long companyId, String name, int scope, long roleId, String actionId) throws PortalException {
        List resourcePermissions = this.resourcePermissionPersistence.findByC_N_S(companyId, name, scope);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            if (!this.hasResourcePermission(companyId, name, scope, resourcePermission.getPrimKey(), roleId, actionId)) continue;
            return true;
        }
        return false;
    }

    public void mergePermissions(long fromRoleId, long toRoleId) throws PortalException {
        Role fromRole = this.rolePersistence.findByPrimaryKey(fromRoleId);
        Role toRole = this.rolePersistence.findByPrimaryKey(toRoleId);
        if (fromRole.getType() != toRole.getType()) {
            throw new PortalException("Role types are mismatched");
        }
        if (toRole.isSystem()) {
            throw new PortalException("Cannot move permissions to system role");
        }
        if (fromRole.isSystem()) {
            throw new PortalException("Cannot move permissions from system role");
        }
        List<ResourcePermission> resourcePermissions = this.getRoleResourcePermissions(fromRoleId);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            resourcePermission.setRoleId(toRoleId);
            this.resourcePermissionPersistence.update((BaseModel)resourcePermission);
        }
        this.roleLocalService.deleteRole(fromRoleId);
    }

    public void reassignPermissions(long resourcePermissionId, long toRoleId) throws PortalException {
        ResourcePermission resourcePermission = this.getResourcePermission(resourcePermissionId);
        long companyId = resourcePermission.getCompanyId();
        String name = resourcePermission.getName();
        int scope = resourcePermission.getScope();
        String primKey = resourcePermission.getPrimKey();
        long fromRoleId = resourcePermission.getRoleId();
        Role toRole = this.roleLocalService.getRole(toRoleId);
        List actionIds = null;
        actionIds = toRole.getType() == 1 ? ResourceActionsUtil.getModelResourceActions((String)name) : ResourceActionsUtil.getModelResourceGroupDefaultActions((String)name);
        this.setResourcePermissions(companyId, name, scope, primKey, toRoleId, actionIds.toArray(new String[actionIds.size()]));
        this.resourcePermissionPersistence.remove(resourcePermissionId);
        List<ResourcePermission> resourcePermissions = this.getRoleResourcePermissions(fromRoleId);
        if (resourcePermissions.isEmpty()) {
            this.roleLocalService.deleteRole(fromRoleId);
        }
    }

    public void removeResourcePermission(long companyId, String name, int scope, String primKey, long roleId, String actionId) throws PortalException {
        this.updateResourcePermission(companyId, name, scope, primKey, roleId, 0L, new String[]{actionId}, 2);
    }

    public void removeResourcePermissions(long companyId, String name, int scope, long roleId, String actionId) throws PortalException {
        List resourcePermissions = this.resourcePermissionPersistence.findByC_N_S(companyId, name, scope);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            this.updateResourcePermission(companyId, name, scope, resourcePermission.getPrimKey(), roleId, 0L, new String[]{actionId}, 2);
        }
    }

    @Retry(acceptor=ExceptionRetryAcceptor.class, properties={@Property(name="EXCEPTION_NAME", value="org.springframework.dao.DataIntegrityViolationException")})
    public void setOwnerResourcePermissions(long companyId, String name, int scope, String primKey, long roleId, long ownerId, String[] actionIds) throws PortalException {
        this.updateResourcePermission(companyId, name, scope, primKey, roleId, ownerId, actionIds, 3);
    }

    @Retry(acceptor=ExceptionRetryAcceptor.class, properties={@Property(name="EXCEPTION_NAME", value="org.springframework.dao.DataIntegrityViolationException")})
    public void setResourcePermissions(long companyId, String name, int scope, String primKey, long roleId, String[] actionIds) throws PortalException {
        this.updateResourcePermission(companyId, name, scope, primKey, roleId, 0L, actionIds, 3);
    }

    @Retry(acceptor=ExceptionRetryAcceptor.class, properties={@Property(name="EXCEPTION_NAME", value="org.springframework.dao.DataIntegrityViolationException")})
    public void setResourcePermissions(long companyId, String name, int scope, String primKey, Map<Long, String[]> roleIdsToActionIds) throws PortalException {
        this.updateResourcePermission(companyId, name, scope, primKey, 0L, roleIdsToActionIds);
    }

    protected void doUpdateResourcePermission(long companyId, String name, int scope, String primKey, long ownerId, long roleId, String[] actionIds, int operator, boolean fetch) throws PortalException {
        ResourcePermission resourcePermission = null;
        Map<Long, ResourcePermission> resourcePermissionsMap = ResourcePermissionsThreadLocal.getResourcePermissions();
        if (resourcePermissionsMap != null) {
            resourcePermission = resourcePermissionsMap.get(roleId);
        } else if (fetch) {
            resourcePermission = this.resourcePermissionPersistence.fetchByC_N_S_P_R(companyId, name, scope, primKey, roleId);
        }
        if (resourcePermission == null) {
            if ((operator == 1 || operator == 3) && actionIds.length == 0) {
                return;
            }
            if (operator == 2) {
                return;
            }
            long resourcePermissionId = this.counterLocalService.increment(ResourcePermission.class.getName());
            resourcePermission = this.resourcePermissionPersistence.create(resourcePermissionId);
            resourcePermission.setCompanyId(companyId);
            resourcePermission.setName(name);
            resourcePermission.setScope(scope);
            resourcePermission.setPrimKey(primKey);
            resourcePermission.setPrimKeyId(GetterUtil.getLong((String)primKey));
            resourcePermission.setRoleId(roleId);
            resourcePermission.setOwnerId(ownerId);
            if (resourcePermissionsMap != null) {
                resourcePermissionsMap.put(roleId, resourcePermission);
            }
        }
        List unsupportedActionIds = Collections.emptyList();
        if ((operator == 1 || operator == 3) && this.isGuestRoleId(companyId, roleId)) {
            unsupportedActionIds = ResourceActionsUtil.getResourceGuestUnsupportedActions((String)name, (String)name);
        }
        long actionIdsLong = resourcePermission.getActionIds();
        if (operator == 3) {
            actionIdsLong = 0L;
        }
        for (String actionId : actionIds) {
            if (actionId == null) break;
            if (unsupportedActionIds.contains(actionId)) {
                throw new PrincipalException(actionId + "is not supported by role " + roleId);
            }
            ResourceAction resourceAction = this.resourceActionLocalService.getResourceAction(name, actionId);
            if (operator == 1 || operator == 3) {
                actionIdsLong |= resourceAction.getBitwiseValue();
                continue;
            }
            actionIdsLong &= resourceAction.getBitwiseValue() ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (actionIdsLong != resourcePermission.getActionIds() || resourcePermission.isNew()) {
            resourcePermission.setActionIds(actionIdsLong);
            resourcePermission.setViewActionId(actionIdsLong % 2L == 1L);
            this.resourcePermissionPersistence.update((BaseModel)resourcePermission);
        }
        IndexWriterHelperUtil.updatePermissionFields((String)name, (String)primKey);
    }

    protected boolean isGuestRoleId(long companyId, long roleId) throws PortalException {
        Role guestRole = this.roleLocalService.getRole(companyId, "Guest");
        return roleId == guestRole.getRoleId();
    }

    protected void updateResourcePermission(long companyId, String name, int scope, String primKey, long roleId, long ownerId, String[] actionIds, int operator) throws PortalException {
        this.doUpdateResourcePermission(companyId, name, scope, primKey, ownerId, roleId, actionIds, operator, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateResourcePermission(long companyId, String name, int scope, String primKey, long ownerId, Map<Long, String[]> roleIdsToActionIds) throws PortalException {
        boolean flushResourcePermissionEnabled = PermissionThreadLocal.isFlushResourcePermissionEnabled((String)name, (String)primKey);
        PermissionThreadLocal.setFlushResourcePermissionEnabled((String)name, (String)primKey, (boolean)false);
        try {
            String[] actionIds;
            long roleId;
            int start;
            long[] roleIds = ArrayUtil.toLongArray(roleIdsToActionIds.keySet());
            ArrayList resourcePermissions = new ArrayList(roleIds.length);
            int batchSize = 1000;
            for (start = 0; start < roleIds.length - batchSize; start += batchSize) {
                resourcePermissions.addAll(this.resourcePermissionPersistence.findByC_N_S_P_R(companyId, name, scope, primKey, ArrayUtil.subset((long[])roleIds, (int)start, (int)(start + batchSize))));
            }
            resourcePermissions.addAll(this.resourcePermissionPersistence.findByC_N_S_P_R(companyId, name, scope, primKey, ArrayUtil.subset((long[])roleIds, (int)start, (int)roleIds.length)));
            roleIdsToActionIds = new HashMap<Long, String[]>(roleIdsToActionIds);
            for (ResourcePermission resourcePermission : resourcePermissions) {
                roleId = resourcePermission.getRoleId();
                actionIds = roleIdsToActionIds.remove(roleId);
                this.doUpdateResourcePermission(companyId, name, scope, primKey, ownerId, roleId, actionIds, 3, true);
            }
            if (roleIdsToActionIds.isEmpty()) {
                return;
            }
            for (Map.Entry entry : roleIdsToActionIds.entrySet()) {
                roleId = (Long)entry.getKey();
                actionIds = (String[])entry.getValue();
                this.doUpdateResourcePermission(companyId, name, scope, primKey, ownerId, roleId, actionIds, 3, false);
            }
            if (!MergeLayoutPrototypesThreadLocal.isInProgress()) {
                TransactionCommitCallbackUtil.registerCallback((Callable)new UpdateResourcePermissionCallable(name, primKey));
            }
        }
        finally {
            PermissionThreadLocal.setFlushResourcePermissionEnabled((String)name, (String)primKey, (boolean)flushResourcePermissionEnabled);
            PermissionCacheUtil.clearResourcePermissionCache(scope, name, primKey);
            IndexWriterHelperUtil.updatePermissionFields((String)name, (String)primKey);
        }
    }

    private static class UpdateResourcePermissionCallable
    implements Callable<Void> {
        private final String _name;
        private final String _primKey;

        public UpdateResourcePermissionCallable(String name, String primKey) {
            this._name = name;
            this._primKey = primKey;
        }

        @Override
        public Void call() {
            PermissionUpdateHandler permissionUpdateHandler = PermissionUpdateHandlerRegistryUtil.getPermissionUpdateHandler((String)this._name);
            if (permissionUpdateHandler == null) {
                return null;
            }
            permissionUpdateHandler.updatedPermission(this._primKey);
            return null;
        }
    }
}

