/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.exception.NoSuchLayoutRevisionException;
import com.liferay.portal.kernel.exception.NoSuchPortletPreferencesException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.comparator.LayoutRevisionCreateDateComparator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.service.base.LayoutRevisionLocalServiceBaseImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class LayoutRevisionLocalServiceImpl
extends LayoutRevisionLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(LayoutRevisionLocalServiceImpl.class);
    private static final ThreadLocal<Long> _layoutRevisionId = new AutoResetThreadLocal(LayoutRevisionLocalServiceImpl.class + "._layoutRevisionId", (Object)0L);

    public LayoutRevision addLayoutRevision(long userId, long layoutSetBranchId, long layoutBranchId, long parentLayoutRevisionId, boolean head, long plid, long portletPreferencesPlid, boolean privateLayout, String name, String title, String description, String keywords, String robots, String typeSettings, boolean iconImage, long iconImageId, String themeId, String colorSchemeId, String css, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        LayoutSetBranch layoutSetBranch = this.layoutSetBranchPersistence.findByPrimaryKey(layoutSetBranchId);
        parentLayoutRevisionId = this.getParentLayoutRevisionId(layoutSetBranchId, parentLayoutRevisionId, plid);
        Date now = new Date();
        long layoutRevisionId = this.counterLocalService.increment();
        LayoutRevision layoutRevision = this.layoutRevisionPersistence.create(layoutRevisionId);
        layoutRevision.setGroupId(layoutSetBranch.getGroupId());
        layoutRevision.setCompanyId(user.getCompanyId());
        layoutRevision.setUserId(user.getUserId());
        layoutRevision.setUserName(user.getFullName());
        layoutRevision.setLayoutSetBranchId(layoutSetBranchId);
        layoutRevision.setLayoutBranchId(layoutBranchId);
        layoutRevision.setParentLayoutRevisionId(parentLayoutRevisionId);
        layoutRevision.setHead(head);
        layoutRevision.setPlid(plid);
        layoutRevision.setPrivateLayout(privateLayout);
        layoutRevision.setName(name);
        layoutRevision.setTitle(title);
        layoutRevision.setDescription(description);
        layoutRevision.setKeywords(keywords);
        layoutRevision.setRobots(robots);
        layoutRevision.setTypeSettings(typeSettings);
        layoutRevision.setIconImageId(iconImageId);
        layoutRevision.setThemeId(themeId);
        layoutRevision.setColorSchemeId(colorSchemeId);
        layoutRevision.setCss(css);
        layoutRevision.setStatus(0);
        layoutRevision.setStatusDate(serviceContext.getModifiedDate(now));
        this.layoutRevisionPersistence.update((BaseModel)layoutRevision);
        _layoutRevisionId.set(layoutRevision.getLayoutRevisionId());
        if (portletPreferencesPlid == 0L) {
            portletPreferencesPlid = plid;
        }
        this.copyPortletPreferences(layoutRevision, portletPreferencesPlid);
        boolean major = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"major");
        if (major || !this.isWorkflowEnabled(plid)) {
            this.updateMajor(layoutRevision);
        }
        if (this.isWorkflowEnabled(plid)) {
            WorkflowHandlerRegistryUtil.startWorkflowInstance((long)user.getCompanyId(), (long)layoutRevision.getGroupId(), (long)user.getUserId(), (String)LayoutRevision.class.getName(), (long)layoutRevision.getLayoutRevisionId(), (Object)layoutRevision, (ServiceContext)serviceContext);
        } else {
            this.updateStatus(userId, layoutRevisionId, 0, serviceContext);
        }
        StagingUtil.setRecentLayoutRevisionId((User)user, (long)layoutSetBranchId, (long)plid, (long)layoutRevision.getLayoutRevisionId());
        return layoutRevision;
    }

    public void deleteLayoutLayoutRevisions(long plid) throws PortalException {
        for (LayoutRevision layoutRevision : this.getLayoutRevisions(plid)) {
            this.layoutRevisionLocalService.deleteLayoutRevision(layoutRevision);
        }
    }

    @Override
    public LayoutRevision deleteLayoutRevision(LayoutRevision layoutRevision) throws PortalException {
        if (layoutRevision.hasChildren()) {
            for (LayoutRevision curLayoutRevision : layoutRevision.getChildren()) {
                curLayoutRevision.setParentLayoutRevisionId(layoutRevision.getParentLayoutRevisionId());
                this.layoutRevisionPersistence.update((BaseModel)curLayoutRevision);
            }
        }
        List portletPreferencesList = this.portletPreferencesLocalService.getPortletPreferencesByPlid(layoutRevision.getLayoutRevisionId());
        for (PortletPreferences portletPreferences : portletPreferencesList) {
            try {
                this.portletPreferencesLocalService.deletePortletPreferences(portletPreferences.getPortletPreferencesId());
            }
            catch (NoSuchPortletPreferencesException nsppe) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)nsppe, (Throwable)nsppe);
            }
        }
        this.recentLayoutRevisionLocalService.deleteRecentLayoutRevisions(layoutRevision.getLayoutRevisionId());
        this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(layoutRevision.getCompanyId(), layoutRevision.getGroupId(), LayoutRevision.class.getName(), layoutRevision.getLayoutRevisionId());
        return (LayoutRevision)this.layoutRevisionPersistence.remove((BaseModel)layoutRevision);
    }

    @Override
    public LayoutRevision deleteLayoutRevision(long layoutRevisionId) throws PortalException {
        LayoutRevision layoutRevision = this.layoutRevisionPersistence.findByPrimaryKey(layoutRevisionId);
        return this.deleteLayoutRevision(layoutRevision);
    }

    public void deleteLayoutRevisions(long layoutSetBranchId, long plid) throws PortalException {
        for (LayoutRevision layoutRevision : this.getLayoutRevisions(layoutSetBranchId, plid)) {
            this.layoutRevisionLocalService.deleteLayoutRevision(layoutRevision);
        }
    }

    public void deleteLayoutRevisions(long layoutSetBranchId, long layoutBranchId, long plid) throws PortalException {
        List layoutRevisions = this.layoutRevisionPersistence.findByL_L_P(layoutSetBranchId, layoutBranchId, plid);
        for (LayoutRevision layoutRevision : layoutRevisions) {
            this.layoutRevisionLocalService.deleteLayoutRevision(layoutRevision);
        }
    }

    public void deleteLayoutSetBranchLayoutRevisions(long layoutSetBranchId) throws PortalException {
        List layoutRevisions = this.layoutRevisionPersistence.findByLayoutSetBranchId(layoutSetBranchId);
        for (LayoutRevision layoutRevision : layoutRevisions) {
            this.layoutRevisionLocalService.deleteLayoutRevision(layoutRevision);
        }
    }

    public LayoutRevision fetchLastLayoutRevision(long plid, boolean head) {
        try {
            return this.layoutRevisionPersistence.findByH_P_Last(head, plid, (OrderByComparator)new LayoutRevisionCreateDateComparator(true));
        }
        catch (NoSuchLayoutRevisionException nslre) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)nslre, (Throwable)nslre);
            }
            return null;
        }
    }

    public LayoutRevision fetchLatestLayoutRevision(long layoutSetBranchId, long plid) {
        return this.layoutRevisionPersistence.fetchByL_P_First(layoutSetBranchId, plid, (OrderByComparator)new LayoutRevisionCreateDateComparator(false));
    }

    public LayoutRevision fetchLayoutRevision(long layoutSetBranchId, boolean head, long plid) {
        return this.layoutRevisionPersistence.fetchByL_H_P(layoutSetBranchId, head, plid);
    }

    public List<LayoutRevision> getChildLayoutRevisions(long layoutSetBranchId, long parentLayoutRevisionId, long plid) {
        return this.layoutRevisionPersistence.findByL_P_P(layoutSetBranchId, parentLayoutRevisionId, plid);
    }

    public List<LayoutRevision> getChildLayoutRevisions(long layoutSetBranchId, long parentLayoutRevision, long plid, int start, int end, OrderByComparator<LayoutRevision> orderByComparator) {
        return this.layoutRevisionPersistence.findByL_P_P(layoutSetBranchId, parentLayoutRevision, plid, start, end, orderByComparator);
    }

    public int getChildLayoutRevisionsCount(long layoutSetBranchId, long parentLayoutRevision, long plid) {
        return this.layoutRevisionPersistence.countByL_P_P(layoutSetBranchId, parentLayoutRevision, plid);
    }

    public LayoutRevision getLayoutRevision(long layoutSetBranchId, long plid, boolean head) throws PortalException {
        return this.layoutRevisionPersistence.findByL_H_P(layoutSetBranchId, head, plid);
    }

    public LayoutRevision getLayoutRevision(long layoutSetBranchId, long layoutBranchId, long plid) throws PortalException {
        List layoutRevisions = this.layoutRevisionPersistence.findByL_L_P(layoutSetBranchId, layoutBranchId, plid, 0, 1, (OrderByComparator)new LayoutRevisionCreateDateComparator(false));
        if (!layoutRevisions.isEmpty()) {
            return (LayoutRevision)layoutRevisions.get(0);
        }
        StringBundler sb = new StringBundler(7);
        sb.append("{layoutSetBranchId=");
        sb.append(layoutSetBranchId);
        sb.append(", layoutBranchId=");
        sb.append(layoutBranchId);
        sb.append(", plid=");
        sb.append(plid);
        sb.append("}");
        throw new NoSuchLayoutRevisionException(sb.toString());
    }

    public List<LayoutRevision> getLayoutRevisions(long plid) {
        return this.layoutRevisionPersistence.findByPlid(plid);
    }

    public List<LayoutRevision> getLayoutRevisions(long layoutSetBranchId, boolean head) {
        return this.layoutRevisionPersistence.findByL_H(layoutSetBranchId, head);
    }

    public List<LayoutRevision> getLayoutRevisions(long layoutSetBranchId, int status) {
        return this.layoutRevisionPersistence.findByL_S(layoutSetBranchId, status);
    }

    public List<LayoutRevision> getLayoutRevisions(long layoutSetBranchId, long plid) {
        return this.layoutRevisionPersistence.findByL_P(layoutSetBranchId, plid);
    }

    public List<LayoutRevision> getLayoutRevisions(long layoutSetBranchId, long plid, int status) {
        return this.layoutRevisionPersistence.findByL_P_S(layoutSetBranchId, plid, status);
    }

    public List<LayoutRevision> getLayoutRevisions(long layoutSetBranchId, long plid, int start, int end, OrderByComparator<LayoutRevision> orderByComparator) {
        return this.layoutRevisionPersistence.findByL_P(layoutSetBranchId, plid, start, end, orderByComparator);
    }

    public List<LayoutRevision> getLayoutRevisions(long layoutSetBranchId, long layoutBranchId, long plid, int start, int end, OrderByComparator<LayoutRevision> orderByComparator) {
        return this.layoutRevisionPersistence.findByL_L_P(layoutSetBranchId, layoutBranchId, plid, start, end, orderByComparator);
    }

    public int getLayoutRevisionsCount(long layoutSetBranchId, long layoutBranchId, long plid) {
        return this.layoutRevisionPersistence.countByL_L_P(layoutSetBranchId, layoutBranchId, plid);
    }

    public LayoutRevision updateLayoutRevision(long userId, long layoutRevisionId, long layoutBranchId, String name, String title, String description, String keywords, String robots, String typeSettings, boolean iconImage, long iconImageId, String themeId, String colorSchemeId, String css, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        LayoutRevision oldLayoutRevision = this.layoutRevisionPersistence.findByPrimaryKey(layoutRevisionId);
        Date now = new Date();
        LayoutRevision layoutRevision = null;
        int workflowAction = serviceContext.getWorkflowAction();
        boolean revisionInProgress = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"revisionInProgress");
        if (!MergeLayoutPrototypesThreadLocal.isInProgress() && workflowAction != 1 && _layoutRevisionId.get() <= 0L && !revisionInProgress) {
            long newLayoutRevisionId = this.counterLocalService.increment();
            layoutRevision = this.layoutRevisionPersistence.create(newLayoutRevisionId);
            layoutRevision.setGroupId(oldLayoutRevision.getGroupId());
            layoutRevision.setCompanyId(oldLayoutRevision.getCompanyId());
            layoutRevision.setUserId(user.getUserId());
            layoutRevision.setUserName(user.getFullName());
            layoutRevision.setLayoutSetBranchId(oldLayoutRevision.getLayoutSetBranchId());
            layoutRevision.setParentLayoutRevisionId(oldLayoutRevision.getLayoutRevisionId());
            layoutRevision.setHead(false);
            layoutRevision.setLayoutBranchId(layoutBranchId);
            layoutRevision.setPlid(oldLayoutRevision.getPlid());
            layoutRevision.setPrivateLayout(oldLayoutRevision.isPrivateLayout());
            layoutRevision.setName(name);
            layoutRevision.setTitle(title);
            layoutRevision.setDescription(description);
            layoutRevision.setKeywords(keywords);
            layoutRevision.setRobots(robots);
            layoutRevision.setTypeSettings(typeSettings);
            layoutRevision.setIconImageId(iconImageId);
            layoutRevision.setThemeId(themeId);
            layoutRevision.setColorSchemeId(colorSchemeId);
            layoutRevision.setCss(css);
            layoutRevision.setStatus(2);
            layoutRevision.setStatusDate(serviceContext.getModifiedDate(now));
            this.layoutRevisionPersistence.update((BaseModel)layoutRevision);
            _layoutRevisionId.set(layoutRevision.getLayoutRevisionId());
            this.copyPortletPreferences(layoutRevision, layoutRevision.getParentLayoutRevisionId());
            StagingUtil.setRecentLayoutBranchId((User)user, (long)layoutRevision.getLayoutSetBranchId(), (long)layoutRevision.getPlid(), (long)layoutRevision.getLayoutBranchId());
            StagingUtil.setRecentLayoutRevisionId((User)user, (long)layoutRevision.getLayoutSetBranchId(), (long)layoutRevision.getPlid(), (long)layoutRevision.getLayoutRevisionId());
        } else {
            layoutRevision = _layoutRevisionId.get() > 0L ? (LayoutRevision)this.layoutRevisionPersistence.findByPrimaryKey((Serializable)_layoutRevisionId.get()) : oldLayoutRevision;
            layoutRevision.setName(name);
            layoutRevision.setTitle(title);
            layoutRevision.setDescription(description);
            layoutRevision.setKeywords(keywords);
            layoutRevision.setRobots(robots);
            layoutRevision.setTypeSettings(typeSettings);
            layoutRevision.setIconImageId(iconImageId);
            layoutRevision.setThemeId(themeId);
            layoutRevision.setColorSchemeId(colorSchemeId);
            layoutRevision.setCss(css);
            this.layoutRevisionPersistence.update((BaseModel)layoutRevision);
            _layoutRevisionId.set(layoutRevision.getLayoutRevisionId());
        }
        boolean major = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"major");
        if (major || !this.isWorkflowEnabled(layoutRevision.getPlid())) {
            this.updateMajor(layoutRevision);
        }
        if (this.isWorkflowEnabled(layoutRevision.getPlid())) {
            WorkflowHandlerRegistryUtil.startWorkflowInstance((long)layoutRevision.getCompanyId(), (long)layoutRevision.getGroupId(), (long)userId, (String)LayoutRevision.class.getName(), (long)layoutRevision.getLayoutRevisionId(), (Object)layoutRevision, (ServiceContext)serviceContext);
        } else {
            this.updateStatus(userId, layoutRevision.getLayoutRevisionId(), 0, serviceContext);
        }
        return layoutRevision;
    }

    public LayoutRevision updateStatus(long userId, long layoutRevisionId, int status, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        LayoutRevision layoutRevision = this.layoutRevisionPersistence.findByPrimaryKey(layoutRevisionId);
        layoutRevision.setStatus(status);
        layoutRevision.setStatusByUserId(user.getUserId());
        layoutRevision.setStatusByUserName(user.getFullName());
        layoutRevision.setStatusDate(new Date());
        if (status == 0) {
            layoutRevision.setHead(true);
        } else {
            layoutRevision.setHead(false);
            layoutRevision.setMajor(false);
        }
        this.layoutRevisionPersistence.update((BaseModel)layoutRevision);
        if (status == 0) {
            List layoutRevisions = this.layoutRevisionPersistence.findByL_P(layoutRevision.getLayoutSetBranchId(), layoutRevision.getPlid());
            for (LayoutRevision curLayoutRevision : layoutRevisions) {
                if (curLayoutRevision.getLayoutRevisionId() == layoutRevision.getLayoutRevisionId()) continue;
                curLayoutRevision.setHead(false);
                this.layoutRevisionPersistence.update((BaseModel)curLayoutRevision);
            }
        } else {
            List layoutRevisions = this.layoutRevisionPersistence.findByL_P_S(layoutRevision.getLayoutSetBranchId(), layoutRevision.getPlid(), 0);
            for (LayoutRevision curLayoutRevision : layoutRevisions) {
                if (curLayoutRevision.getLayoutRevisionId() == layoutRevision.getLayoutRevisionId()) continue;
                curLayoutRevision.setHead(true);
                this.layoutRevisionPersistence.update((BaseModel)curLayoutRevision);
                break;
            }
        }
        return layoutRevision;
    }

    protected void copyPortletPreferences(LayoutRevision layoutRevision, long parentLayoutRevisionId) {
        List portletPreferencesList = this.portletPreferencesLocalService.getPortletPreferencesByPlid(parentLayoutRevisionId);
        for (PortletPreferences portletPreferences : portletPreferencesList) {
            this.portletPreferencesLocalService.addPortletPreferences(layoutRevision.getCompanyId(), portletPreferences.getOwnerId(), portletPreferences.getOwnerType(), layoutRevision.getLayoutRevisionId(), portletPreferences.getPortletId(), null, portletPreferences.getPreferences());
        }
    }

    protected long getParentLayoutRevisionId(long layoutSetBranchId, long parentLayoutRevisionId, long plid) {
        List layoutRevisions;
        LayoutRevision parentLayoutRevision = null;
        if (parentLayoutRevisionId > 0L && (parentLayoutRevision = this.layoutRevisionPersistence.fetchByPrimaryKey(parentLayoutRevisionId)) == null && !(layoutRevisions = this.layoutRevisionPersistence.findByL_P(layoutSetBranchId, plid, 0, 1)).isEmpty()) {
            parentLayoutRevision = (LayoutRevision)layoutRevisions.get(0);
        }
        if (parentLayoutRevision != null) {
            return parentLayoutRevision.getLayoutRevisionId();
        }
        return 0L;
    }

    protected boolean isWorkflowEnabled(long plid) throws PortalException {
        Layout layout = this.layoutLocalService.getLayout(plid);
        return !layout.isTypeLinkToLayout() && !layout.isTypeURL();
    }

    protected LayoutRevision updateMajor(LayoutRevision layoutRevision) throws PortalException {
        LayoutRevision parentLayoutRevision;
        List childrenLayoutRevisions;
        LayoutRevision parentLayoutRevision2;
        ArrayList<LayoutRevision> parentLayoutRevisions = new ArrayList<LayoutRevision>();
        long parentLayoutRevisionId = layoutRevision.getParentLayoutRevisionId();
        while (parentLayoutRevisionId != 0L && !(parentLayoutRevision2 = this.layoutRevisionPersistence.findByPrimaryKey(parentLayoutRevisionId)).isMajor()) {
            parentLayoutRevisions.add(parentLayoutRevision2);
            parentLayoutRevisionId = parentLayoutRevision2.getParentLayoutRevisionId();
        }
        layoutRevision.setParentLayoutRevisionId(parentLayoutRevisionId);
        layoutRevision.setMajor(true);
        this.layoutRevisionPersistence.update((BaseModel)layoutRevision);
        Iterator iterator = parentLayoutRevisions.iterator();
        while (iterator.hasNext() && (childrenLayoutRevisions = (parentLayoutRevision = (LayoutRevision)iterator.next()).getChildren()).isEmpty()) {
            this.layoutRevisionLocalService.deleteLayoutRevision(parentLayoutRevision);
        }
        return layoutRevision;
    }
}

