/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.kernel.exception.NoSuchResourcePermissionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.PermissionedModel;
import com.liferay.portal.kernel.model.Resource;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupGroupRole;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.security.permission.ResourceBlockIdsBag;
import com.liferay.portal.kernel.security.permission.UserBag;
import com.liferay.portal.kernel.security.permission.UserBagFactoryUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceBlockLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupGroupRoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.LayoutPrototypePermissionUtil;
import com.liferay.portal.kernel.service.permission.LayoutSetPrototypePermissionUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.BasePermissionChecker;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.time.StopWatch;

public class AdvancedPermissionChecker
extends BasePermissionChecker {
    @Deprecated
    protected static final String RESULTS_SEPARATOR = "_RESULTS_SEPARATOR_";
    private static final Log _log = LogFactoryUtil.getLog(AdvancedPermissionChecker.class);
    private long _guestGroupId;

    @Override
    public AdvancedPermissionChecker clone() {
        return new AdvancedPermissionChecker();
    }

    public ResourceBlockIdsBag getGuestResourceBlockIdsBag(long companyId, long groupId, String name) throws Exception {
        ResourceBlockIdsBag resourceBlockIdsBag = PermissionCacheUtil.getResourceBlockIdsBag(companyId, groupId, this.defaultUserId, name);
        if (resourceBlockIdsBag != null) {
            return resourceBlockIdsBag;
        }
        try {
            resourceBlockIdsBag = ResourceBlockLocalServiceUtil.getResourceBlockIdsBag((long)this.getCompanyId(), (long)groupId, (String)name, (long[])this.getGuestUserRoleIds());
            PermissionCacheUtil.putResourceBlockIdsBag(companyId, groupId, this.defaultUserId, name, resourceBlockIdsBag);
            return resourceBlockIdsBag;
        }
        catch (Exception e) {
            PermissionCacheUtil.removeResourceBlockIdsBag(this.getCompanyId(), groupId, this.defaultUserId, name);
            throw e;
        }
    }

    public long[] getGuestUserRoleIds() throws Exception {
        long[] roleIds = PermissionCacheUtil.getUserGroupRoleIds(this.defaultUserId, this._guestGroupId);
        if (roleIds != null) {
            return roleIds;
        }
        try {
            List roles = RoleLocalServiceUtil.getUserRelatedRoles((long)this.defaultUserId, (long)this._guestGroupId);
            roleIds = ListUtil.toLongArray((List)roles, (Accessor)Role.ROLE_ID_ACCESSOR);
            Arrays.sort(roleIds);
            PermissionCacheUtil.putUserGroupRoleIds(this.defaultUserId, this._guestGroupId, roleIds);
        }
        catch (Exception e) {
            PermissionCacheUtil.removeUserGroupRoleIds(this.defaultUserId, this._guestGroupId);
            throw e;
        }
        return roleIds;
    }

    @Override
    public List<Long> getOwnerResourceBlockIds(long companyId, long groupId, String name, String actionId) {
        try {
            ResourceBlockIdsBag resourceBlockIdsBag = this.getOwnerResourceBlockIdsBag(companyId, groupId, name);
            return ResourceBlockLocalServiceUtil.getResourceBlockIds((ResourceBlockIdsBag)resourceBlockIdsBag, (String)name, (String)actionId);
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            }
            return Collections.emptyList();
        }
    }

    public ResourceBlockIdsBag getOwnerResourceBlockIdsBag(long companyId, long groupId, String name) {
        ResourceBlockIdsBag resourceBlockIdsBag = PermissionCacheUtil.getResourceBlockIdsBag(companyId, groupId, -1L, name);
        if (resourceBlockIdsBag != null) {
            return resourceBlockIdsBag;
        }
        try {
            long[] roleIds = new long[]{this.getOwnerRoleId()};
            resourceBlockIdsBag = ResourceBlockLocalServiceUtil.getResourceBlockIdsBag((long)this.getCompanyId(), (long)groupId, (String)name, (long[])roleIds);
            PermissionCacheUtil.putResourceBlockIdsBag(companyId, groupId, -1L, name, resourceBlockIdsBag);
            return resourceBlockIdsBag;
        }
        catch (Exception e) {
            PermissionCacheUtil.removeResourceBlockIdsBag(companyId, groupId, -1L, name);
            throw e;
        }
    }

    @Override
    public List<Long> getResourceBlockIds(long companyId, long groupId, long userId, String name, String actionId) {
        try {
            ResourceBlockIdsBag resourceBlockIdsBag = this.getResourceBlockIdsBag(companyId, groupId, name, this.getRoleIds(this.getUserId(), groupId));
            return ResourceBlockLocalServiceUtil.getResourceBlockIds((ResourceBlockIdsBag)resourceBlockIdsBag, (String)name, (String)actionId);
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            }
            return Collections.emptyList();
        }
    }

    public ResourceBlockIdsBag getResourceBlockIdsBag(long companyId, long groupId, String name, long[] roleIds) throws Exception {
        ResourceBlockIdsBag resourceBlockIdsBag = PermissionCacheUtil.getResourceBlockIdsBag(companyId, groupId, this.getUserId(), name);
        if (resourceBlockIdsBag != null) {
            return resourceBlockIdsBag;
        }
        try {
            resourceBlockIdsBag = ResourceBlockLocalServiceUtil.getResourceBlockIdsBag((long)this.getCompanyId(), (long)groupId, (String)name, (long[])roleIds);
            PermissionCacheUtil.putResourceBlockIdsBag(companyId, groupId, this.getUserId(), name, resourceBlockIdsBag);
            return resourceBlockIdsBag;
        }
        catch (Exception e) {
            PermissionCacheUtil.removeResourceBlockIdsBag(companyId, groupId, this.getUserId(), name);
            throw e;
        }
    }

    @Override
    public long[] getRoleIds(long userId, long groupId) {
        try {
            return this.doGetRoleIds(userId, groupId);
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            }
            return PermissionChecker.DEFAULT_ROLE_IDS;
        }
    }

    public UserBag getUserBag() throws PortalException {
        return UserBagFactoryUtil.create((long)this.getUserId());
    }

    public boolean hasOwnerPermission(long companyId, String name, String primKey, long ownerId, String actionId) {
        List guestUnsupportedActions;
        if (ownerId != this.getUserId()) {
            return false;
        }
        boolean ownerIsDefaultUser = false;
        if (ownerId == this.defaultUserId) {
            ownerIsDefaultUser = true;
        }
        if (ownerIsDefaultUser && (guestUnsupportedActions = name.indexOf(46) != -1 ? ResourceActionsUtil.getModelResourceGuestUnsupportedActions((String)name) : ResourceActionsUtil.getPortletResourceGuestUnsupportedActions((String)name)).contains(actionId)) {
            return false;
        }
        try {
            if (ResourceBlockLocalServiceUtil.isSupported((String)name)) {
                PermissionedModel permissionedModel = ResourceBlockLocalServiceUtil.getPermissionedModel((String)name, (long)GetterUtil.getLong((String)primKey));
                long groupId = 0L;
                if (permissionedModel instanceof GroupedModel) {
                    GroupedModel groupedModel = (GroupedModel)permissionedModel;
                    groupId = groupedModel.getGroupId();
                }
                ResourceBlockIdsBag resourceBlockIdsBag = null;
                resourceBlockIdsBag = ownerIsDefaultUser ? this.getGuestResourceBlockIdsBag(companyId, groupId, name) : this.getOwnerResourceBlockIdsBag(companyId, groupId, name);
                return ResourceBlockLocalServiceUtil.hasPermission((String)name, (PermissionedModel)permissionedModel, (String)actionId, (ResourceBlockIdsBag)resourceBlockIdsBag);
            }
            long ownerRoleId = this.getOwnerRoleId();
            if (ownerIsDefaultUser) {
                Role guestRole = RoleLocalServiceUtil.getRole((long)companyId, (String)"Guest");
                ownerRoleId = guestRole.getRoleId();
            }
            return ResourcePermissionLocalServiceUtil.hasResourcePermission((long)companyId, (String)name, (int)4, (String)primKey, (long)ownerRoleId, (String)actionId);
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            }
            return false;
        }
    }

    public boolean hasPermission(Group group, String name, String primKey, String actionId) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        long groupId = 0L;
        try {
            if (group != null) {
                if (group.isLayout() && !ResourceBlockLocalServiceUtil.isSupported((String)name)) {
                    Layout layout = LayoutLocalServiceUtil.getLayout((long)group.getClassPK());
                    group = layout.getGroup();
                } else if (group.isUserPersonalSite()) {
                    return false;
                }
                if (group.isUser() && group.getClassPK() == this.getUserId()) {
                    group = GroupLocalServiceUtil.getGroup((long)this.getCompanyId(), (String)"User Personal Site");
                }
                groupId = group.getGroupId();
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        long[] roleIds = this.getRoleIds(this.getUserId(), groupId);
        Boolean value = PermissionCacheUtil.getPermission(groupId, name, primKey, roleIds, actionId);
        if (value != null) {
            return value;
        }
        try {
            value = this._hasPermissionImpl(group, name, primKey, roleIds, actionId);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Checking permission for " + groupId + " " + name + " " + primKey + " " + actionId + " takes " + stopWatch.getTime() + " ms"));
            }
            PermissionCacheUtil.putPermission(groupId, name, primKey, roleIds, actionId, value);
        }
        catch (Exception e) {
            PermissionCacheUtil.removePermission(groupId, name, primKey, roleIds, actionId);
            throw e;
        }
        return value;
    }

    @Override
    public void init(User user) {
        super.init(user);
        try {
            Group guestGroup = GroupLocalServiceUtil.getGroup((long)user.getCompanyId(), (String)"Guest");
            this._guestGroupId = guestGroup.getGroupId();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public boolean isCompanyAdmin() {
        try {
            return this.isCompanyAdminImpl(this.user.getCompanyId());
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public boolean isCompanyAdmin(long companyId) {
        try {
            return this.isCompanyAdminImpl(companyId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public boolean isContentReviewer(long companyId, long groupId) {
        try {
            return this.isContentReviewerImpl(companyId, groupId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public boolean isGroupAdmin(long groupId) {
        try {
            Group group = null;
            if (groupId > 0L) {
                group = GroupLocalServiceUtil.fetchGroup((long)groupId);
            }
            return this._isGroupAdminImpl(group);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public boolean isGroupMember(long groupId) {
        try {
            return this.isGroupMemberImpl(groupId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public boolean isGroupOwner(long groupId) {
        try {
            return this.isGroupOwnerImpl(groupId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public boolean isOrganizationAdmin(long organizationId) {
        try {
            return this.isOrganizationAdminImpl(organizationId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public boolean isOrganizationOwner(long organizationId) {
        try {
            return this.isOrganizationOwnerImpl(organizationId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    protected void addTeamRoles(long userId, Group group, Set<Long> roleIds) throws Exception {
        List roles = RoleLocalServiceUtil.getUserTeamRoles((long)userId, (long)group.getGroupId());
        for (Role role : roles) {
            roleIds.add(role.getRoleId());
        }
    }

    protected boolean doCheckPermission(long companyId, long groupId, String name, String primKey, long[] roleIds, String actionId, StopWatch stopWatch) throws Exception {
        this.logHasUserPermission(groupId, name, primKey, actionId, stopWatch, 1);
        if (ResourceBlockLocalServiceUtil.isSupported((String)name)) {
            ResourceBlockIdsBag resourceBlockIdsBag = this.getResourceBlockIdsBag(companyId, groupId, name, roleIds);
            boolean value = ResourceBlockLocalServiceUtil.hasPermission((String)name, (long)GetterUtil.getLong((String)primKey), (String)actionId, (ResourceBlockIdsBag)resourceBlockIdsBag);
            this.logHasUserPermission(groupId, name, primKey, actionId, stopWatch, 2);
            return value;
        }
        List<Resource> resources = this.getResources(companyId, groupId, name, primKey, actionId);
        resources = this.fixMissingResources(companyId, groupId, name, primKey, actionId, resources);
        this.logHasUserPermission(groupId, name, primKey, actionId, stopWatch, 3);
        boolean value = ResourceLocalServiceUtil.hasUserPermissions((long)this.user.getUserId(), (long)groupId, resources, (String)actionId, (long[])roleIds);
        this.logHasUserPermission(groupId, name, primKey, actionId, stopWatch, 4);
        return value;
    }

    protected long[] doGetRoleIds(long userId, long groupId) throws Exception {
        if (!this.signedIn) {
            return this.getGuestUserRoleIds();
        }
        long[] roleIds = PermissionCacheUtil.getUserGroupRoleIds(userId, groupId);
        if (roleIds != null) {
            return roleIds;
        }
        try {
            long[] userUserGroupIds;
            Group group = null;
            long parentGroupId = 0L;
            if (groupId > 0L && (group = GroupLocalServiceUtil.getGroup((long)groupId)).isLayout() && (parentGroupId = group.getParentGroupId()) > 0L) {
                group = GroupLocalServiceUtil.getGroup((long)parentGroupId);
            }
            UserBag userBag = this.getUserBag();
            Set roleIdsSet = SetUtil.fromArray((long[])userBag.getRoleIds());
            List userGroupRoles = UserGroupRoleLocalServiceUtil.getUserGroupRoles((long)userId, (long)groupId);
            for (UserGroupRole userGroupRole : userGroupRoles) {
                roleIdsSet.add(userGroupRole.getRoleId());
            }
            if (parentGroupId > 0L) {
                userGroupRoles = UserGroupRoleLocalServiceUtil.getUserGroupRoles((long)userId, (long)parentGroupId);
                for (UserGroupRole userGroupRole : userGroupRoles) {
                    roleIdsSet.add(userGroupRole.getRoleId());
                }
            }
            if ((userUserGroupIds = userBag.getUserUserGroupsIds()).length > 0) {
                List userGroupGroupRoles = UserGroupGroupRoleLocalServiceUtil.getUserGroupGroupRolesByUser((long)userId, (long)groupId);
                for (UserGroupGroupRole userGroupGroupRole : userGroupGroupRoles) {
                    roleIdsSet.add(userGroupGroupRole.getRoleId());
                }
                if (parentGroupId > 0L) {
                    userGroupGroupRoles = UserGroupGroupRoleLocalServiceUtil.getUserGroupGroupRoles((long)userId, (long)parentGroupId);
                    for (UserGroupGroupRole userGroupGroupRole : userGroupGroupRoles) {
                        roleIdsSet.add(userGroupGroupRole.getRoleId());
                    }
                }
            }
            if (group != null) {
                if (group.isOrganization() && userBag.hasUserOrgGroup(group)) {
                    Role organizationUserRole = RoleLocalServiceUtil.getRole((long)group.getCompanyId(), (String)"Organization User");
                    roleIdsSet.add(organizationUserRole.getRoleId());
                }
                if (group.isSite() && (userBag.hasUserGroup(group) || userBag.hasUserOrgGroup(group)) || group.isUserPersonalSite()) {
                    Role siteMemberRole = RoleLocalServiceUtil.getRole((long)group.getCompanyId(), (String)"Site Member");
                    roleIdsSet.add(siteMemberRole.getRoleId());
                }
                if (group.isOrganization() && userBag.hasUserOrgGroup(group) || group.isSite() && userBag.hasUserGroup(group)) {
                    this.addTeamRoles(userId, group, roleIdsSet);
                }
            }
            if (this.checkGuest) {
                for (long roleId : this.getGuestUserRoleIds()) {
                    roleIdsSet.add(roleId);
                }
            }
            roleIds = ArrayUtil.toLongArray((Collection)roleIdsSet);
            Arrays.sort(roleIds);
            PermissionCacheUtil.putUserGroupRoleIds(userId, groupId, roleIds);
            return roleIds;
        }
        catch (Exception e) {
            PermissionCacheUtil.removeUserGroupRoleIds(userId, groupId);
            throw e;
        }
    }

    protected List<Resource> fixMissingResources(long companyId, long groupId, String name, String primKey, String actionId, List<Resource> resources) throws Exception {
        String message;
        int count = ResourcePermissionLocalServiceUtil.getResourcePermissionsCount((long)companyId, (String)name, (int)4, (String)primKey);
        if (count > 0) {
            return resources;
        }
        String newIndividualResourcePrimKey = null;
        if (primKey.contains("_LAYOUT_")) {
            newIndividualResourcePrimKey = name;
            if (_log.isDebugEnabled()) {
                message = "Using defaults because custom permissions for portlet resource " + name + " are not defined";
                _log.debug((Object)message, (Throwable)new IllegalArgumentException(message));
            }
        } else if (groupId > 0L && ResourceActionsUtil.isRootModelResource((String)name)) {
            newIndividualResourcePrimKey = name;
            if (_log.isDebugEnabled()) {
                message = "Using defaults because custom permissions for root model resource " + name + " are not defined";
                _log.debug((Object)message, (Throwable)new IllegalArgumentException(message));
            }
        } else if (primKey.equals("0") || primKey.equals(String.valueOf(-1L)) || primKey.equals(String.valueOf(companyId)) && !name.equals(Company.class.getName())) {
            newIndividualResourcePrimKey = name;
            if (_log.isWarnEnabled()) {
                StringBundler sb = new StringBundler(9);
                sb.append("Using ");
                sb.append(name);
                sb.append(" as the primary key instead of the legacy primary ");
                sb.append("key ");
                sb.append(primKey);
                sb.append(" that was used for permission checking of ");
                sb.append(name);
                sb.append(" in company ");
                sb.append(companyId);
                _log.warn((Object)sb.toString(), (Throwable)new IllegalArgumentException(sb.toString()));
            }
        }
        if (newIndividualResourcePrimKey != null) {
            Resource individualResource = resources.get(0);
            if (individualResource.getScope() != 4) {
                throw new IllegalArgumentException("The first resource must be an individual scope");
            }
            individualResource.setPrimKey(name);
        }
        return resources;
    }

    protected List<Resource> getResources(long companyId, long groupId, String name, String primKey, String actionId) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>(4);
        Resource individualResource = ResourceLocalServiceUtil.getResource((long)companyId, (String)name, (int)4, (String)primKey);
        resources.add(individualResource);
        if (groupId > 0L) {
            Resource groupResource = ResourceLocalServiceUtil.getResource((long)companyId, (String)name, (int)2, (String)String.valueOf(groupId));
            resources.add(groupResource);
        }
        if (this.signedIn && groupId > 0L) {
            Resource groupTemplateResource = ResourceLocalServiceUtil.getResource((long)companyId, (String)name, (int)3, (String)String.valueOf(0L));
            resources.add(groupTemplateResource);
        }
        Resource companyResource = ResourceLocalServiceUtil.getResource((long)companyId, (String)name, (int)1, (String)String.valueOf(companyId));
        resources.add(companyResource);
        return resources;
    }

    @Deprecated
    protected boolean hasGuestPermission(long groupId, String name, String primKey, String actionId) throws Exception {
        Group group = null;
        if (groupId > 0L) {
            group = GroupLocalServiceUtil.fetchGroup((long)groupId);
        }
        return this._hasGuestPermission(group, name, primKey, actionId);
    }

    @Deprecated
    protected boolean hasPermissionImpl(long groupId, String name, String primKey, long[] roleIds, String actionId) {
        Group group = null;
        if (groupId > 0L) {
            group = GroupLocalServiceUtil.fetchGroup((long)groupId);
        }
        return this._hasPermissionImpl(group, name, primKey, roleIds, actionId);
    }

    @Deprecated
    protected boolean hasUserPermissionImpl(long groupId, String name, String primKey, long[] roleIds, String actionId) throws Exception {
        Group group = null;
        if (groupId > 0L) {
            group = GroupLocalServiceUtil.fetchGroup((long)groupId);
        }
        return this._hasUserPermissionImpl(group, name, primKey, roleIds, actionId);
    }

    protected boolean isCompanyAdminImpl(long companyId) throws Exception {
        if (!this.signedIn) {
            return false;
        }
        if (this.isOmniadmin()) {
            return true;
        }
        Boolean value = PermissionCacheUtil.getUserPrimaryKeyRole(this.getUserId(), companyId, "Administrator");
        try {
            if (value == null) {
                value = RoleLocalServiceUtil.hasUserRole((long)this.user.getUserId(), (long)companyId, (String)"Administrator", (boolean)true);
                PermissionCacheUtil.putUserPrimaryKeyRole(this.getUserId(), companyId, "Administrator", value);
            }
        }
        catch (Exception e) {
            PermissionCacheUtil.removeUserPrimaryKeyRole(this.getUserId(), companyId, "Administrator");
            throw e;
        }
        return value;
    }

    protected boolean isContentReviewerImpl(long groupId) throws PortalException {
        if (this.isCompanyAdmin() || this.isGroupAdmin(groupId)) {
            return true;
        }
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        if (RoleLocalServiceUtil.hasUserRole((long)this.getUserId(), (long)group.getCompanyId(), (String)"Portal Content Reviewer", (boolean)true)) {
            return true;
        }
        return group.isSite() && UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this.getUserId(), (long)groupId, (String)"Site Content Reviewer", (boolean)true);
    }

    protected boolean isContentReviewerImpl(long companyId, long groupId) throws Exception {
        if (!this.signedIn) {
            return false;
        }
        if (this.isOmniadmin()) {
            return true;
        }
        if (this.isCompanyAdmin(companyId)) {
            return true;
        }
        if (groupId <= 0L) {
            return false;
        }
        if (this.isGroupAdmin(groupId)) {
            return true;
        }
        Boolean value = PermissionCacheUtil.getUserPrimaryKeyRole(this.getUserId(), groupId, "Site Content Reviewer");
        try {
            if (value == null) {
                value = this.isContentReviewerImpl(groupId);
                PermissionCacheUtil.putUserPrimaryKeyRole(this.getUserId(), groupId, "Site Content Reviewer", value);
            }
        }
        catch (Exception e) {
            PermissionCacheUtil.removeUserPrimaryKeyRole(this.getUserId(), groupId, "Site Content Reviewer");
            throw e;
        }
        return value;
    }

    protected boolean isGroupAdminImpl(Group group) throws Exception {
        if (group.isLayout()) {
            long parentGroupId = group.getParentGroupId();
            if (parentGroupId == 0L) {
                return false;
            }
            group = GroupLocalServiceUtil.getGroup((long)parentGroupId);
        }
        if (group.isSite()) {
            if (UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this.getUserId(), (long)group.getGroupId(), (String)"Site Administrator", (boolean)true) || UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this.getUserId(), (long)group.getGroupId(), (String)"Site Owner", (boolean)true)) {
                return true;
            }
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            Group parentGroup = group;
            while (!parentGroup.isRoot()) {
                parentGroup = parentGroup.getParentGroup();
                long[] roleIds = this.getRoleIds(this.getUserId(), parentGroup.getGroupId());
                if (!this.doCheckPermission(parentGroup.getCompanyId(), parentGroup.getGroupId(), Group.class.getName(), String.valueOf(parentGroup.getGroupId()), roleIds, "MANAGE_SUBGROUPS", stopWatch)) continue;
                return true;
            }
        }
        if (group.isCompany()) {
            return this.isCompanyAdmin();
        }
        if (group.isLayoutPrototype()) {
            return LayoutPrototypePermissionUtil.contains((PermissionChecker)this, (long)group.getClassPK(), (String)"UPDATE");
        }
        if (group.isLayoutSetPrototype()) {
            return LayoutSetPrototypePermissionUtil.contains((PermissionChecker)this, (long)group.getClassPK(), (String)"UPDATE");
        }
        if (group.isOrganization()) {
            long organizationId = group.getOrganizationId();
            while (organizationId != 0L) {
                Organization organization = OrganizationLocalServiceUtil.getOrganization((long)organizationId);
                long organizationGroupId = organization.getGroupId();
                if (UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this.getUserId(), (long)organizationGroupId, (String)"Organization Administrator", (boolean)true) || UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this.getUserId(), (long)organizationGroupId, (String)"Organization Owner", (boolean)true)) {
                    return true;
                }
                organizationId = organization.getParentOrganizationId();
            }
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            Organization organization = OrganizationLocalServiceUtil.getOrganization((long)group.getOrganizationId());
            while (!organization.isRoot()) {
                Organization parentOrganization = organization.getParentOrganization();
                Group parentGroup = parentOrganization.getGroup();
                long[] roleIds = this.getRoleIds(this.getUserId(), parentGroup.getGroupId());
                if (this.doCheckPermission(parentGroup.getCompanyId(), parentGroup.getGroupId(), Organization.class.getName(), String.valueOf(parentOrganization.getOrganizationId()), roleIds, "MANAGE_SUBORGANIZATIONS", stopWatch)) {
                    return true;
                }
                organization = parentOrganization;
            }
        }
        return false;
    }

    @Deprecated
    protected boolean isGroupAdminImpl(long groupId) throws Exception {
        Group group = GroupLocalServiceUtil.fetchGroup((long)groupId);
        return this._isGroupAdminImpl(group);
    }

    protected boolean isGroupMemberImpl(long groupId) throws Exception {
        Group group;
        Role role;
        if (!this.signedIn) {
            return false;
        }
        if (groupId <= 0L) {
            return false;
        }
        long[] roleIds = this.getRoleIds(this.getUserId(), groupId);
        if (Arrays.binarySearch(roleIds, (role = RoleLocalServiceUtil.getRole((long)(group = GroupLocalServiceUtil.getGroup((long)groupId)).getCompanyId(), (String)"Site Member")).getRoleId()) >= 0) {
            return true;
        }
        UserBag userBag = this.getUserBag();
        return userBag.hasUserGroup(group);
    }

    protected boolean isGroupOwnerImpl(Group group) throws PortalException {
        if (group.isSite() && UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this.getUserId(), (long)group.getGroupId(), (String)"Site Owner", (boolean)true)) {
            return true;
        }
        if (group.isLayoutPrototype()) {
            return LayoutPrototypePermissionUtil.contains((PermissionChecker)this, (long)group.getClassPK(), (String)"UPDATE");
        }
        if (group.isLayoutSetPrototype()) {
            return LayoutSetPrototypePermissionUtil.contains((PermissionChecker)this, (long)group.getClassPK(), (String)"UPDATE");
        }
        if (group.isOrganization()) {
            long organizationId = group.getOrganizationId();
            while (organizationId != 0L) {
                Organization organization = OrganizationLocalServiceUtil.getOrganization((long)organizationId);
                long organizationGroupId = organization.getGroupId();
                if (UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this.getUserId(), (long)organizationGroupId, (String)"Organization Owner", (boolean)true)) {
                    return true;
                }
                organizationId = organization.getParentOrganizationId();
            }
        } else if (group.isUser()) {
            long groupUserId = group.getClassPK();
            if (this.getUserId() == groupUserId) {
                return true;
            }
        }
        return false;
    }

    protected boolean isGroupOwnerImpl(long groupId) throws Exception {
        if (!this.signedIn) {
            return false;
        }
        if (this.isOmniadmin()) {
            return true;
        }
        if (groupId <= 0L) {
            return false;
        }
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        if (this.isCompanyAdmin(group.getCompanyId())) {
            return true;
        }
        Boolean value = PermissionCacheUtil.getUserPrimaryKeyRole(this.getUserId(), group.getGroupId(), "Site Owner");
        try {
            if (value == null) {
                value = this.isGroupOwnerImpl(group);
                PermissionCacheUtil.putUserPrimaryKeyRole(this.getUserId(), group.getGroupId(), "Site Owner", value);
            }
        }
        catch (Exception e) {
            PermissionCacheUtil.removeUserPrimaryKeyRole(this.getUserId(), group.getGroupId(), "Site Owner");
            throw e;
        }
        return value;
    }

    protected boolean isOrganizationAdminImpl(long organizationId) throws Exception {
        if (!this.signedIn) {
            return false;
        }
        if (this.isOmniadmin()) {
            return true;
        }
        if (organizationId <= 0L) {
            return false;
        }
        Organization organization = OrganizationLocalServiceUtil.fetchOrganization((long)organizationId);
        if (organization == null) {
            return false;
        }
        if (this.isCompanyAdmin(organization.getCompanyId())) {
            return true;
        }
        Boolean value = PermissionCacheUtil.getUserPrimaryKeyRole(this.getUserId(), organization.getOrganizationId(), "Organization Administrator");
        try {
            if (value == null) {
                value = this.isOrganizationAdminImpl(organization);
                PermissionCacheUtil.putUserPrimaryKeyRole(this.getUserId(), organization.getOrganizationId(), "Organization Administrator", value);
            }
        }
        catch (Exception e) {
            PermissionCacheUtil.removeUserPrimaryKeyRole(this.getUserId(), organization.getOrganizationId(), "Organization Administrator");
            throw e;
        }
        return value;
    }

    protected boolean isOrganizationAdminImpl(Organization organization) throws PortalException {
        while (organization != null) {
            long organizationGroupId = organization.getGroupId();
            long userId = this.getUserId();
            if (UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)userId, (long)organizationGroupId, (String)"Organization Administrator", (boolean)true) || UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)userId, (long)organizationGroupId, (String)"Organization Owner", (boolean)true)) {
                return true;
            }
            organization = organization.getParentOrganization();
        }
        return false;
    }

    protected boolean isOrganizationOwnerImpl(long organizationId) throws Exception {
        if (!this.signedIn) {
            return false;
        }
        if (this.isOmniadmin()) {
            return true;
        }
        if (organizationId <= 0L) {
            return false;
        }
        Organization organization = OrganizationLocalServiceUtil.fetchOrganization((long)organizationId);
        if (organization == null) {
            return false;
        }
        if (this.isCompanyAdmin(organization.getCompanyId())) {
            return true;
        }
        Boolean value = PermissionCacheUtil.getUserPrimaryKeyRole(this.getUserId(), organization.getOrganizationId(), "Organization Owner");
        try {
            if (value == null) {
                value = this.isOrganizationOwnerImpl(organization);
                PermissionCacheUtil.putUserPrimaryKeyRole(this.getUserId(), organization.getOrganizationId(), "Organization Owner", value);
            }
        }
        catch (Exception e) {
            PermissionCacheUtil.removeUserPrimaryKeyRole(this.getUserId(), organization.getOrganizationId(), "Organization Owner");
            throw e;
        }
        return value;
    }

    protected boolean isOrganizationOwnerImpl(Organization organization) throws PortalException {
        while (organization != null) {
            long organizationGroupId = organization.getGroupId();
            long userId = this.getUserId();
            if (UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)userId, (long)organizationGroupId, (String)"Organization Owner", (boolean)true)) {
                return true;
            }
            organization = organization.getParentOrganization();
        }
        return false;
    }

    protected void logHasUserPermission(long groupId, String name, String primKey, String actionId, StopWatch stopWatch, int block) {
        if (!_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)("Checking user permission block " + block + " for " + groupId + " " + name + " " + primKey + " " + actionId + " takes " + stopWatch.getTime() + " ms"));
    }

    private boolean _hasGuestPermission(Group group, String name, String primKey, String actionId) {
        List actions;
        List resourceActions = ResourceActionsUtil.getResourceActions((String)name);
        if (!resourceActions.contains(actionId)) {
            return false;
        }
        if (name.indexOf(46) != -1 ? (actions = ResourceActionsUtil.getModelResourceGuestUnsupportedActions((String)name)).contains(actionId) : (actions = ResourceActionsUtil.getPortletResourceGuestUnsupportedActions((String)name)).contains(actionId)) {
            return false;
        }
        long companyId = this.user.getCompanyId();
        long groupId = 0L;
        if (group != null) {
            companyId = group.getCompanyId();
            groupId = group.getGroupId();
        }
        try {
            if (ResourceBlockLocalServiceUtil.isSupported((String)name)) {
                ResourceBlockIdsBag resourceBlockIdsBag = this.getGuestResourceBlockIdsBag(companyId, groupId, name);
                return ResourceBlockLocalServiceUtil.hasPermission((String)name, (long)GetterUtil.getLong((String)primKey), (String)actionId, (ResourceBlockIdsBag)resourceBlockIdsBag);
            }
            List<Resource> resources = this.getResources(companyId, groupId, name, primKey, actionId);
            resources = this.fixMissingResources(companyId, groupId, name, primKey, actionId, resources);
            return ResourceLocalServiceUtil.hasUserPermissions((long)this.defaultUserId, (long)groupId, resources, (String)actionId, (long[])this.getGuestUserRoleIds());
        }
        catch (NoSuchResourcePermissionException nsrpe) {
            throw new IllegalArgumentException("Someone may be trying to circumvent the permission checker: " + nsrpe.getMessage(), nsrpe);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    private boolean _hasPermissionImpl(Group group, String name, String primKey, long[] roleIds, String actionId) {
        try {
            if (!this.signedIn) {
                return this._hasGuestPermission(group, name, primKey, actionId);
            }
            return this._hasUserPermissionImpl(group, name, primKey, roleIds, actionId);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    private boolean _hasUserPermissionImpl(Group group, String name, String primKey, long[] roleIds, String actionId) throws Exception {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        long companyId = this.user.getCompanyId();
        long groupId = 0L;
        if (group != null) {
            companyId = group.getCompanyId();
            groupId = group.getGroupId();
        }
        try {
            boolean hasPermission = this.doCheckPermission(companyId, groupId, name, primKey, roleIds, actionId, stopWatch);
            if (hasPermission) {
                return true;
            }
        }
        catch (NoSuchResourcePermissionException nsrpe) {
            throw new IllegalArgumentException("Someone may be trying to circumvent the permission checker: " + nsrpe.getMessage(), nsrpe);
        }
        if (this.isOmniadmin()) {
            return true;
        }
        if (name.equals(Organization.class.getName()) && this.isOrganizationAdminImpl(GetterUtil.getLong((String)primKey))) {
            return true;
        }
        if (this.isCompanyAdminImpl(companyId)) {
            return true;
        }
        if (this._isGroupAdminImpl(group)) {
            boolean hasLayoutManagerPermission = true;
            if (Validator.isNotNull((String)name) && Validator.isNotNull((String)primKey) && primKey.contains("_LAYOUT_")) {
                hasLayoutManagerPermission = PortletPermissionUtil.hasLayoutManagerPermission((String)name, (String)actionId);
            }
            if (hasLayoutManagerPermission) {
                return true;
            }
        }
        return false;
    }

    private boolean _isGroupAdminImpl(Group group) throws Exception {
        if (!this.signedIn) {
            return false;
        }
        if (this.isOmniadmin()) {
            return true;
        }
        if (group == null) {
            return false;
        }
        if (this.isCompanyAdmin(group.getCompanyId())) {
            return true;
        }
        Boolean value = PermissionCacheUtil.getUserPrimaryKeyRole(this.getUserId(), group.getGroupId(), "Site Administrator");
        try {
            if (value == null) {
                value = this.isGroupAdminImpl(group);
                PermissionCacheUtil.putUserPrimaryKeyRole(this.getUserId(), group.getGroupId(), "Site Administrator", value);
            }
        }
        catch (Exception e) {
            PermissionCacheUtil.removeUserPrimaryKeyRole(this.getUserId(), group.getGroupId(), "Site Administrator");
            throw e;
        }
        return value;
    }
}

