/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.EmailAddress;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.kernel.model.Phone;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserConstants;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.Website;
import com.liferay.portal.kernel.security.auth.EmailAddressGenerator;
import com.liferay.portal.kernel.security.auth.FullNameGenerator;
import com.liferay.portal.kernel.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.kernel.service.AddressLocalServiceUtil;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.ContactLocalServiceUtil;
import com.liferay.portal.kernel.service.EmailAddressLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.PasswordPolicyLocalServiceUtil;
import com.liferay.portal.kernel.service.PhoneLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.TeamLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.WebsiteLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.RemotePreference;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.ContactImpl;
import com.liferay.portal.model.impl.UserBaseImpl;
import com.liferay.portal.security.auth.EmailAddressGeneratorFactory;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;

public class UserImpl
extends UserBaseImpl {
    private static final Contact _NULL_CONTACT = new ContactImpl();
    private static final Log _log = LogFactoryUtil.getLog(UserImpl.class);
    private static final boolean _hasUsersProfileFriendlyURL = Validator.isNull((String)PropsValues.USERS_PROFILE_FRIENDLY_URL);
    private Contact _contact;
    private Locale _locale;
    private boolean _passwordModified;
    private PasswordPolicy _passwordPolicy;
    private String _passwordUnencrypted;
    private final transient Map<String, RemotePreference> _remotePreferences = new HashMap<String, RemotePreference>();
    private TimeZone _timeZone;

    public void addRemotePreference(RemotePreference remotePreference) {
        this._remotePreferences.put(remotePreference.getName(), remotePreference);
    }

    public Contact fetchContact() {
        if (this._contact == _NULL_CONTACT) {
            return null;
        }
        if (this._contact == null) {
            Contact contact = ContactLocalServiceUtil.fetchContact((long)this.getContactId());
            this._contact = contact == null ? _NULL_CONTACT : contact;
        }
        return this._contact;
    }

    public List<Address> getAddresses() {
        return AddressLocalServiceUtil.getAddresses((long)this.getCompanyId(), (String)Contact.class.getName(), (long)this.getContactId());
    }

    public Date getBirthday() throws PortalException {
        return this.getContact().getBirthday();
    }

    public String getCompanyMx() throws PortalException {
        Company company = CompanyLocalServiceUtil.getCompanyById((long)this.getCompanyId());
        return company.getMx();
    }

    public Contact getContact() throws PortalException {
        if (this._contact == null || this._contact == _NULL_CONTACT) {
            this._contact = ContactLocalServiceUtil.getContact((long)this.getContactId());
        }
        return this._contact;
    }

    @Override
    public String getDigest() {
        String digest = super.getDigest();
        if (Validator.isNull((String)digest) && !this.isPasswordEncrypted()) {
            digest = this.getDigest(this.getPassword());
        }
        return digest;
    }

    public String getDigest(String password) {
        if (Validator.isNull((String)this.getScreenName())) {
            throw new IllegalStateException("Screen name is null");
        }
        if (Validator.isNull((String)this.getEmailAddress())) {
            throw new IllegalStateException("Email address is null");
        }
        StringBundler sb = new StringBundler(5);
        String digest1 = DigesterUtil.digestHex((String)"MD5", (String[])new String[]{this.getEmailAddress(), "PortalRealm", password});
        sb.append(digest1);
        sb.append(",");
        String digest2 = DigesterUtil.digestHex((String)"MD5", (String[])new String[]{this.getScreenName(), "PortalRealm", password});
        sb.append(digest2);
        sb.append(",");
        String digest3 = DigesterUtil.digestHex((String)"MD5", (String[])new String[]{String.valueOf(this.getUserId()), "PortalRealm", password});
        sb.append(digest3);
        return sb.toString();
    }

    public String getDisplayEmailAddress() {
        String emailAddress = super.getEmailAddress();
        EmailAddressGenerator emailAddressGenerator = EmailAddressGeneratorFactory.getInstance();
        if (emailAddressGenerator.isFake(emailAddress)) {
            emailAddress = "";
        }
        return emailAddress;
    }

    @Deprecated
    public String getDisplayURL(String portalURL, String mainPath) throws PortalException {
        return this.getDisplayURL(portalURL, mainPath, false);
    }

    @Deprecated
    public String getDisplayURL(String portalURL, String mainPath, boolean privateLayout) throws PortalException {
        if (this.isDefaultUser()) {
            return "";
        }
        String profileFriendlyURL = this.getProfileFriendlyURL();
        if (profileFriendlyURL != null) {
            return portalURL.concat(PortalUtil.getPathContext()).concat(profileFriendlyURL);
        }
        return "";
    }

    public String getDisplayURL(ThemeDisplay themeDisplay) throws PortalException {
        return this.getDisplayURL(themeDisplay, false);
    }

    public String getDisplayURL(ThemeDisplay themeDisplay, boolean privateLayout) throws PortalException {
        if (this.isDefaultUser() || themeDisplay == null) {
            return "";
        }
        String portalURL = themeDisplay.getPortalURL();
        String profileFriendlyURL = this.getProfileFriendlyURL();
        if (profileFriendlyURL != null) {
            return PortalUtil.addPreservedParameters((ThemeDisplay)themeDisplay, (String)portalURL.concat(PortalUtil.getPathContext()).concat(profileFriendlyURL));
        }
        Group group = this.getGroup();
        return group.getDisplayURL(themeDisplay, privateLayout);
    }

    public List<EmailAddress> getEmailAddresses() {
        return EmailAddressLocalServiceUtil.getEmailAddresses((long)this.getCompanyId(), (String)Contact.class.getName(), (long)this.getContactId());
    }

    public boolean getFemale() throws PortalException {
        return !this.getMale();
    }

    @AutoEscape
    public String getFullName() {
        return this.getFullName(false, false);
    }

    @AutoEscape
    public String getFullName(boolean usePrefix, boolean useSuffix) {
        Contact contact;
        Contact contact2;
        FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
        long prefixId = 0L;
        if (usePrefix && (contact2 = this.fetchContact()) != null) {
            prefixId = contact2.getPrefixId();
        }
        long suffixId = 0L;
        if (useSuffix && (contact = this.fetchContact()) != null) {
            suffixId = contact.getSuffixId();
        }
        return fullNameGenerator.getLocalizedFullName(this.getFirstName(), this.getMiddleName(), this.getLastName(), this.getLocale(), prefixId, suffixId);
    }

    public Group getGroup() {
        return GroupLocalServiceUtil.fetchUserGroup((long)this.getCompanyId(), (long)this.getUserId());
    }

    public long getGroupId() {
        Group group = this.getGroup();
        return group.getGroupId();
    }

    public long[] getGroupIds() {
        return UserLocalServiceUtil.getGroupPrimaryKeys((long)this.getUserId());
    }

    public List<Group> getGroups() {
        return GroupLocalServiceUtil.getUserGroups((long)this.getUserId());
    }

    public String getInitials() {
        String firstInitial = StringUtil.shorten((String)this.getFirstName(), (int)1);
        String lastInitial = StringUtil.shorten((String)this.getLastName(), (int)1);
        return StringUtil.toUpperCase((String)firstInitial.concat(lastInitial));
    }

    public Locale getLocale() {
        return this._locale;
    }

    public String getLogin() throws PortalException {
        String login = null;
        Company company = CompanyLocalServiceUtil.getCompanyById((long)this.getCompanyId());
        if (company.getAuthType().equals("emailAddress")) {
            login = this.getEmailAddress();
        } else if (company.getAuthType().equals("screenName")) {
            login = this.getScreenName();
        } else if (company.getAuthType().equals("userId")) {
            login = String.valueOf(this.getUserId());
        }
        return login;
    }

    public boolean getMale() throws PortalException {
        return this.getContact().getMale();
    }

    public List<Group> getMySiteGroups() throws PortalException {
        return this.getMySiteGroups(null, -1);
    }

    public List<Group> getMySiteGroups(int max) throws PortalException {
        return this.getMySiteGroups(null, max);
    }

    public List<Group> getMySiteGroups(String[] classNames, int max) throws PortalException {
        return GroupServiceUtil.getUserSitesGroups((long)this.getUserId(), (String[])classNames, (int)max);
    }

    public long[] getOrganizationIds() throws PortalException {
        return this.getOrganizationIds(false);
    }

    public long[] getOrganizationIds(boolean includeAdministrative) throws PortalException {
        return OrganizationLocalServiceUtil.getUserOrganizationIds((long)this.getUserId(), (boolean)includeAdministrative);
    }

    public List<Organization> getOrganizations() throws PortalException {
        return this.getOrganizations(false);
    }

    public List<Organization> getOrganizations(boolean includeAdministrative) throws PortalException {
        return OrganizationLocalServiceUtil.getUserOrganizations((long)this.getUserId(), (boolean)includeAdministrative);
    }

    @Override
    public String getOriginalEmailAddress() {
        return super.getOriginalEmailAddress();
    }

    public boolean getPasswordModified() {
        return this._passwordModified;
    }

    public PasswordPolicy getPasswordPolicy() throws PortalException {
        if (this._passwordPolicy == null) {
            this._passwordPolicy = PasswordPolicyLocalServiceUtil.getPasswordPolicyByUser((User)this);
        }
        return this._passwordPolicy;
    }

    public String getPasswordUnencrypted() {
        return this._passwordUnencrypted;
    }

    public List<Phone> getPhones() {
        return PhoneLocalServiceUtil.getPhones((long)this.getCompanyId(), (String)Contact.class.getName(), (long)this.getContactId());
    }

    public String getPortraitURL(ThemeDisplay themeDisplay) throws PortalException {
        return UserConstants.getPortraitURL((String)themeDisplay.getPathImage(), (boolean)this.isMale(), (long)this.getPortraitId(), (String)this.getUserUuid());
    }

    public int getPrivateLayoutsPageCount() throws PortalException {
        return LayoutLocalServiceUtil.getLayoutsCount((User)this, (boolean)true);
    }

    public int getPublicLayoutsPageCount() throws PortalException {
        return LayoutLocalServiceUtil.getLayoutsCount((User)this, (boolean)false);
    }

    public Set<String> getReminderQueryQuestions() throws PortalException {
        TreeSet<String> questions = new TreeSet<String>();
        List organizations = OrganizationLocalServiceUtil.getUserOrganizations((long)this.getUserId());
        for (Organization organization : organizations) {
            Set organizationQuestions = organization.getReminderQueryQuestions(this.getLanguageId());
            if (organizationQuestions.isEmpty()) {
                for (Organization parentOrganization = organization.getParentOrganization(); organizationQuestions.isEmpty() && parentOrganization != null; parentOrganization = parentOrganization.getParentOrganization()) {
                    organizationQuestions = parentOrganization.getReminderQueryQuestions(this.getLanguageId());
                }
            }
            questions.addAll(organizationQuestions);
        }
        if (questions.isEmpty()) {
            Set defaultQuestions = SetUtil.fromArray((Object[])PropsUtil.getArray("users.reminder.queries.questions"));
            questions.addAll(defaultQuestions);
        }
        return questions;
    }

    public RemotePreference getRemotePreference(String name) {
        return this._remotePreferences.get(name);
    }

    public Iterable<RemotePreference> getRemotePreferences() {
        Collection<RemotePreference> values = this._remotePreferences.values();
        return Collections.unmodifiableCollection(values);
    }

    public long[] getRoleIds() {
        return UserLocalServiceUtil.getRolePrimaryKeys((long)this.getUserId());
    }

    public List<Role> getRoles() {
        return RoleLocalServiceUtil.getUserRoles((long)this.getUserId());
    }

    public List<Group> getSiteGroups() throws PortalException {
        return this.getSiteGroups(false);
    }

    public List<Group> getSiteGroups(boolean includeAdministrative) throws PortalException {
        return GroupLocalServiceUtil.getUserSitesGroups((long)this.getUserId(), (boolean)includeAdministrative);
    }

    public long[] getTeamIds() {
        return UserLocalServiceUtil.getTeamPrimaryKeys((long)this.getUserId());
    }

    public List<Team> getTeams() {
        return TeamLocalServiceUtil.getUserTeams((long)this.getUserId());
    }

    public TimeZone getTimeZone() {
        return this._timeZone;
    }

    public Date getUnlockDate() throws PortalException {
        return this.getUnlockDate(this.getPasswordPolicy());
    }

    public Date getUnlockDate(PasswordPolicy passwordPolicy) {
        Date lockoutDate = this.getLockoutDate();
        return new Date(lockoutDate.getTime() + passwordPolicy.getLockoutDuration() * 1000L);
    }

    public long[] getUserGroupIds() {
        return UserLocalServiceUtil.getUserGroupPrimaryKeys((long)this.getUserId());
    }

    public List<UserGroup> getUserGroups() {
        return UserGroupLocalServiceUtil.getUserUserGroups((long)this.getUserId());
    }

    public List<Website> getWebsites() {
        return WebsiteLocalServiceUtil.getWebsites((long)this.getCompanyId(), (String)Contact.class.getName(), (long)this.getContactId());
    }

    public boolean hasCompanyMx() throws PortalException {
        return this.hasCompanyMx(this.getEmailAddress());
    }

    public boolean hasCompanyMx(String emailAddress) throws PortalException {
        if (Validator.isNull((String)emailAddress)) {
            return false;
        }
        Company company = CompanyLocalServiceUtil.getCompanyById((long)this.getCompanyId());
        return company.hasCompanyMx(emailAddress);
    }

    public boolean hasMySites() throws PortalException {
        if (this.isDefaultUser()) {
            return false;
        }
        List<Group> groups = this.getMySiteGroups(1);
        return !groups.isEmpty();
    }

    public boolean hasOrganization() {
        return OrganizationLocalServiceUtil.hasUserOrganizations((long)this.getUserId());
    }

    public boolean hasPrivateLayouts() throws PortalException {
        return LayoutLocalServiceUtil.hasLayouts((User)this, (boolean)true);
    }

    public boolean hasPublicLayouts() throws PortalException {
        return LayoutLocalServiceUtil.hasLayouts((User)this, (boolean)false);
    }

    public boolean hasReminderQuery() {
        return Validator.isNotNull((String)this.getReminderQueryQuestion()) && Validator.isNotNull((String)this.getReminderQueryAnswer());
    }

    public boolean isActive() {
        return this.getStatus() == 0;
    }

    public boolean isEmailAddressComplete() {
        if (this.isDefaultUser()) {
            return true;
        }
        return !Validator.isNull((String)this.getEmailAddress()) && (!PropsValues.USERS_EMAIL_ADDRESS_REQUIRED || !Validator.isNull((String)this.getDisplayEmailAddress()));
    }

    public boolean isEmailAddressVerificationComplete() {
        if (this.isDefaultUser() || this.isEmailAddressVerified()) {
            return true;
        }
        boolean emailAddressVerificationRequired = false;
        try {
            Company company = CompanyLocalServiceUtil.getCompany((long)this.getCompanyId());
            emailAddressVerificationRequired = company.isStrangersVerify();
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
        }
        return !emailAddressVerificationRequired;
    }

    public boolean isFemale() throws PortalException {
        return this.getFemale();
    }

    public boolean isMale() throws PortalException {
        return this.getMale();
    }

    public boolean isPasswordModified() {
        return this._passwordModified;
    }

    public boolean isReminderQueryComplete() {
        if (this.isDefaultUser()) {
            return true;
        }
        return !PropsValues.USERS_REMINDER_QUERIES_ENABLED || !Validator.isNull((String)this.getReminderQueryQuestion()) && !Validator.isNull((String)this.getReminderQueryAnswer());
    }

    public boolean isSetupComplete() {
        if (this.isDefaultUser()) {
            return true;
        }
        return this.isEmailAddressComplete() && this.isEmailAddressVerificationComplete() && !this.isPasswordReset() && this.isReminderQueryComplete() && this.isTermsOfUseComplete();
    }

    public boolean isTermsOfUseComplete() {
        if (this.isDefaultUser() || this.isAgreedToTermsOfUse()) {
            return true;
        }
        boolean termsOfUseRequired = PrefsPropsUtil.getBoolean(this.getCompanyId(), "terms.of.use.required", PropsValues.TERMS_OF_USE_REQUIRED);
        return !termsOfUseRequired;
    }

    @Override
    public void setLanguageId(String languageId) {
        this._locale = LocaleUtil.fromLanguageId((String)languageId);
        super.setLanguageId(LocaleUtil.toLanguageId((Locale)this._locale));
    }

    public void setPasswordModified(boolean passwordModified) {
        this._passwordModified = passwordModified;
    }

    public void setPasswordUnencrypted(String passwordUnencrypted) {
        this._passwordUnencrypted = passwordUnencrypted;
    }

    @Override
    public void setTimeZoneId(String timeZoneId) {
        if (Validator.isNull((String)timeZoneId)) {
            timeZoneId = TimeZoneUtil.getDefault().getID();
        }
        this._timeZone = TimeZoneUtil.getTimeZone((String)timeZoneId);
        super.setTimeZoneId(timeZoneId);
    }

    protected String getProfileFriendlyURL() {
        if (!_hasUsersProfileFriendlyURL) {
            return null;
        }
        return StringUtil.replace((String)PropsValues.USERS_PROFILE_FRIENDLY_URL, (String[])new String[]{"${liferay:screenName}", "${liferay:userId}"}, (String[])new String[]{HtmlUtil.escapeURL((String)this.getScreenName()), String.valueOf(this.getUserId())});
    }
}

