/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.exception.LayoutFriendlyURLException;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutFriendlyURL;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutType;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.model.PortletWrapper;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutFriendlyURLLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.service.ThemeLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LayoutTypePortletFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.LayoutBaseImpl;
import com.liferay.portal.model.impl.ThemeSettingImpl;
import com.liferay.portal.util.LayoutClone;
import com.liferay.portal.util.LayoutCloneFactory;
import com.liferay.portal.util.LayoutTypeControllerTracker;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class LayoutImpl
extends LayoutBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(LayoutImpl.class);
    private static String[] _friendlyURLKeywords;
    private final Map<Locale, String> _friendlyURLs = new HashMap<Locale, String>();
    private LayoutSet _layoutSet;
    private transient LayoutType _layoutType;
    private UnicodeProperties _typeSettingsProperties;

    public static boolean hasFriendlyURLKeyword(String friendlyURL) {
        String keyword = LayoutImpl._getFriendlyURLKeyword(friendlyURL);
        return Validator.isNotNull((String)keyword);
    }

    public static int validateFriendlyURL(String friendlyURL) {
        return LayoutImpl.validateFriendlyURL(friendlyURL, true);
    }

    public static int validateFriendlyURL(String friendlyURL, boolean checkMaxLength) {
        if (friendlyURL.length() < 2) {
            return 3;
        }
        if (checkMaxLength && friendlyURL.length() > 255) {
            return 10;
        }
        if (!friendlyURL.startsWith("/")) {
            return 1;
        }
        if (friendlyURL.endsWith("/")) {
            return 2;
        }
        if (friendlyURL.contains("//")) {
            return 4;
        }
        for (char c : friendlyURL.toCharArray()) {
            if (Validator.isChar((char)c) || Validator.isDigit((char)c) || c == '-' || c == '%' || c == '.' || c == '+' || c == '/' || c == '*' || c == '_') continue;
            return 5;
        }
        return -1;
    }

    public static void validateFriendlyURLKeyword(String friendlyURL) throws LayoutFriendlyURLException {
        String keyword = LayoutImpl._getFriendlyURLKeyword(friendlyURL);
        if (Validator.isNotNull((String)keyword)) {
            LayoutFriendlyURLException lfurle = new LayoutFriendlyURLException(7);
            lfurle.setKeywordConflict(keyword);
            throw lfurle;
        }
    }

    public List<Layout> getAllChildren() {
        ArrayList<Layout> layouts = new ArrayList<Layout>();
        for (Layout layout : this.getChildren()) {
            layouts.add(layout);
            layouts.addAll(layout.getAllChildren());
        }
        return layouts;
    }

    public long getAncestorLayoutId() throws PortalException {
        long layoutId = 0L;
        LayoutImpl layout = this;
        while (!layout.isRootLayout()) {
            layout = LayoutLocalServiceUtil.getLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getParentLayoutId());
        }
        layoutId = layout.getLayoutId();
        return layoutId;
    }

    public long getAncestorPlid() throws PortalException {
        long plid = 0L;
        LayoutImpl layout = this;
        while (!layout.isRootLayout()) {
            layout = LayoutLocalServiceUtil.getLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getParentLayoutId());
        }
        plid = layout.getPlid();
        return plid;
    }

    public List<Layout> getAncestors() throws PortalException {
        List<Layout> layouts = Collections.emptyList();
        LayoutImpl layout = this;
        while (!layout.isRootLayout()) {
            layout = LayoutLocalServiceUtil.getLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getParentLayoutId());
            if (layouts.isEmpty()) {
                layouts = new ArrayList<Layout>();
            }
            layouts.add(layout);
        }
        return layouts;
    }

    public List<Layout> getChildren() {
        return LayoutLocalServiceUtil.getLayouts((long)this.getGroupId(), (boolean)this.isPrivateLayout(), (long)this.getLayoutId());
    }

    public List<Layout> getChildren(PermissionChecker permissionChecker) throws PortalException {
        List layouts = ListUtil.copy(this.getChildren());
        Iterator itr = layouts.iterator();
        while (itr.hasNext()) {
            Layout layout = (Layout)itr.next();
            if (!layout.isHidden() && LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"VIEW")) continue;
            itr.remove();
        }
        return layouts;
    }

    public ColorScheme getColorScheme() throws PortalException {
        if (this.isInheritLookAndFeel()) {
            LayoutSet layoutSet = this.getLayoutSet();
            return layoutSet.getColorScheme();
        }
        Theme theme = this.getTheme();
        return ThemeLocalServiceUtil.getColorScheme((long)this.getCompanyId(), (String)theme.getThemeId(), (String)this.getColorSchemeId());
    }

    public String getCssText() throws PortalException {
        if (this.isInheritLookAndFeel()) {
            LayoutSet layoutSet = this.getLayoutSet();
            return layoutSet.getCss();
        }
        return this.getCss();
    }

    public String getDefaultThemeSetting(String key, String device, boolean inheritLookAndFeel) {
        if (!inheritLookAndFeel) {
            try {
                Theme theme = this.getTheme();
                return theme.getSetting(key);
            }
            catch (Exception theme) {
                // empty catch block
            }
        }
        try {
            LayoutSet layoutSet = this.getLayoutSet();
            return layoutSet.getThemeSetting(key, device);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public List<Portlet> getEmbeddedPortlets() {
        return this.getEmbeddedPortlets(this.getGroupId());
    }

    public List<Portlet> getEmbeddedPortlets(long groupId) {
        List<PortletPreferences> portletPreferences = this._getPortletPreferences(groupId);
        if (portletPreferences.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Portlet> portlets = new ArrayList<Portlet>();
        Set<String> layoutPortletIds = this._getLayoutPortletIds();
        for (PortletPreferences portletPreference : portletPreferences) {
            String portletId = portletPreference.getPortletId();
            Object portlet = PortletLocalServiceUtil.getPortletById((long)this.getCompanyId(), (String)portletId);
            if (portlet == null || !portlet.isReady() || portlet.isUndeployedPortlet() || !portlet.isActive() || !layoutPortletIds.contains(portletId)) continue;
            Portlet embeddedPortlet = portlet;
            if (!portlet.isInstanceable()) {
                portlet = new PortletWrapper((Portlet)portlet){
                    private boolean _staticPortlet;

                    public boolean getStatic() {
                        return this._staticPortlet;
                    }

                    public boolean isStatic() {
                        return this._staticPortlet;
                    }

                    public void setStatic(boolean staticPortlet) {
                        this._staticPortlet = staticPortlet;
                    }
                };
            }
            embeddedPortlet.setStatic(true);
            portlets.add(embeddedPortlet);
        }
        return portlets;
    }

    public String getFriendlyURL(Locale locale) {
        String friendlyURL = this._friendlyURLs.get(locale);
        if (friendlyURL != null) {
            return friendlyURL;
        }
        friendlyURL = this.getFriendlyURL();
        try {
            Object[] locales;
            Group group = this.getGroup();
            UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
            if (!GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("inheritLocales"), (boolean)true) && !ArrayUtil.contains((Object[])(locales = StringUtil.split((String)typeSettingsProperties.getProperty("locales"))), (Object)LanguageUtil.getLanguageId((Locale)locale))) {
                this._friendlyURLs.put(locale, friendlyURL);
                return friendlyURL;
            }
            LayoutFriendlyURL layoutFriendlyURL = LayoutFriendlyURLLocalServiceUtil.getLayoutFriendlyURL((long)this.getPlid(), (String)LocaleUtil.toLanguageId((Locale)locale));
            friendlyURL = layoutFriendlyURL.getFriendlyURL();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._friendlyURLs.put(locale, friendlyURL);
        return friendlyURL;
    }

    public Map<Locale, String> getFriendlyURLMap() {
        HashMap<Locale, String> friendlyURLMap = new HashMap<Locale, String>();
        List layoutFriendlyURLs = LayoutFriendlyURLLocalServiceUtil.getLayoutFriendlyURLs((long)this.getPlid());
        for (LayoutFriendlyURL layoutFriendlyURL : layoutFriendlyURLs) {
            friendlyURLMap.put(LocaleUtil.fromLanguageId((String)layoutFriendlyURL.getLanguageId()), layoutFriendlyURL.getFriendlyURL());
        }
        Locale defaultSiteLocale = LocaleUtil.getSiteDefault();
        if (Validator.isNull((String)((String)friendlyURLMap.get(defaultSiteLocale)))) {
            Locale defaultLocale = LocaleUtil.fromLanguageId((String)this.getDefaultLanguageId());
            String defaultFriendlyURL = (String)friendlyURLMap.get(defaultLocale);
            friendlyURLMap.put(defaultSiteLocale, defaultFriendlyURL);
        }
        return friendlyURLMap;
    }

    public String getFriendlyURLsXML() {
        Map<Locale, String> friendlyURLMap = this.getFriendlyURLMap();
        return LocalizationUtil.updateLocalization(friendlyURLMap, (String)"", (String)"FriendlyURL", (String)LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault()));
    }

    public Group getGroup() throws PortalException {
        return GroupLocalServiceUtil.getGroup((long)this.getGroupId());
    }

    public String getHTMLTitle(Locale locale) {
        String localeLanguageId = LocaleUtil.toLanguageId((Locale)locale);
        return this.getHTMLTitle(localeLanguageId);
    }

    public String getHTMLTitle(String localeLanguageId) {
        String htmlTitle = this.getTitle(localeLanguageId);
        if (Validator.isNull((String)htmlTitle)) {
            htmlTitle = this.getName(localeLanguageId);
        }
        return htmlTitle;
    }

    public boolean getIconImage() {
        return this.getIconImageId() > 0L;
    }

    public LayoutSet getLayoutSet() throws PortalException {
        if (this._layoutSet == null) {
            this._layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)this.getGroupId(), (boolean)this.isPrivateLayout());
        }
        return this._layoutSet;
    }

    public LayoutType getLayoutType() {
        if (this._layoutType == null) {
            this._layoutType = LayoutTypePortletFactoryUtil.create((Layout)this);
        }
        return this._layoutType;
    }

    public Layout getLinkedToLayout() {
        long linkToLayoutId = GetterUtil.getLong((String)this.getTypeSettingsProperty("linkToLayoutId"));
        if (linkToLayoutId <= 0L) {
            return null;
        }
        return LayoutLocalServiceUtil.fetchLayout((long)this.getGroupId(), (boolean)this.isPrivateLayout(), (long)linkToLayoutId);
    }

    public long getParentPlid() throws PortalException {
        if (this.getParentLayoutId() == 0L) {
            return 0L;
        }
        Layout layout = LayoutLocalServiceUtil.getLayout((long)this.getGroupId(), (boolean)this.isPrivateLayout(), (long)this.getParentLayoutId());
        return layout.getPlid();
    }

    public String getRegularURL(HttpServletRequest request) throws PortalException {
        String url = this._getURL(request, false, false);
        if (!url.startsWith("http") && !url.startsWith("/")) {
            return "/" + url;
        }
        return url;
    }

    public String getResetLayoutURL(HttpServletRequest request) throws PortalException {
        return this._getURL(request, true, true);
    }

    public String getResetMaxStateURL(HttpServletRequest request) throws PortalException {
        return this._getURL(request, true, false);
    }

    public Group getScopeGroup() throws PortalException {
        Group group;
        block2: {
            group = null;
            try {
                group = GroupLocalServiceUtil.getLayoutGroup((long)this.getCompanyId(), (long)this.getPlid());
            }
            catch (NoSuchGroupException nsge) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)nsge, (Throwable)nsge);
            }
        }
        return group;
    }

    public String getTarget() {
        return PortalUtil.getLayoutTarget((Layout)this);
    }

    public Theme getTheme() throws PortalException {
        if (this.isInheritLookAndFeel()) {
            LayoutSet layoutSet = this.getLayoutSet();
            return layoutSet.getTheme();
        }
        return ThemeLocalServiceUtil.getTheme((long)this.getCompanyId(), (String)this.getThemeId());
    }

    public String getThemeSetting(String key, String device) {
        return this.getThemeSetting(key, device, this.isInheritLookAndFeel());
    }

    public String getThemeSetting(String key, String device, boolean inheritLookAndFeel) {
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
        String value = typeSettingsProperties.getProperty(ThemeSettingImpl.namespaceProperty(device, key));
        if (value != null) {
            return value;
        }
        return this.getDefaultThemeSetting(key, device, inheritLookAndFeel);
    }

    @Override
    public String getTypeSettings() {
        if (this._typeSettingsProperties == null) {
            return super.getTypeSettings();
        }
        return this._typeSettingsProperties.toString();
    }

    public UnicodeProperties getTypeSettingsProperties() {
        if (this._typeSettingsProperties == null) {
            this._typeSettingsProperties = new UnicodeProperties(true);
            this._typeSettingsProperties.fastLoad(super.getTypeSettings());
        }
        return this._typeSettingsProperties;
    }

    public String getTypeSettingsProperty(String key) {
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
        return typeSettingsProperties.getProperty(key);
    }

    public String getTypeSettingsProperty(String key, String defaultValue) {
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
        return typeSettingsProperties.getProperty(key, defaultValue);
    }

    public boolean hasAncestor(long layoutId) throws PortalException {
        long parentLayoutId = this.getParentLayoutId();
        while (parentLayoutId != 0L) {
            if (parentLayoutId == layoutId) {
                return true;
            }
            Layout parentLayout = LayoutLocalServiceUtil.getLayout((long)this.getGroupId(), (boolean)this.isPrivateLayout(), (long)parentLayoutId);
            parentLayoutId = parentLayout.getParentLayoutId();
        }
        return false;
    }

    public boolean hasChildren() {
        return LayoutLocalServiceUtil.hasLayouts((long)this.getGroupId(), (boolean)this.isPrivateLayout(), (long)this.getLayoutId());
    }

    public boolean hasScopeGroup() throws PortalException {
        Group group = this.getScopeGroup();
        return group != null;
    }

    @Override
    public boolean hasSetModifiedDate() {
        return true;
    }

    public boolean includeLayoutContent(HttpServletRequest request, HttpServletResponse response) throws Exception {
        LayoutTypeController layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController(this.getType());
        return layoutTypeController.includeLayoutContent(request, response, (Layout)this);
    }

    public boolean isChildSelected(boolean selectable, Layout layout) throws PortalException {
        if (selectable) {
            long plid = this.getPlid();
            List ancestors = layout.getAncestors();
            for (Layout curLayout : ancestors) {
                if (plid != curLayout.getPlid()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isContentDisplayPage() {
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
        String defaultAssetPublisherPortletId = typeSettingsProperties.getProperty("default-asset-publisher-portlet-id");
        return Validator.isNotNull((String)defaultAssetPublisherPortletId);
    }

    public boolean isCustomizable() {
        if (!this.isTypePortlet()) {
            return false;
        }
        if (GetterUtil.getBoolean((String)this.getTypeSettingsProperty("CUSTOMIZABLE_LAYOUT"))) {
            return true;
        }
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)this.getLayoutType();
        return layoutTypePortlet.isCustomizable();
    }

    public boolean isFirstChild() {
        return this.getPriority() == 0;
    }

    public boolean isFirstParent() {
        return this.isFirstChild() && this.isRootLayout();
    }

    public boolean isIconImage() {
        return this.getIconImage();
    }

    public boolean isInheritLookAndFeel() {
        return Validator.isNull((String)this.getThemeId()) || Validator.isNull((String)this.getColorSchemeId());
    }

    public boolean isLayoutPrototypeLinkActive() {
        return this.isLayoutPrototypeLinkEnabled() && Validator.isNotNull((String)this.getLayoutPrototypeUuid());
    }

    public boolean isPortletEmbedded(String portletId, long groupId) {
        List<Portlet> embeddedPortlets = this.getEmbeddedPortlets(groupId);
        if (embeddedPortlets.isEmpty()) {
            return false;
        }
        for (Portlet portlet : embeddedPortlets) {
            if (!Objects.equals(portlet.getPortletId(), portletId)) continue;
            return true;
        }
        return false;
    }

    public boolean isPublicLayout() {
        return !this.isPrivateLayout();
    }

    public boolean isRootLayout() {
        return this.getParentLayoutId() == 0L;
    }

    public boolean isSelected(boolean selectable, Layout layout, long ancestorPlid) {
        long plid;
        return selectable && ((plid = this.getPlid()) == layout.getPlid() || plid == ancestorPlid);
    }

    public boolean isSupportsEmbeddedPortlets() {
        return this.isTypeEmbedded() || this.isTypePanel() || this.isTypePortlet();
    }

    @Deprecated
    public boolean isTypeArticle() {
        return false;
    }

    public boolean isTypeControlPanel() {
        return Objects.equals(this.getType(), "control_panel") || Objects.equals(this._getLayoutTypeControllerType(), "control_panel");
    }

    public boolean isTypeEmbedded() {
        return Objects.equals(this.getType(), "embedded") || Objects.equals(this._getLayoutTypeControllerType(), "embedded");
    }

    public boolean isTypeLinkToLayout() {
        return Objects.equals(this.getType(), "link_to_layout") || Objects.equals(this._getLayoutTypeControllerType(), "link_to_layout");
    }

    public boolean isTypePanel() {
        return Objects.equals(this.getType(), "panel") || Objects.equals(this._getLayoutTypeControllerType(), "panel");
    }

    public boolean isTypePortlet() {
        return Objects.equals(this.getType(), "portlet") || Objects.equals(this._getLayoutTypeControllerType(), "portlet");
    }

    public boolean isTypeSharedPortlet() {
        return Objects.equals(this.getType(), "shared_portlet");
    }

    public boolean isTypeURL() {
        return Objects.equals(this.getType(), "url");
    }

    public boolean matches(HttpServletRequest request, String friendlyURL) {
        LayoutType layoutType = this.getLayoutType();
        LayoutTypeController layoutTypeController = layoutType.getLayoutTypeController();
        return layoutTypeController.matches(request, friendlyURL, (Layout)this);
    }

    @Override
    public void setGroupId(long groupId) {
        super.setGroupId(groupId);
        this._layoutSet = null;
    }

    public void setLayoutSet(LayoutSet layoutSet) {
        this._layoutSet = layoutSet;
    }

    @Override
    public void setPrivateLayout(boolean privateLayout) {
        super.setPrivateLayout(privateLayout);
        this._layoutSet = null;
    }

    @Override
    public void setTypeSettings(String typeSettings) {
        this._typeSettingsProperties = null;
        super.setTypeSettings(typeSettings);
    }

    public void setTypeSettingsProperties(UnicodeProperties typeSettingsProperties) {
        this._typeSettingsProperties = typeSettingsProperties;
        super.setTypeSettings(this._typeSettingsProperties.toString());
    }

    private static String _getFriendlyURLKeyword(String friendlyURL) {
        friendlyURL = StringUtil.toLowerCase((String)friendlyURL);
        for (String keyword : _friendlyURLKeywords) {
            if (friendlyURL.startsWith(keyword)) {
                return keyword;
            }
            if (!keyword.equals(friendlyURL + "/")) continue;
            return friendlyURL;
        }
        return null;
    }

    private static void _initFriendlyURLKeywords() {
        _friendlyURLKeywords = new String[PropsValues.LAYOUT_FRIENDLY_URL_KEYWORDS.length];
        for (int i = 0; i < PropsValues.LAYOUT_FRIENDLY_URL_KEYWORDS.length; ++i) {
            String keyword = PropsValues.LAYOUT_FRIENDLY_URL_KEYWORDS[i];
            keyword = "/" + keyword;
            if (!keyword.contains(".")) {
                keyword = keyword.endsWith("*") ? keyword.substring(0, keyword.length() - 1) : keyword + "/";
            }
            LayoutImpl._friendlyURLKeywords[i] = StringUtil.toLowerCase((String)keyword);
        }
    }

    private Set<String> _getLayoutPortletIds() {
        HashSet<String> layoutPortletIds = new HashSet<String>();
        List portletPreferences = PortletPreferencesLocalServiceUtil.getPortletPreferences((long)0L, (int)3, (long)this.getPlid());
        for (PortletPreferences portletPreference : portletPreferences) {
            layoutPortletIds.add(portletPreference.getPortletId());
        }
        return layoutPortletIds;
    }

    private String _getLayoutTypeControllerType() {
        LayoutTypeController layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController(this.getType());
        return layoutTypeController.getType();
    }

    private LayoutTypePortlet _getLayoutTypePortletClone(HttpServletRequest request) throws IOException {
        String typeSettings;
        LayoutTypePortlet layoutTypePortlet = null;
        LayoutClone layoutClone = LayoutCloneFactory.getInstance();
        if (layoutClone != null && (typeSettings = layoutClone.get(request, this.getPlid())) != null) {
            UnicodeProperties typeSettingsProperties = new UnicodeProperties(true);
            typeSettingsProperties.load(typeSettings);
            String stateMax = typeSettingsProperties.getProperty("state-max");
            String stateMin = typeSettingsProperties.getProperty("state-min");
            Layout layout = (Layout)this.clone();
            layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            layoutTypePortlet.setStateMax(stateMax);
            layoutTypePortlet.setStateMin(stateMin);
        }
        if (layoutTypePortlet == null) {
            layoutTypePortlet = (LayoutTypePortlet)this.getLayoutType();
        }
        return layoutTypePortlet;
    }

    private List<PortletPreferences> _getPortletPreferences(long groupId) {
        LayoutTypePortlet layoutTypePortlet;
        PortalPreferences portalPreferences;
        List portletPreferences = PortletPreferencesLocalServiceUtil.getPortletPreferences((long)groupId, (int)3, (long)0L);
        if (this.isTypePortlet() && (portalPreferences = (layoutTypePortlet = (LayoutTypePortlet)this.getLayoutType()).getPortalPreferences()) != null && layoutTypePortlet.isCustomizable()) {
            portletPreferences = ListUtil.copy((List)portletPreferences);
            portletPreferences.addAll(PortletPreferencesLocalServiceUtil.getPortletPreferences((long)portalPreferences.getUserId(), (int)4, (long)this.getPlid()));
        }
        return portletPreferences;
    }

    private String _getURL(HttpServletRequest request, boolean resetMaxState, boolean resetRenderParameters) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (resetMaxState) {
            Layout layout = themeDisplay.getLayout();
            LayoutTypePortlet layoutTypePortlet = null;
            if (layout.equals((Object)this)) {
                layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
            } else {
                try {
                    layoutTypePortlet = this._getLayoutTypePortletClone(request);
                }
                catch (IOException ioe) {
                    _log.error((Object)"Unable to clone layout settings", (Throwable)ioe);
                    layoutTypePortlet = (LayoutTypePortlet)this.getLayoutType();
                }
            }
            if (layoutTypePortlet.hasStateMax()) {
                String portletId = StringUtil.split((String)layoutTypePortlet.getStateMax())[0];
                LiferayPortletURL portletURL = PortletURLFactoryUtil.create((HttpServletRequest)request, (String)portletId, (Layout)this, (String)"ACTION_PHASE");
                try {
                    portletURL.setWindowState(WindowState.NORMAL);
                    portletURL.setPortletMode(PortletMode.VIEW);
                }
                catch (PortletException pe) {
                    throw new SystemException((Throwable)pe);
                }
                portletURL.setAnchor(false);
                if (PropsValues.LAYOUT_DEFAULT_P_L_RESET && !resetRenderParameters) {
                    portletURL.setParameter("p_l_reset", "0");
                } else if (!PropsValues.LAYOUT_DEFAULT_P_L_RESET && resetRenderParameters) {
                    portletURL.setParameter("p_l_reset", "1");
                }
                return portletURL.toString();
            }
        }
        String portalURL = PortalUtil.getPortalURL((HttpServletRequest)request);
        String url = PortalUtil.getLayoutURL((Layout)this, (ThemeDisplay)themeDisplay);
        if (!CookieKeys.hasSessionId((HttpServletRequest)request) && (url.startsWith(portalURL) || url.startsWith("/"))) {
            HttpSession session = request.getSession();
            url = PortalUtil.getURLWithSessionId((String)url, (String)session.getId());
        }
        if (!resetMaxState) {
            return url;
        }
        if (PropsValues.LAYOUT_DEFAULT_P_L_RESET && !resetRenderParameters) {
            url = HttpUtil.addParameter((String)url, (String)"p_l_reset", (int)0);
        } else if (!PropsValues.LAYOUT_DEFAULT_P_L_RESET && resetRenderParameters) {
            url = HttpUtil.addParameter((String)url, (String)"p_l_reset", (int)1);
        }
        return url;
    }

    static {
        LayoutImpl._initFriendlyURLKeywords();
    }
}

