/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.portal.dao.orm.hibernate.CacheModeTranslator;
import com.liferay.portal.dao.orm.hibernate.ExceptionTranslator;
import com.liferay.portal.dao.orm.hibernate.LockModeTranslator;
import com.liferay.portal.dao.orm.hibernate.ScrollableResultsImpl;
import com.liferay.portal.kernel.dao.orm.CacheMode;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.ScrollableResults;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.security.pacl.NotPrivileged;
import com.liferay.portal.kernel.util.ClassLoaderUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;

@DoPrivileged
public class QueryImpl
implements Query {
    private final String[] _names;
    private final org.hibernate.Query _query;
    private final boolean _strictName;

    public QueryImpl(org.hibernate.Query query, boolean strictName) {
        this._query = query;
        this._strictName = strictName;
        Object[] names = null;
        if (!this._strictName) {
            names = query.getNamedParameters();
            Arrays.sort(names);
        }
        this._names = names;
    }

    @NotPrivileged
    public int executeUpdate() throws ORMException {
        try {
            return this._query.executeUpdate();
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    @NotPrivileged
    public Iterator<?> iterate() throws ORMException {
        return this.iterate(true);
    }

    @NotPrivileged
    public Iterator<?> iterate(boolean unmodifiable) throws ORMException {
        try {
            return this.list(unmodifiable).iterator();
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    @NotPrivileged
    public Object iterateNext() throws ORMException {
        Iterator<?> iterator = this.iterate(false);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @NotPrivileged
    public List<?> list() throws ORMException {
        return this.list(false, false);
    }

    @NotPrivileged
    public List<?> list(boolean unmodifiable) throws ORMException {
        return this.list(true, unmodifiable);
    }

    @NotPrivileged
    public List<?> list(boolean copy, boolean unmodifiable) throws ORMException {
        ClassLoader contextClassLoader = ClassLoaderUtil.getContextClassLoader();
        ClassLoaderUtil.setContextClassLoader(null);
        try {
            List list = this._query.list();
            if (unmodifiable) {
                list = Collections.unmodifiableList(list);
            } else if (copy) {
                list = ListUtil.copy(list);
            }
            List list2 = list;
            return list2;
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
        finally {
            ClassLoaderUtil.setContextClassLoader((ClassLoader)contextClassLoader);
        }
    }

    @NotPrivileged
    public ScrollableResults scroll() throws ORMException {
        ClassLoader contextClassLoader = ClassLoaderUtil.getContextClassLoader();
        ClassLoaderUtil.setContextClassLoader(null);
        try {
            ScrollableResultsImpl scrollableResultsImpl = new ScrollableResultsImpl(this._query.scroll());
            return scrollableResultsImpl;
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
        finally {
            ClassLoaderUtil.setContextClassLoader((ClassLoader)contextClassLoader);
        }
    }

    public Query setBoolean(int pos, boolean value) {
        this._query.setBoolean(pos, value);
        return this;
    }

    public Query setBoolean(String name, boolean value) {
        if (!this._strictName && Arrays.binarySearch(this._names, name) < 0) {
            return this;
        }
        this._query.setBoolean(name, value);
        return this;
    }

    public Query setCacheable(boolean cacheable) {
        this._query.setCacheable(cacheable);
        return this;
    }

    public Query setCacheMode(CacheMode cacheMode) {
        this._query.setCacheMode(CacheModeTranslator.translate(cacheMode));
        return this;
    }

    public Query setCacheRegion(String cacheRegion) {
        this._query.setCacheRegion(cacheRegion);
        return this;
    }

    public Query setDouble(int pos, double value) {
        this._query.setDouble(pos, value);
        return this;
    }

    public Query setDouble(String name, double value) {
        if (!this._strictName && Arrays.binarySearch(this._names, name) < 0) {
            return this;
        }
        this._query.setDouble(name, value);
        return this;
    }

    public Query setFirstResult(int firstResult) {
        this._query.setFirstResult(firstResult);
        return this;
    }

    public Query setFloat(int pos, float value) {
        this._query.setFloat(pos, value);
        return this;
    }

    public Query setFloat(String name, float value) {
        if (!this._strictName && Arrays.binarySearch(this._names, name) < 0) {
            return this;
        }
        this._query.setFloat(name, value);
        return this;
    }

    public Query setInteger(int pos, int value) {
        this._query.setInteger(pos, value);
        return this;
    }

    public Query setInteger(String name, int value) {
        if (!this._strictName && Arrays.binarySearch(this._names, name) < 0) {
            return this;
        }
        this._query.setInteger(name, value);
        return this;
    }

    public Query setLockMode(String alias, com.liferay.portal.kernel.dao.orm.LockMode lockMode) {
        LockMode hibernateLockMode = LockModeTranslator.translate(lockMode);
        LockOptions lockOptions = new LockOptions(hibernateLockMode);
        lockOptions.setAliasSpecificLockMode(alias, hibernateLockMode);
        this._query.setLockOptions(lockOptions);
        return this;
    }

    public Query setLong(int pos, long value) {
        this._query.setLong(pos, value);
        return this;
    }

    public Query setLong(String name, long value) {
        if (!this._strictName && Arrays.binarySearch(this._names, name) < 0) {
            return this;
        }
        this._query.setLong(name, value);
        return this;
    }

    public Query setMaxResults(int maxResults) {
        this._query.setMaxResults(maxResults);
        return this;
    }

    public Query setSerializable(int pos, Serializable value) {
        this._query.setSerializable(pos, value);
        return this;
    }

    public Query setSerializable(String name, Serializable value) {
        if (!this._strictName && Arrays.binarySearch(this._names, name) < 0) {
            return this;
        }
        this._query.setSerializable(name, value);
        return this;
    }

    public Query setShort(int pos, short value) {
        this._query.setShort(pos, value);
        return this;
    }

    public Query setShort(String name, short value) {
        if (!this._strictName && Arrays.binarySearch(this._names, name) < 0) {
            return this;
        }
        this._query.setShort(name, value);
        return this;
    }

    public Query setString(int pos, String value) {
        this._query.setString(pos, value);
        return this;
    }

    public Query setString(String name, String value) {
        if (!this._strictName && Arrays.binarySearch(this._names, name) < 0) {
            return this;
        }
        this._query.setString(name, value);
        return this;
    }

    public Query setTimestamp(int pos, Timestamp value) {
        this._query.setTimestamp(pos, (Date)value);
        return this;
    }

    public Query setTimestamp(String name, Timestamp value) {
        if (!this._strictName && Arrays.binarySearch(this._names, name) < 0) {
            return this;
        }
        this._query.setTimestamp(name, (Date)value);
        return this;
    }

    public String toString() {
        StringBundler sb = new StringBundler(7);
        sb.append("{names=");
        sb.append(Arrays.toString(this._names));
        sb.append(", _query=");
        sb.append(String.valueOf(this._query));
        sb.append(", _strictName=");
        sb.append(this._strictName);
        sb.append("}");
        return sb.toString();
    }

    @NotPrivileged
    public Object uniqueResult() throws ORMException {
        try {
            return this._query.uniqueResult();
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }
}

