/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration;

import com.germinus.easyconf.ComponentConfiguration;
import com.germinus.easyconf.ComponentProperties;
import com.germinus.easyconf.Filter;
import com.liferay.portal.configuration.easyconf.ClassLoaderAggregateProperties;
import com.liferay.portal.configuration.easyconf.ClassLoaderComponentConfiguration;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.MapConfiguration;

public class ConfigurationImpl
implements Configuration {
    private static final String _ARRAY_KEY_PREFIX = "ARRAY_";
    private static final boolean _PRINT_DUPLICATE_CALLS_TO_GET = false;
    private static final Log _log = LogFactoryUtil.getLog(ConfigurationImpl.class);
    private static final String[] _emptyArray = new String[0];
    private static final Object _nullValue = new Object();
    private final ComponentConfiguration _componentConfiguration;
    private final Set<String> _printedSources = new HashSet<String>();
    private Properties _properties;
    private final Map<String, Object> _values = new ConcurrentHashMap<String, Object>();

    @Deprecated
    public ConfigurationImpl(ClassLoader classLoader, String name) {
        this(classLoader, name, 0L);
    }

    @Deprecated
    public ConfigurationImpl(ClassLoader classLoader, String name, long companyId) {
        String webId = null;
        if (companyId > 0L) {
            try {
                Company company = CompanyLocalServiceUtil.getCompanyById((long)companyId);
                webId = company.getWebId();
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        this._componentConfiguration = new ClassLoaderComponentConfiguration(classLoader, webId, name);
        this.printSources(companyId, webId);
    }

    public ConfigurationImpl(ClassLoader classLoader, String name, long companyId, String webId) {
        this._componentConfiguration = new ClassLoaderComponentConfiguration(classLoader, webId, name);
        this.printSources(companyId, webId);
    }

    public void addProperties(Properties properties) {
        try {
            ComponentProperties componentProperties = this.getComponentProperties();
            ClassLoaderAggregateProperties classLoaderAggregateProperties = (ClassLoaderAggregateProperties)componentProperties.toConfiguration();
            Field field1 = CompositeConfiguration.class.getDeclaredField("configList");
            field1.setAccessible(true);
            List configurations = (List)field1.get((Object)classLoaderAggregateProperties);
            MapConfiguration newConfiguration = new MapConfiguration(ConfigurationImpl._castPropertiesToMap(properties));
            newConfiguration.setTrimmingDisabled(true);
            configurations.add(0, newConfiguration);
            CompositeConfiguration compositeConfiguration = classLoaderAggregateProperties.getBaseConfiguration();
            configurations = (List)field1.get(compositeConfiguration);
            configurations.add(0, newConfiguration);
            this._properties = null;
            this.clearCache();
        }
        catch (Exception e) {
            _log.error((Object)"The properties could not be added", (Throwable)e);
        }
    }

    public void clearCache() {
        this._values.clear();
        this._properties = null;
    }

    public boolean contains(String key) {
        Object value = this._values.get(key);
        if (value == null) {
            ComponentProperties componentProperties = this.getComponentProperties();
            value = componentProperties.getProperty(key);
            if (value == null) {
                value = _nullValue;
            }
            this._values.put(key, value);
        }
        return value != _nullValue;
    }

    public String get(String key) {
        Object value = this._values.get(key);
        if (value == null) {
            ComponentProperties componentProperties = this.getComponentProperties();
            value = componentProperties.getString(key);
            if (value == null) {
                value = _nullValue;
            }
            this._values.put(key, value);
        }
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public String get(String key, com.liferay.portal.kernel.configuration.Filter filter) {
        String filterCacheKey = this.buildFilterCacheKey(key, filter, false);
        Object value = null;
        if (filterCacheKey != null) {
            value = this._values.get(filterCacheKey);
        }
        if (value == null) {
            ComponentProperties componentProperties = this.getComponentProperties();
            value = componentProperties.getString(key, this.getEasyConfFilter(filter));
            if (filterCacheKey != null) {
                if (value == null) {
                    value = _nullValue;
                }
                this._values.put(filterCacheKey, value);
            }
        }
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public String[] getArray(String key) {
        String cacheKey = _ARRAY_KEY_PREFIX.concat(key);
        Object value = this._values.get(cacheKey);
        if (value == null) {
            ComponentProperties componentProperties = this.getComponentProperties();
            String[] array = componentProperties.getStringArray(key);
            value = this.fixArrayValue(cacheKey, array);
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        return _emptyArray;
    }

    public String[] getArray(String key, com.liferay.portal.kernel.configuration.Filter filter) {
        String filterCacheKey = this.buildFilterCacheKey(key, filter, true);
        Object value = null;
        if (filterCacheKey != null) {
            value = this._values.get(filterCacheKey);
        }
        if (value == null) {
            ComponentProperties componentProperties = this.getComponentProperties();
            String[] array = componentProperties.getStringArray(key, this.getEasyConfFilter(filter));
            value = this.fixArrayValue(filterCacheKey, array);
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        return _emptyArray;
    }

    public Properties getProperties() {
        if (this._properties != null) {
            return this._properties;
        }
        Properties properties = new Properties();
        ComponentProperties componentProperties = this.getComponentProperties();
        Properties componentPropertiesProperties = componentProperties.getProperties();
        for (String key : componentPropertiesProperties.stringPropertyNames()) {
            properties.setProperty(key, componentProperties.getString(key));
        }
        this._properties = properties;
        return properties;
    }

    public Properties getProperties(String prefix, boolean removePrefix) {
        Properties properties = this.getProperties();
        return PropertiesUtil.getProperties((Properties)properties, (String)prefix, (boolean)removePrefix);
    }

    public void removeProperties(Properties properties) {
        try {
            org.apache.commons.configuration.Configuration configuration;
            ComponentProperties componentProperties = this.getComponentProperties();
            ClassLoaderAggregateProperties classLoaderAggregateProperties = (ClassLoaderAggregateProperties)componentProperties.toConfiguration();
            CompositeConfiguration compositeConfiguration = classLoaderAggregateProperties.getBaseConfiguration();
            Field field2 = CompositeConfiguration.class.getDeclaredField("configList");
            field2.setAccessible(true);
            List configurations = (List)field2.get(compositeConfiguration);
            Iterator itr = configurations.iterator();
            while (itr.hasNext() && (configuration = (org.apache.commons.configuration.Configuration)itr.next()) instanceof MapConfiguration) {
                MapConfiguration mapConfiguration = (MapConfiguration)configuration;
                if (mapConfiguration.getMap() != properties) continue;
                itr.remove();
                classLoaderAggregateProperties.removeConfiguration(configuration);
            }
            this._properties = null;
            this.clearCache();
        }
        catch (Exception e) {
            _log.error((Object)"The properties could not be removed", (Throwable)e);
        }
    }

    public void set(String key, String value) {
        ComponentProperties componentProperties = this.getComponentProperties();
        componentProperties.setProperty(key, (Object)value);
        this.clearCache();
    }

    protected String buildFilterCacheKey(String key, com.liferay.portal.kernel.configuration.Filter filter, boolean arrayValue) {
        if (filter.getVariables() != null) {
            return null;
        }
        String[] selectors = filter.getSelectors();
        int length = 0;
        length = arrayValue ? selectors.length + 2 : selectors.length + 1;
        StringBundler sb = new StringBundler(length);
        if (arrayValue) {
            sb.append(_ARRAY_KEY_PREFIX);
        }
        sb.append(key);
        sb.append(selectors);
        return sb.toString();
    }

    protected Object fixArrayValue(String cacheKey, String[] array) {
        if (cacheKey == null) {
            return array;
        }
        String[] value = _nullValue;
        if (ArrayUtil.isNotEmpty((Object[])array)) {
            if (Validator.isNull((String)array[array.length - 1])) {
                String[] subarray = new String[array.length - 1];
                System.arraycopy(array, 0, subarray, 0, subarray.length);
                array = subarray;
            }
            if (array.length > 0) {
                value = array;
            }
        }
        this._values.put(cacheKey, value);
        return value;
    }

    protected ComponentProperties getComponentProperties() {
        return this._componentConfiguration.getProperties();
    }

    protected Filter getEasyConfFilter(com.liferay.portal.kernel.configuration.Filter filter) {
        Filter easyConfFilter = Filter.by((String[])filter.getSelectors());
        if (filter.getVariables() != null) {
            easyConfFilter.setVariables(filter.getVariables());
        }
        return easyConfFilter;
    }

    protected void printSources(long companyId, String webId) {
        ComponentProperties componentProperties = this.getComponentProperties();
        List sources = componentProperties.getLoadedSources();
        for (int i = sources.size() - 1; i >= 0; --i) {
            String source = (String)sources.get(i);
            if (this._printedSources.contains(source)) continue;
            this._printedSources.add(source);
            if (source.startsWith("bundleresource://")) continue;
            String info = "Loading " + source;
            if (companyId > 0L) {
                info = info + " for {companyId=" + companyId + ", webId=" + webId + "}";
            }
            System.out.println(info);
        }
    }

    private static Map<String, Object> _castPropertiesToMap(Properties properties) {
        return properties;
    }
}

