/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Locale;

public class GetterUtil {
    public static final String[] BOOLEANS = new String[]{"true", "t", "y", "on", "1"};
    public static final boolean DEFAULT_BOOLEAN = false;
    public static final boolean[] DEFAULT_BOOLEAN_VALUES = new boolean[0];
    public static final byte DEFAULT_BYTE = 0;
    public static final byte[] DEFAULT_BYTE_VALUES = new byte[0];
    public static final Date[] DEFAULT_DATE_VALUES = new Date[0];
    public static final double DEFAULT_DOUBLE = 0.0;
    public static final double[] DEFAULT_DOUBLE_VALUES = new double[0];
    public static final float DEFAULT_FLOAT = 0.0f;
    public static final float[] DEFAULT_FLOAT_VALUES = new float[0];
    public static final int DEFAULT_INTEGER = 0;
    public static final int[] DEFAULT_INTEGER_VALUES = new int[0];
    public static final long DEFAULT_LONG = 0L;
    public static final long[] DEFAULT_LONG_VALUES = new long[0];
    public static final Number DEFAULT_NUMBER = 0;
    public static final Number[] DEFAULT_NUMBER_VALUES = new Number[0];
    public static final Number DEFAULT_OBJECT = null;
    public static final short DEFAULT_SHORT = 0;
    public static final short[] DEFAULT_SHORT_VALUES = new short[0];
    public static final String DEFAULT_STRING = "";
    public static final String[] DEFAULT_STRING_VALUES = new String[0];

    public static boolean get(Object value, boolean defaultValue) {
        if (value instanceof String) {
            return GetterUtil.get((String)value, defaultValue);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    public static Date get(Object value, DateFormat dateFormat, Date defaultValue) {
        if (value instanceof String) {
            return GetterUtil.get((String)value, dateFormat, defaultValue);
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        return defaultValue;
    }

    public static double get(Object value, double defaultValue) {
        if (value instanceof String) {
            return GetterUtil.get((String)value, defaultValue);
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        return defaultValue;
    }

    public static float get(Object value, float defaultValue) {
        if (value instanceof String) {
            return GetterUtil.get((String)value, defaultValue);
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.floatValue();
        }
        return defaultValue;
    }

    public static int get(Object value, int defaultValue) {
        if (value instanceof String) {
            return GetterUtil.get((String)value, defaultValue);
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.intValue();
        }
        return defaultValue;
    }

    public static long get(Object value, long defaultValue) {
        if (value instanceof String) {
            return GetterUtil.get((String)value, defaultValue);
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.longValue();
        }
        return defaultValue;
    }

    public static Number get(Object value, Number defaultValue) {
        if (value instanceof String) {
            String valueString = (String)value;
            if (Validator.isNull(valueString)) {
                return defaultValue;
            }
            try {
                return new BigDecimal(valueString.trim());
            }
            catch (NumberFormatException nfe) {
                return defaultValue;
            }
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        return defaultValue;
    }

    public static short get(Object value, short defaultValue) {
        if (value instanceof String) {
            return GetterUtil.get((String)value, defaultValue);
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.shortValue();
        }
        return defaultValue;
    }

    public static String get(Object value, String defaultValue) {
        if (value instanceof String) {
            return GetterUtil.get((String)value, defaultValue);
        }
        return defaultValue;
    }

    public static boolean get(String value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        value = value.trim();
        return (value = GetterUtil._toLowerCase(value)).equals(BOOLEANS[0]) || value.equals(BOOLEANS[1]) || value.equals(BOOLEANS[2]) || value.equals(BOOLEANS[3]) || value.equals(BOOLEANS[4]);
    }

    public static Date get(String value, DateFormat dateFormat, Date defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            Date date = dateFormat.parse(value.trim());
            if (date != null) {
                return date;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public static double get(String value, double defaultValue) {
        return GetterUtil.get(value, defaultValue, null);
    }

    public static double get(String value, double defaultValue, Locale locale) {
        block7: {
            if (value == null) {
                return defaultValue;
            }
            value = value.trim();
            if (locale == null) {
                try {
                    return Double.parseDouble(value);
                }
                catch (Exception exception) {
                    break block7;
                }
            }
            NumberFormat numberFormat = NumberFormat.getInstance(locale);
            try {
                ParsePosition parsePosition = new ParsePosition(0);
                Number number = numberFormat.parse(value, parsePosition);
                if (parsePosition.getIndex() == value.length()) {
                    return number.doubleValue();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static float get(String value, float defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value.trim());
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static int get(String value, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return GetterUtil._parseInt(value.trim(), defaultValue);
    }

    public static long get(String value, long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return GetterUtil._parseLong(value.trim(), defaultValue);
    }

    public static short get(String value, short defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return GetterUtil._parseShort(value.trim(), defaultValue);
    }

    public static String get(String value, String defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if ((value = value.trim()).indexOf(13) != -1) {
            value = value.replaceAll("\r\n", "\n");
        }
        return value;
    }

    public static boolean getBoolean(Object value) {
        return GetterUtil.getBoolean(value, false);
    }

    public static boolean getBoolean(Object value, boolean defaultValue) {
        return GetterUtil.get(value, defaultValue);
    }

    public static boolean getBoolean(String value) {
        return GetterUtil.getBoolean(value, false);
    }

    public static boolean getBoolean(String value, boolean defaultValue) {
        return GetterUtil.get(value, defaultValue);
    }

    public static boolean[] getBooleanValues(Object value) {
        return GetterUtil.getBooleanValues(value, DEFAULT_BOOLEAN_VALUES);
    }

    public static boolean[] getBooleanValues(Object value, boolean[] defaultValue) {
        if (value instanceof String[]) {
            return GetterUtil.getBooleanValues((String[])value, defaultValue);
        }
        if (value instanceof boolean[]) {
            return (boolean[])value;
        }
        return defaultValue;
    }

    public static boolean[] getBooleanValues(String[] values) {
        return GetterUtil.getBooleanValues(values, DEFAULT_BOOLEAN_VALUES);
    }

    public static boolean[] getBooleanValues(String[] values, boolean[] defaultValue) {
        if (values == null) {
            return defaultValue;
        }
        boolean[] booleanValues = new boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            booleanValues[i] = GetterUtil.getBoolean(values[i]);
        }
        return booleanValues;
    }

    public static Date getDate(Object value, DateFormat dateFormat) {
        return GetterUtil.getDate(value, dateFormat, new Date());
    }

    public static Date getDate(Object value, DateFormat dateFormat, Date defaultValue) {
        return GetterUtil.get(value, dateFormat, defaultValue);
    }

    public static Date getDate(String value, DateFormat dateFormat) {
        return GetterUtil.getDate(value, dateFormat, new Date());
    }

    public static Date getDate(String value, DateFormat dateFormat, Date defaultValue) {
        return GetterUtil.get(value, dateFormat, defaultValue);
    }

    public static Date[] getDateValues(Object value, DateFormat dateFormat) {
        return GetterUtil.getDateValues(value, dateFormat, DEFAULT_DATE_VALUES);
    }

    public static Date[] getDateValues(Object value, DateFormat dateFormat, Date[] defaultValue) {
        if (value instanceof String[]) {
            return GetterUtil.getDateValues((String[])value, dateFormat, defaultValue);
        }
        if (value instanceof Date[]) {
            return (Date[])value;
        }
        return defaultValue;
    }

    public static Date[] getDateValues(String[] values, DateFormat dateFormat) {
        return GetterUtil.getDateValues(values, dateFormat, DEFAULT_DATE_VALUES);
    }

    public static Date[] getDateValues(String[] values, DateFormat dateFormat, Date[] defaultValue) {
        if (values == null) {
            return defaultValue;
        }
        Date[] dateValues = new Date[values.length];
        for (int i = 0; i < values.length; ++i) {
            dateValues[i] = GetterUtil.getDate(values[i], dateFormat);
        }
        return dateValues;
    }

    public static double getDouble(Object value) {
        return GetterUtil.getDouble(value, 0.0);
    }

    public static double getDouble(Object value, double defaultValue) {
        return GetterUtil.get(value, defaultValue);
    }

    public static double getDouble(String value) {
        return GetterUtil.getDouble(value, 0.0);
    }

    public static double getDouble(String value, double defaultValue) {
        return GetterUtil.get(value, defaultValue);
    }

    public static double getDouble(String value, Locale locale) {
        return GetterUtil.get(value, 0.0, locale);
    }

    public static double[] getDoubleValues(Object value) {
        return GetterUtil.getDoubleValues(value, DEFAULT_DOUBLE_VALUES);
    }

    public static double[] getDoubleValues(Object value, double[] defaultValue) {
        if (value instanceof String[]) {
            return GetterUtil.getDoubleValues((String[])value, defaultValue);
        }
        if (value instanceof double[]) {
            return (double[])value;
        }
        return defaultValue;
    }

    public static double[] getDoubleValues(String[] values) {
        return GetterUtil.getDoubleValues(values, DEFAULT_DOUBLE_VALUES);
    }

    public static double[] getDoubleValues(String[] values, double[] defaultValue) {
        if (values == null) {
            return defaultValue;
        }
        double[] doubleValues = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            doubleValues[i] = GetterUtil.getDouble(values[i]);
        }
        return doubleValues;
    }

    public static float getFloat(Object value) {
        return GetterUtil.getFloat(value, 0.0f);
    }

    public static float getFloat(Object value, float defaultValue) {
        return GetterUtil.get(value, defaultValue);
    }

    public static float getFloat(String value) {
        return GetterUtil.getFloat(value, 0.0f);
    }

    public static float getFloat(String value, float defaultValue) {
        return GetterUtil.get(value, defaultValue);
    }

    public static float[] getFloatValues(Object value) {
        return GetterUtil.getFloatValues(value, DEFAULT_FLOAT_VALUES);
    }

    public static float[] getFloatValues(Object value, float[] defaultValue) {
        if (value instanceof String[]) {
            return GetterUtil.getFloatValues((String[])value, defaultValue);
        }
        if (value instanceof float[]) {
            return (float[])value;
        }
        return defaultValue;
    }

    public static float[] getFloatValues(String[] values) {
        return GetterUtil.getFloatValues(values, DEFAULT_FLOAT_VALUES);
    }

    public static float[] getFloatValues(String[] values, float[] defaultValue) {
        if (values == null) {
            return defaultValue;
        }
        float[] floatValues = new float[values.length];
        for (int i = 0; i < values.length; ++i) {
            floatValues[i] = GetterUtil.getFloat(values[i]);
        }
        return floatValues;
    }

    public static int getInteger(Object value) {
        return GetterUtil.getInteger(value, 0);
    }

    public static int getInteger(Object value, int defaultValue) {
        return GetterUtil.get(value, defaultValue);
    }

    public static int getInteger(String value) {
        return GetterUtil.getInteger(value, 0);
    }

    public static int getInteger(String value, int defaultValue) {
        return GetterUtil.get(value, defaultValue);
    }

    public static int getIntegerStrict(String value) {
        int length = value.length();
        if (length <= 0) {
            throw new NumberFormatException("Unable to parse " + value);
        }
        int index = 0;
        int limit = -2147483647;
        boolean negative = false;
        char c = value.charAt(0);
        if (c < '0') {
            if (c == '-') {
                limit = Integer.MIN_VALUE;
                negative = true;
            } else if (c != '+') {
                throw new NumberFormatException("Unable to parse " + value);
            }
            if (length == 1) {
                throw new NumberFormatException("Unable to parse " + value);
            }
            ++index;
        }
        int smallLimit = limit / 10;
        int result = 0;
        while (index < length) {
            if (result < smallLimit) {
                throw new NumberFormatException("Unable to parse " + value);
            }
            if ((c = value.charAt(index++)) < '0' || c > '9') {
                throw new NumberFormatException("Unable to parse " + value);
            }
            int number = c - 48;
            if ((result *= 10) < limit + number) {
                throw new NumberFormatException("Unable to parse " + value);
            }
            result -= number;
        }
        if (negative) {
            return result;
        }
        return -result;
    }

    public static int[] getIntegerValues(Object value) {
        return GetterUtil.getIntegerValues(value, DEFAULT_INTEGER_VALUES);
    }

    public static int[] getIntegerValues(Object value, int[] defaultValue) {
        if (value instanceof String[]) {
            return GetterUtil.getIntegerValues((String[])value, defaultValue);
        }
        if (value instanceof int[]) {
            return (int[])value;
        }
        return defaultValue;
    }

    public static int[] getIntegerValues(String[] values) {
        return GetterUtil.getIntegerValues(values, DEFAULT_INTEGER_VALUES);
    }

    public static int[] getIntegerValues(String[] values, int[] defaultValue) {
        if (values == null) {
            return defaultValue;
        }
        int[] intValues = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            intValues[i] = GetterUtil.getInteger(values[i]);
        }
        return intValues;
    }

    public static long getLong(Object value) {
        return GetterUtil.getLong(value, 0L);
    }

    public static long getLong(Object value, long defaultValue) {
        return GetterUtil.get(value, defaultValue);
    }

    public static long getLong(String value) {
        return GetterUtil.getLong(value, 0L);
    }

    public static long getLong(String value, long defaultValue) {
        return GetterUtil.get(value, defaultValue);
    }

    public static long getLongStrict(String value) {
        int length = value.length();
        if (length <= 0) {
            throw new NumberFormatException("Unable to parse " + value);
        }
        int index = 0;
        long limit = -9223372036854775807L;
        boolean negative = false;
        char c = value.charAt(0);
        if (c < '0') {
            if (c == '-') {
                limit = Long.MIN_VALUE;
                negative = true;
            } else if (c != '+') {
                throw new NumberFormatException("Unable to parse " + value);
            }
            if (length == 1) {
                throw new NumberFormatException("Unable to parse " + value);
            }
            ++index;
        }
        long smallLimit = limit / 10L;
        long result = 0L;
        while (index < length) {
            if (result < smallLimit) {
                throw new NumberFormatException("Unable to parse " + value);
            }
            if ((c = value.charAt(index++)) < '0' || c > '9') {
                throw new NumberFormatException("Unable to parse " + value);
            }
            int number = c - 48;
            if ((result *= 10L) < limit + (long)number) {
                throw new NumberFormatException("Unable to parse " + value);
            }
            result -= (long)number;
        }
        if (negative) {
            return result;
        }
        return -result;
    }

    public static long[] getLongValues(Object value) {
        return GetterUtil.getLongValues(value, DEFAULT_LONG_VALUES);
    }

    public static long[] getLongValues(Object value, long[] defaultValue) {
        if (value instanceof String[]) {
            return GetterUtil.getLongValues((String[])value, defaultValue);
        }
        if (value instanceof long[]) {
            return (long[])value;
        }
        if (value instanceof Number[]) {
            Number[] numbers = (Number[])value;
            long[] values = new long[numbers.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = numbers[i].longValue();
            }
            return values;
        }
        return defaultValue;
    }

    public static long[] getLongValues(String[] values) {
        return GetterUtil.getLongValues(values, DEFAULT_LONG_VALUES);
    }

    public static long[] getLongValues(String[] values, long[] defaultValue) {
        if (values == null) {
            return defaultValue;
        }
        long[] longValues = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            longValues[i] = GetterUtil.getLong(values[i]);
        }
        return longValues;
    }

    public static Number getNumber(Object value) {
        return GetterUtil.getNumber(value, DEFAULT_NUMBER);
    }

    public static Number getNumber(Object value, Number defaultValue) {
        return GetterUtil.get(value, defaultValue);
    }

    public static Number getNumber(String value) {
        return GetterUtil.getNumber(value, DEFAULT_NUMBER);
    }

    public static Number getNumber(String value, Number defaultValue) {
        return GetterUtil.get((Object)value, defaultValue);
    }

    public static Number[] getNumberValues(Object value) {
        return GetterUtil.getNumberValues(value, DEFAULT_NUMBER_VALUES);
    }

    public static Number[] getNumberValues(Object value, Number[] defaultValue) {
        if (value instanceof String[]) {
            return GetterUtil.getNumberValues((String[])value, defaultValue);
        }
        if (value instanceof Number[]) {
            return (Number[])value;
        }
        return defaultValue;
    }

    public static Number[] getNumberValues(String[] values) {
        return GetterUtil.getNumberValues(values, DEFAULT_NUMBER_VALUES);
    }

    public static Number[] getNumberValues(String[] values, Number[] defaultValue) {
        if (values == null) {
            return defaultValue;
        }
        Number[] numberValues = new Number[values.length];
        for (int i = 0; i < values.length; ++i) {
            numberValues[i] = GetterUtil.getNumber(values[i]);
        }
        return numberValues;
    }

    public static Object getObject(Object value) {
        return GetterUtil.getObject(value, DEFAULT_OBJECT);
    }

    public static Object getObject(Object value, Object defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static short getShort(Object value) {
        return GetterUtil.getShort(value, (short)0);
    }

    public static short getShort(Object value, short defaultValue) {
        return GetterUtil.get(value, defaultValue);
    }

    public static short getShort(String value) {
        return GetterUtil.getShort(value, (short)0);
    }

    public static short getShort(String value, short defaultValue) {
        return GetterUtil.get(value, defaultValue);
    }

    public static short getShortStrict(String value) {
        int i = GetterUtil.getIntegerStrict(value);
        if (i < Short.MIN_VALUE || i > Short.MAX_VALUE) {
            throw new NumberFormatException("Out of range value " + value);
        }
        return (short)i;
    }

    public static short[] getShortValues(Object value) {
        return GetterUtil.getShortValues(value, DEFAULT_SHORT_VALUES);
    }

    public static short[] getShortValues(Object value, short[] defaultValue) {
        if (value instanceof String[]) {
            return GetterUtil.getShortValues((String[])value, defaultValue);
        }
        if (value instanceof short[]) {
            return (short[])value;
        }
        return defaultValue;
    }

    public static short[] getShortValues(String[] values) {
        return GetterUtil.getShortValues(values, DEFAULT_SHORT_VALUES);
    }

    public static short[] getShortValues(String[] values, short[] defaultValue) {
        if (values == null) {
            return defaultValue;
        }
        short[] shortValues = new short[values.length];
        for (int i = 0; i < values.length; ++i) {
            shortValues[i] = GetterUtil.getShort(values[i]);
        }
        return shortValues;
    }

    public static String getString(Object value) {
        return GetterUtil.getString(value, DEFAULT_STRING);
    }

    public static String getString(Object value, String defaultValue) {
        return GetterUtil.get(value, defaultValue);
    }

    public static String getString(String value) {
        return GetterUtil.getString(value, DEFAULT_STRING);
    }

    public static String getString(String value, String defaultValue) {
        return GetterUtil.get(value, defaultValue);
    }

    public static String[] getStringValues(Object value) {
        return GetterUtil.getStringValues(value, DEFAULT_STRING_VALUES);
    }

    public static String[] getStringValues(Object value, String[] defaultValue) {
        if (value instanceof String[]) {
            return GetterUtil.getStringValues((String[])value, defaultValue);
        }
        return defaultValue;
    }

    public static String[] getStringValues(Object[] values, String[] defaultValue) {
        if (values == null) {
            return defaultValue;
        }
        String[] stringValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            stringValues[i] = String.valueOf(values[i]);
        }
        return stringValues;
    }

    public static String[] getStringValues(String[] values) {
        return GetterUtil.getStringValues(values, DEFAULT_STRING_VALUES);
    }

    private static int _parseInt(String value, int defaultValue) {
        int length = value.length();
        if (length <= 0) {
            return defaultValue;
        }
        int pos = 0;
        int limit = -2147483647;
        boolean negative = false;
        char c = value.charAt(0);
        if (c < '0') {
            if (c == '-') {
                limit = Integer.MIN_VALUE;
                negative = true;
            } else if (c != '+') {
                return defaultValue;
            }
            if (length == 1) {
                return defaultValue;
            }
            ++pos;
        }
        int smallLimit = limit / 10;
        int result = 0;
        while (pos < length) {
            if (result < smallLimit) {
                return defaultValue;
            }
            if ((c = value.charAt(pos++)) < '0' || c > '9') {
                return defaultValue;
            }
            int number = c - 48;
            if ((result *= 10) < limit + number) {
                return defaultValue;
            }
            result -= number;
        }
        if (negative) {
            return result;
        }
        return -result;
    }

    private static long _parseLong(String value, long defaultValue) {
        int length = value.length();
        if (length <= 0) {
            return defaultValue;
        }
        int pos = 0;
        long limit = -9223372036854775807L;
        boolean negative = false;
        char c = value.charAt(0);
        if (c < '0') {
            if (c == '-') {
                limit = Long.MIN_VALUE;
                negative = true;
            } else if (c != '+') {
                return defaultValue;
            }
            if (length == 1) {
                return defaultValue;
            }
            ++pos;
        }
        long smallLimit = limit / 10L;
        long result = 0L;
        while (pos < length) {
            if (result < smallLimit) {
                return defaultValue;
            }
            if ((c = value.charAt(pos++)) < '0' || c > '9') {
                return defaultValue;
            }
            int number = c - 48;
            if ((result *= 10L) < limit + (long)number) {
                return defaultValue;
            }
            result -= (long)number;
        }
        if (negative) {
            return result;
        }
        return -result;
    }

    private static short _parseShort(String value, short defaultValue) {
        int i = GetterUtil._parseInt(value, defaultValue);
        if (i < Short.MIN_VALUE || i > Short.MAX_VALUE) {
            return defaultValue;
        }
        return (short)i;
    }

    private static String _toLowerCase(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = null;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\u007f') {
                return s.toLowerCase(LocaleUtil.getDefault());
            }
            if (c < 'A' || c > 'Z') continue;
            if (sb == null) {
                sb = new StringBuilder(s);
            }
            sb.setCharAt(i, (char)(c + 32));
        }
        if (sb == null) {
            return s;
        }
        return sb.toString();
    }
}

