/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.bundle.support.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.liferay.portal.tools.bundle.support.commands.BaseCommand;
import com.liferay.portal.tools.bundle.support.internal.util.BundleSupportUtil;
import com.liferay.portal.tools.bundle.support.internal.util.FileUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;

@Parameters(commandDescription="Deploy a file to a Liferay bundle.", commandNames={"deploy"})
public class DeployCommand
extends BaseCommand {
    @Parameter(description="The file to deploy to your Liferay bundle.", names={"-f", "--file"}, required=true)
    private File _file;
    @Parameter(description="The name of the output file.", names={"-o", "--output"})
    private String _outputFileName;

    @Override
    public void execute() throws Exception {
        Path path = this._file.toPath();
        if (Files.notExists(path, new LinkOption[0])) {
            throw new NoSuchFileException("Unable to find " + path);
        }
        String fileName = String.valueOf(path.getFileName());
        String deployDirName = BundleSupportUtil.getDeployDirName(fileName);
        if (this._outputFileName == null) {
            this._outputFileName = fileName;
        }
        File outputFile = new File(this.getLiferayHomeDir(), deployDirName + this._outputFileName);
        FileUtil.copyFile(path, outputFile.toPath());
    }

    public File getFile() {
        return this._file;
    }

    public String getOutputFileName() {
        return this._outputFileName;
    }

    public void setFile(File file) {
        this._file = file;
    }

    public void setOutputFileName(String outputFileName) {
        this._outputFileName = outputFileName;
    }
}

