/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.portal.tools.bundle.support.maven;

import com.liferay.portal.tools.bundle.support.commands.CreateTokenCommand;
import com.liferay.portal.tools.bundle.support.constants.BundleSupportConstants;

import java.io.File;

import java.net.URL;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

/**
 * @author David Truong
 * @author Andrea Di Giorgi
 */
@Mojo(name = "create-token")
public class CreateTokenMojo extends AbstractMojo {

	@Override
	public void execute() throws MojoExecutionException {
		try {
			CreateTokenCommand createTokenCommand = new CreateTokenCommand();

			createTokenCommand.setEmailAddress(emailAddress);
			createTokenCommand.setForce(force);
			createTokenCommand.setPassword(password);
			createTokenCommand.setPasswordFile(passwordFile);
			createTokenCommand.setTokenFile(tokenFile);
			createTokenCommand.setTokenUrl(tokenUrl);

			createTokenCommand.execute();
		}
		catch (Exception e) {
			throw new MojoExecutionException(
				"Unable to create liferay.com download token", e);
		}
	}

	@Parameter
	protected String emailAddress;

	@Parameter
	protected boolean force;

	@Parameter
	protected String password;

	@Parameter
	protected File passwordFile;

	@Parameter(
		defaultValue = "${user.home}/" + BundleSupportConstants.DEFAULT_TOKEN_FILE_NAME
	)
	protected File tokenFile;

	@Parameter(defaultValue = BundleSupportConstants.DEFAULT_BUNDLE_URL)
	protected URL tokenUrl;

}