/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.portal.tools.bundle.support.maven;

import com.liferay.portal.tools.bundle.support.constants.BundleSupportConstants;
import com.liferay.portal.tools.bundle.support.internal.util.MavenUtil;

import java.io.File;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

/**
 * @author David Truong
 */
public abstract class AbstractLiferayMojo extends AbstractMojo {

	protected String getLiferayHome() {
		return _liferayHome;
	}

	protected File getLiferayHomeDir() {
		if (_liferayHomeDir != null) {
			return _liferayHomeDir;
		}

		if (_liferayHome.startsWith("/") || _liferayHome.contains(":")) {
			_liferayHomeDir = new File(_liferayHome);
		}
		else {
			_liferayHomeDir = new File(
				MavenUtil.getRootProjectBaseDir(project), _liferayHome);
		}

		return _liferayHomeDir;
	}

	protected void setLiferayHome(String liferayHome) {
		_liferayHome = liferayHome;
	}

	@Parameter(defaultValue = "${project}", readonly = true, required = true)
	protected MavenProject project;

	@Parameter(
		alias = "liferayHome",
		defaultValue = BundleSupportConstants.DEFAULT_LIFERAY_HOME_DIR_NAME,
		property = "liferayHome", required = true
	)
	private String _liferayHome;

	private File _liferayHomeDir;

}