/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.portal.tools.bundle.support.internal.util;

import java.io.File;

import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;

/**
 * @author David Truong
 * @author Andrea Di Giorgi
 */
public class MavenUtil {

	public static Proxy getProxy(MavenSession mavenSession) {
		Settings settings = mavenSession.getSettings();

		return settings.getActiveProxy();
	}

	public static MavenProject getRootProject(MavenProject mavenProject) {
		if (mavenProject.hasParent()) {
			return getRootProject(mavenProject.getParent());
		}

		return mavenProject;
	}

	public static File getRootProjectBaseDir(MavenProject mavenProject) {
		MavenProject rootProject = getRootProject(mavenProject);

		return rootProject.getBasedir();
	}

}