/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.portal.tools.bundle.support.internal.util;

import java.util.Properties;

/**
 * @author David Truong
 * @author Andrea Di Giorgi
 */
public class BundleSupportUtil {

	public static String getDeployDirName(String fileName) {
		if (fileName.endsWith(".jar")) {
			return "osgi/modules/";
		}

		if (fileName.endsWith(".war")) {
			return "osgi/war/";
		}

		return "deploy/";
	}

	public static Integer setSystemProperty(String key, Integer value) {
		String valueString = null;

		if (value != null) {
			valueString = value.toString();
		}

		valueString = setSystemProperty(key, valueString);

		if ((valueString == null) || valueString.isEmpty()) {
			return null;
		}

		return Integer.valueOf(valueString);
	}

	public static String setSystemProperty(String key, String value) {
		String oldValue = System.getProperty(key);

		if (value == null) {
			Properties properties = System.getProperties();

			properties.remove(key);
		}
		else {
			System.setProperty(key, value);
		}

		return oldValue;
	}

}