/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.portal.tools.bundle.support.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;

import com.liferay.portal.tools.bundle.support.internal.util.BundleSupportUtil;

import java.io.File;

import java.nio.file.Files;

/**
 * @author David Truong
 * @author Andrea Di Giorgi
 */
@Parameters(
	commandDescription = "Delete a file from the deploy directory of a Liferay bundle.",
	commandNames = "clean"
)
public class CleanCommand extends BaseCommand {

	@Override
	public void execute() throws Exception {
		String fileName;

		if (File.separatorChar != '/') {
			fileName = _fileName.replace(File.separatorChar, '/');
		}

		fileName = _fileName.substring(_fileName.lastIndexOf('/') + 1);

		String dirName = BundleSupportUtil.getDeployDirName(fileName);

		File file = new File(getLiferayHomeDir(), dirName + fileName);

		Files.deleteIfExists(file.toPath());
	}

	public String getFileName() {
		return _fileName;
	}

	public void setFileName(String fileName) {
		_fileName = fileName;
	}

	@Parameter(
		description = "The name of the file to delete from your bundle.",
		names = {"-f", "--file"}, required = true
	)
	private String _fileName;

}