/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.portal.tools.bundle.support.commands;

import com.beust.jcommander.Parameter;

import java.io.File;

/**
 * @author David Truong
 */
public abstract class BaseCommand implements Command {

	public File getLiferayHomeDir() {
		return _liferayHomeDir;
	}

	public void setLiferayHomeDir(File liferayHomeDir) {
		_liferayHomeDir = liferayHomeDir;
	}

	@Parameter(
		description = "The home directory of your Liferay bundle.",
		names = {"-l", "--liferay"}, required = true
	)
	private File _liferayHomeDir;

}