/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.portal.tools.bundle.support.ant;

import com.liferay.portal.tools.bundle.support.commands.InitBundleCommand;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

/**
 * @author David Truong
 */
public class InitBundleTask extends InitBundleCommand {

	@Override
	public void execute() {
		try {
			super.execute();
		}
		catch (Exception e) {
			throw new BuildException(e);
		}
	}

	public void setProject(Project project) {
		_project = project;
	}

	@Override
	protected void onProgress(String message) {
		_project.log(message);
	}

	@Override
	protected void onStarted(String message) {
		_project.log(message);
	}

	private Project _project;

}