/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.velocity.internal;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.cache.SingleVMPool;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateManager;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceLoader;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.template.BaseSingleTemplateManager;
import com.liferay.portal.template.RestrictedTemplate;
import com.liferay.portal.template.TemplateContextHelper;
import com.liferay.portal.template.velocity.configuration.VelocityEngineConfiguration;
import com.liferay.portal.template.velocity.internal.FastExtendedProperties;
import com.liferay.portal.template.velocity.internal.LiferayMethodExceptionEventHandler;
import com.liferay.portal.template.velocity.internal.LiferayResourceLoader;
import com.liferay.portal.template.velocity.internal.LiferayResourceManager;
import com.liferay.portal.template.velocity.internal.VelocityParserPool;
import com.liferay.portal.template.velocity.internal.VelocityTemplate;
import com.liferay.portal.template.velocity.internal.VelocityTemplateContextHelper;
import com.liferay.portal.template.velocity.internal.VelocityTemplateResourceLoader;
import com.liferay.taglib.util.VelocityTaglib;
import com.liferay.taglib.util.VelocityTaglibImpl;
import java.lang.reflect.Method;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.util.introspection.SecureUberspector;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.template.velocity.configuration.VelocityEngineConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, property={"language.type=vm"}, service={TemplateManager.class})
public class VelocityManager
extends BaseSingleTemplateManager {
    private static volatile VelocityEngineConfiguration _velocityEngineConfiguration;
    private VelocityEngine _velocityEngine;

    public void addTaglibTheme(Map<String, Object> contextObjects, String themeName, HttpServletRequest request, HttpServletResponse response) {
        VelocityTaglibImpl velocityTaglib = new VelocityTaglibImpl(request.getServletContext(), request, response, contextObjects);
        contextObjects.put(themeName, velocityTaglib);
        try {
            Class<VelocityTaglib> clazz = VelocityTaglib.class;
            Method method = clazz.getMethod("layoutIcon", Layout.class);
            contextObjects.put("velocityTaglib_layoutIcon", method);
        }
        catch (Exception e) {
            ReflectionUtil.throwException((Throwable)e);
        }
        contextObjects.put("theme", velocityTaglib);
    }

    public void destroy() {
        if (this._velocityEngine == null) {
            return;
        }
        this._velocityEngine = null;
        this.templateContextHelper.removeAllHelperUtilities();
        this.templateContextHelper = null;
    }

    public void destroy(ClassLoader classLoader) {
        this.templateContextHelper.removeHelperUtilities(classLoader);
    }

    public String getName() {
        return "vm";
    }

    public String[] getRestrictedVariables() {
        return _velocityEngineConfiguration.restrictedVariables();
    }

    public void init() throws TemplateException {
        if (this._velocityEngine != null) {
            return;
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        Class<?> clazz = ((Object)((Object)this)).getClass();
        currentThread.setContextClassLoader(clazz.getClassLoader());
        try {
            this._velocityEngine = new VelocityEngine();
            FastExtendedProperties extendedProperties = new FastExtendedProperties();
            extendedProperties.setProperty("directive.if.tostring.nullcheck", String.valueOf(_velocityEngineConfiguration.directiveIfToStringNullCheck()));
            extendedProperties.setProperty("eventhandler.methodexception.class", LiferayMethodExceptionEventHandler.class.getName());
            extendedProperties.setProperty("introspector.restrict.classes", StringUtil.merge((Object[])_velocityEngineConfiguration.restrictedClasses()));
            extendedProperties.setProperty("introspector.restrict.packages", StringUtil.merge((Object[])_velocityEngineConfiguration.restrictedPackages()));
            extendedProperties.setProperty("parser.pool.class", VelocityParserPool.class.getName());
            extendedProperties.setProperty("resource.loader", "liferay");
            extendedProperties.setProperty(StringBundler.concat((String[])new String[]{"liferay.", "resource.loader", ".", VelocityTemplateResourceLoader.class.getName()}), this.templateResourceLoader);
            boolean cacheEnabled = false;
            if (_velocityEngineConfiguration.resourceModificationCheckInterval() != 0) {
                cacheEnabled = true;
            }
            extendedProperties.setProperty("liferay.resource.loader.cache", String.valueOf(cacheEnabled));
            extendedProperties.setProperty("liferay.resource.loader.class", LiferayResourceLoader.class.getName());
            extendedProperties.setProperty("liferay.resource.loader.resourceModificationCheckInterval", _velocityEngineConfiguration.resourceModificationCheckInterval() + "");
            extendedProperties.setProperty("resource.manager.class", LiferayResourceManager.class.getName());
            extendedProperties.setProperty("liferay.resource.manager.class.resourceModificationCheckInterval", _velocityEngineConfiguration.resourceModificationCheckInterval() + "");
            extendedProperties.setProperty(VelocityTemplateResourceLoader.class.getName(), this.templateResourceLoader);
            extendedProperties.setProperty("runtime.log.logsystem.class", _velocityEngineConfiguration.logger());
            extendedProperties.setProperty("runtime.log.logsystem.log4j.category", _velocityEngineConfiguration.loggerCategory());
            extendedProperties.setProperty("runtime.introspector.uberspect", SecureUberspector.class.getName());
            extendedProperties.setProperty("velocimacro.library", StringUtil.merge((Object[])_velocityEngineConfiguration.velocimacroLibrary()));
            extendedProperties.setProperty("velocimacro.library.autoreload", String.valueOf(!cacheEnabled));
            extendedProperties.setProperty("velocimacro.permissions.allow.inline.to.replace.global", String.valueOf(!cacheEnabled));
            this._velocityEngine.setExtendedProperties((ExtendedProperties)extendedProperties);
            this._velocityEngine.init();
        }
        catch (Exception e) {
            throw new TemplateException((Throwable)e);
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    @Reference(service=VelocityTemplateContextHelper.class, unbind="-")
    public void setTemplateContextHelper(TemplateContextHelper templateContextHelper) {
        super.setTemplateContextHelper(templateContextHelper);
    }

    @Reference(service=VelocityTemplateResourceLoader.class, unbind="-")
    public void setTemplateResourceLoader(TemplateResourceLoader templateResourceLoader) {
        super.setTemplateResourceLoader(templateResourceLoader);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        _velocityEngineConfiguration = (VelocityEngineConfiguration)ConfigurableUtil.createConfigurable(VelocityEngineConfiguration.class, properties);
    }

    protected Template doGetTemplate(TemplateResource templateResource, TemplateResource errorTemplateResource, boolean restricted, Map<String, Object> helperUtilities, boolean privileged) {
        VelocityTemplate template = new VelocityTemplate(templateResource, errorTemplateResource, helperUtilities, this._velocityEngine, this.templateContextHelper, _velocityEngineConfiguration.resourceModificationCheckInterval(), privileged);
        if (restricted) {
            template = new RestrictedTemplate((Template)template, this.templateContextHelper.getRestrictedVariables());
        }
        return template;
    }

    @Reference(unbind="-")
    protected void setSingleVMPool(SingleVMPool singleVMPool) {
    }
}

