/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.velocity.internal;

import com.liferay.osgi.util.StringPlus;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.SingleVMPoolUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceLoader;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.template.TemplateResourceThreadLocal;
import com.liferay.portal.template.velocity.internal.FastExtendedProperties;
import com.liferay.portal.template.velocity.internal.LiferayResourceLoader;
import com.liferay.portal.template.velocity.internal.VelocityTemplateResourceLoader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.Template;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeInstance;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.ResourceManagerImpl;

public class LiferayResourceManager
extends ResourceManagerImpl {
    private List<String> _macroTemplateIds;
    private final PortalCache<TemplateResource, Object> _portalCache;
    private int _resourceModificationCheckInterval = 60;
    private TemplateResourceLoader _templateResourceLoader;

    public LiferayResourceManager() {
        String portalCacheName = TemplateResource.class.getName();
        portalCacheName = portalCacheName.concat("#").concat("vm");
        this._portalCache = SingleVMPoolUtil.getPortalCache((String)portalCacheName);
    }

    public String getLoaderNameForResource(String source) {
        if (this.globalCache.get((Object)(2 + source)) != null || this.globalCache.get((Object)(1 + source)) != null) {
            return LiferayResourceLoader.class.getName();
        }
        return super.getLoaderNameForResource(source);
    }

    public Resource getResource(String resourceName, int resourceType, String encoding) throws Exception, ParseErrorException, ResourceNotFoundException {
        for (String macroTemplateId : this._macroTemplateIds) {
            if (!resourceName.equals(macroTemplateId)) continue;
            try {
                return AccessController.doPrivileged(new ResourcePrivilegedExceptionAction(resourceName, resourceType, encoding));
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
        return this._getResource(resourceName, resourceType, encoding);
    }

    public synchronized void initialize(RuntimeServices runtimeServices) throws Exception {
        ExtendedProperties extendedProperties = runtimeServices.getConfiguration();
        Field field = ReflectionUtil.getDeclaredField(RuntimeInstance.class, (String)"configuration");
        field.set(runtimeServices, (Object)new FastExtendedProperties(extendedProperties));
        this._macroTemplateIds = StringPlus.asList((Object)extendedProperties.get((Object)"velocimacro.library"));
        this._resourceModificationCheckInterval = GetterUtil.getInteger((Object)extendedProperties.get((Object)"liferay.resource.loader.resourceModificationCheckInterval"), (int)60);
        this._templateResourceLoader = (TemplateResourceLoader)extendedProperties.get((Object)VelocityTemplateResourceLoader.class.getName());
        super.initialize(runtimeServices);
    }

    private Template _createTemplate(TemplateResource templateResource) throws IOException {
        LiferayTemplate template = new LiferayTemplate(templateResource);
        template.setEncoding("UTF-8");
        template.setName(templateResource.getTemplateId());
        template.setResourceLoader(new LiferayResourceLoader());
        template.setRuntimeServices(this.rsvc);
        template.process();
        return template;
    }

    private Resource _getResource(String resourceName, int resourceType, String encoding) throws Exception, ParseErrorException, ResourceNotFoundException {
        if (resourceType != 1) {
            return super.getResource(resourceName, resourceType, encoding);
        }
        TemplateResource templateResource = null;
        templateResource = resourceName.startsWith("TEMPLATE_RESOURCE_UUID") ? TemplateResourceThreadLocal.getTemplateResource((String)"vm") : this._templateResourceLoader.getTemplateResource(resourceName);
        if (templateResource == null) {
            throw new ResourceNotFoundException("Unable to find Velocity template with ID " + resourceName);
        }
        Object object = this._portalCache.get((Serializable)templateResource);
        if (object != null && object instanceof Template) {
            return (Template)object;
        }
        Template template = this._createTemplate(templateResource);
        if (this._resourceModificationCheckInterval != 0) {
            this._portalCache.put((Serializable)templateResource, (Object)template);
        }
        return template;
    }

    private class ResourcePrivilegedExceptionAction
    implements PrivilegedExceptionAction<Resource> {
        private final String _encoding;
        private final String _resourceName;
        private final int _resourceType;

        public ResourcePrivilegedExceptionAction(String resourceName, int resourceType, String encoding) {
            this._resourceName = resourceName;
            this._resourceType = resourceType;
            this._encoding = encoding;
        }

        @Override
        public Resource run() throws Exception {
            return LiferayResourceManager.this._getResource(this._resourceName, this._resourceType, this._encoding);
        }
    }

    private static class LiferayTemplate
    extends Template {
        private final TemplateResource _templateResource;

        public LiferayTemplate(TemplateResource templateResource) {
            this._templateResource = templateResource;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean process() throws IOException, ParseErrorException {
            this.data = null;
            try (Reader reader = this._templateResource.getReader();){
                this.data = this.rsvc.parse(reader, this.name);
                this.initDocument();
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                ParseErrorException pee = new ParseErrorException("Unable to parse Velocity template");
                pee.addSuppressed((Throwable)e);
                throw pee;
            }
        }
    }
}

