/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.store.safe.file.name.wrapper.internal;

import com.liferay.document.library.kernel.store.Store;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import java.io.File;
import java.io.InputStream;

public abstract class SafeFileNameStore
implements Store {
    public static final int SERVICE_RANKING = 200;
    protected volatile Store store;
    private static final Log _log = LogFactoryUtil.getLog(SafeFileNameStore.class);

    public void addDirectory(long companyId, long repositoryId, String dirName) {
        String safeDirName;
        block3: {
            safeDirName = FileUtil.encodeSafeFileName((String)dirName);
            if (!safeDirName.equals(dirName)) {
                try {
                    this.store.move(dirName, safeDirName);
                }
                catch (Exception e) {
                    if (!_log.isDebugEnabled()) break block3;
                    _log.debug((Object)e, (Throwable)e);
                }
            }
        }
        this.store.addDirectory(companyId, repositoryId, safeDirName);
    }

    public void addFile(long companyId, long repositoryId, String fileName, byte[] bytes) throws PortalException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        this.renameUnsafeFile(companyId, repositoryId, fileName, safeFileName);
        this.store.addFile(companyId, repositoryId, safeFileName, bytes);
    }

    public void addFile(long companyId, long repositoryId, String fileName, File file) throws PortalException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        this.renameUnsafeFile(companyId, repositoryId, fileName, safeFileName);
        this.store.addFile(companyId, repositoryId, safeFileName, file);
    }

    public void addFile(long companyId, long repositoryId, String fileName, InputStream is) throws PortalException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        this.renameUnsafeFile(companyId, repositoryId, fileName, safeFileName);
        this.store.addFile(companyId, repositoryId, safeFileName, is);
    }

    public void checkRoot(long companyId) {
        this.store.checkRoot(companyId);
    }

    public void copyFileToStore(long companyId, long repositoryId, String fileName, String versionLabel, Store targetStore) throws PortalException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        this.renameUnsafeFile(companyId, repositoryId, fileName, safeFileName);
        this.store.copyFileToStore(companyId, repositoryId, safeFileName, versionLabel, targetStore);
    }

    public void copyFileVersion(long companyId, long repositoryId, String fileName, String fromVersionLabel, String toVersionLabel) throws PortalException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        this.renameUnsafeFile(companyId, repositoryId, fileName, safeFileName);
        this.store.copyFileVersion(companyId, repositoryId, safeFileName, fromVersionLabel, toVersionLabel);
    }

    public void deleteDirectory(long companyId, long repositoryId, String dirName) {
        String safeDirName;
        block3: {
            safeDirName = FileUtil.encodeSafeFileName((String)dirName);
            if (!safeDirName.equals(dirName)) {
                try {
                    this.store.deleteDirectory(companyId, repositoryId, dirName);
                    return;
                }
                catch (Exception e) {
                    if (!_log.isDebugEnabled()) break block3;
                    _log.debug((Object)e, (Throwable)e);
                }
            }
        }
        this.store.deleteDirectory(companyId, repositoryId, safeDirName);
    }

    public void deleteFile(long companyId, long repositoryId, String fileName) {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (!safeFileName.equals(fileName) && this.store.hasFile(companyId, repositoryId, fileName)) {
            this.store.deleteFile(companyId, repositoryId, fileName);
            return;
        }
        this.store.deleteFile(companyId, repositoryId, safeFileName);
    }

    public void deleteFile(long companyId, long repositoryId, String fileName, String versionLabel) {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (!safeFileName.equals(fileName) && this.store.hasFile(companyId, repositoryId, fileName, versionLabel)) {
            this.store.deleteFile(companyId, repositoryId, fileName, versionLabel);
            return;
        }
        this.store.deleteFile(companyId, repositoryId, safeFileName, versionLabel);
    }

    public File getFile(long companyId, long repositoryId, String fileName) throws PortalException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (!safeFileName.equals(fileName) && this.store.hasFile(companyId, repositoryId, fileName)) {
            return this.store.getFile(companyId, repositoryId, fileName);
        }
        return this.store.getFile(companyId, repositoryId, safeFileName);
    }

    public File getFile(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (!safeFileName.equals(fileName) && this.store.hasFile(companyId, repositoryId, fileName, versionLabel)) {
            return this.store.getFile(companyId, repositoryId, fileName, versionLabel);
        }
        return this.store.getFile(companyId, repositoryId, safeFileName, versionLabel);
    }

    public byte[] getFileAsBytes(long companyId, long repositoryId, String fileName) throws PortalException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (!safeFileName.equals(fileName) && this.store.hasFile(companyId, repositoryId, fileName)) {
            return this.store.getFileAsBytes(companyId, repositoryId, fileName);
        }
        return this.store.getFileAsBytes(companyId, repositoryId, safeFileName);
    }

    public byte[] getFileAsBytes(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (!safeFileName.equals(fileName) && this.store.hasFile(companyId, repositoryId, fileName, versionLabel)) {
            return this.store.getFileAsBytes(companyId, repositoryId, fileName, versionLabel);
        }
        return this.store.getFileAsBytes(companyId, repositoryId, safeFileName, versionLabel);
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName) throws PortalException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (!safeFileName.equals(fileName) && this.store.hasFile(companyId, repositoryId, fileName)) {
            return this.store.getFileAsStream(companyId, repositoryId, fileName);
        }
        return this.store.getFileAsStream(companyId, repositoryId, safeFileName);
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (!safeFileName.equals(fileName) && this.store.hasFile(companyId, repositoryId, fileName, versionLabel)) {
            return this.store.getFileAsStream(companyId, repositoryId, fileName, versionLabel);
        }
        return this.store.getFileAsStream(companyId, repositoryId, safeFileName, versionLabel);
    }

    public String[] getFileNames(long companyId, long repositoryId) {
        String[] fileNames = this.store.getFileNames(companyId, repositoryId);
        String[] decodedFileNames = new String[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            decodedFileNames[i] = FileUtil.decodeSafeFileName((String)fileNames[i]);
        }
        return decodedFileNames;
    }

    public String[] getFileNames(long companyId, long repositoryId, String dirName) {
        String safeDirName;
        block4: {
            safeDirName = FileUtil.encodeSafeFileName((String)dirName);
            if (!safeDirName.equals(dirName)) {
                try {
                    this.store.move(dirName, safeDirName);
                }
                catch (Exception e) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Object)e, (Throwable)e);
                }
            }
        }
        String[] fileNames = this.store.getFileNames(companyId, repositoryId, safeDirName);
        String[] decodedFileNames = new String[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            decodedFileNames[i] = FileUtil.decodeSafeFileName((String)fileNames[i]);
        }
        return decodedFileNames;
    }

    public long getFileSize(long companyId, long repositoryId, String fileName) throws PortalException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (!safeFileName.equals(fileName) && this.store.hasFile(companyId, repositoryId, fileName)) {
            return this.store.getFileSize(companyId, repositoryId, fileName);
        }
        return this.store.getFileSize(companyId, repositoryId, safeFileName);
    }

    public boolean hasDirectory(long companyId, long repositoryId, String dirName) {
        String safeDirName = FileUtil.encodeSafeFileName((String)dirName);
        return this.store.hasDirectory(companyId, repositoryId, safeDirName);
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName) {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (!safeFileName.equals(fileName) && this.store.hasFile(companyId, repositoryId, fileName)) {
            return true;
        }
        return this.store.hasFile(companyId, repositoryId, safeFileName);
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName, String versionLabel) {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (!safeFileName.equals(fileName) && this.store.hasFile(companyId, repositoryId, fileName, versionLabel)) {
            return true;
        }
        return this.store.hasFile(companyId, repositoryId, safeFileName, versionLabel);
    }

    public void move(String srcDir, String destDir) {
        this.store.move(srcDir, destDir);
    }

    public void moveFileToStore(long companyId, long repositoryId, String fileName, String versionLabel, Store targetStore) throws PortalException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        this.renameUnsafeFile(companyId, repositoryId, fileName, safeFileName);
        this.store.moveFileToStore(companyId, repositoryId, safeFileName, versionLabel, targetStore);
    }

    public void updateFile(long companyId, long repositoryId, long newRepositoryId, String fileName) throws PortalException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        this.renameUnsafeFile(companyId, repositoryId, fileName, safeFileName);
        this.store.updateFile(companyId, repositoryId, newRepositoryId, safeFileName);
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String newFileName) throws PortalException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        String safeNewFileName = FileUtil.encodeSafeFileName((String)newFileName);
        if (!safeFileName.equals(fileName) && this.store.hasFile(companyId, repositoryId, fileName, "1.0")) {
            safeFileName = fileName;
        }
        this.store.updateFile(companyId, repositoryId, safeFileName, safeNewFileName);
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String versionLabel, byte[] bytes) throws PortalException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        this.renameUnsafeFile(companyId, repositoryId, fileName, safeFileName);
        this.store.updateFile(companyId, repositoryId, safeFileName, versionLabel, bytes);
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String versionLabel, File file) throws PortalException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        this.renameUnsafeFile(companyId, repositoryId, fileName, safeFileName);
        this.store.updateFile(companyId, repositoryId, safeFileName, versionLabel, file);
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String versionLabel, InputStream is) throws PortalException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        this.renameUnsafeFile(companyId, repositoryId, fileName, safeFileName);
        this.store.updateFile(companyId, repositoryId, safeFileName, versionLabel, is);
    }

    public void updateFileVersion(long companyId, long repositoryId, String fileName, String fromVersionLabel, String toVersionLabel) throws PortalException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        this.renameUnsafeFile(companyId, repositoryId, fileName, safeFileName);
        this.store.updateFileVersion(companyId, repositoryId, safeFileName, fromVersionLabel, toVersionLabel);
    }

    protected void renameUnsafeFile(long companyId, long repositoryId, String fileName, String safeFileName) throws PortalException {
        if (!safeFileName.equals(fileName) && this.store.hasFile(companyId, repositoryId, fileName, "1.0")) {
            this.store.updateFile(companyId, repositoryId, fileName, safeFileName);
        }
    }
}

