/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.facebook.connect.internal.verify;

import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.settings.SettingsFactory;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.PrefsProps;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.facebook.connect.constants.LegacyFacebookConnectPropsKeys;
import com.liferay.portal.verify.BaseCompanySettingsVerifyProcess;
import com.liferay.portal.verify.VerifyProcess;
import java.util.Dictionary;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"verify.process.name=com.liferay.portal.security.sso.facebook.connect"}, service={VerifyProcess.class})
public class FacebookConnectCompanySettingsVerifyProcess
extends BaseCompanySettingsVerifyProcess {
    private CompanyLocalService _companyLocalService;
    private PrefsProps _prefsProps;
    private SettingsFactory _settingsFactory;

    protected CompanyLocalService getCompanyLocalService() {
        return this._companyLocalService;
    }

    protected Set<String> getLegacyPropertyKeys() {
        return SetUtil.fromArray((Object[])LegacyFacebookConnectPropsKeys.FACEBOOK_CONNECT_KEYS);
    }

    protected Dictionary<String, String> getPropertyValues(long companyId) {
        HashMapDictionary dictionary = new HashMapDictionary();
        dictionary.put("enabled", this._prefsProps.getString(companyId, "facebook.auth.enabled", "false"));
        dictionary.put("appId", this._prefsProps.getString(companyId, "facebook.connect.app.id", ""));
        dictionary.put("appSecret", this._prefsProps.getString(companyId, "facebook.connect.app.secret", ""));
        dictionary.put("graphURL", this._prefsProps.getString(companyId, "facebook.connect.graph.url", ""));
        dictionary.put("oauthAuthURL", this._prefsProps.getString(companyId, "facebook.connect.oauth.auth.url", ""));
        dictionary.put("oauthRedirectURL", this.upgradeLegacyRedirectURI(this._prefsProps.getString(companyId, "facebook.connect.oauth.redirect.url", "")));
        dictionary.put("oauthTokenURL", this._prefsProps.getString(companyId, "facebook.connect.oauth.token.url", ""));
        dictionary.put("verifiedAccountRequired", this._prefsProps.getString(companyId, "facebook.connect.verified.account.required", "false"));
        return dictionary;
    }

    protected SettingsFactory getSettingsFactory() {
        return this._settingsFactory;
    }

    protected String getSettingsId() {
        return "com.liferay.portal.security.sso.facebook.connect";
    }

    @Reference(unbind="-")
    protected void setCompanyLocalService(CompanyLocalService companyLocalService) {
        this._companyLocalService = companyLocalService;
    }

    @Reference(unbind="-")
    protected void setPrefsProps(PrefsProps prefsProps) {
        this._prefsProps = prefsProps;
    }

    @Reference(unbind="-")
    protected void setSettingsFactory(SettingsFactory settingsFactory) {
        this._settingsFactory = settingsFactory;
    }

    protected String upgradeLegacyRedirectURI(String legacyRedirectURI) {
        if (Validator.isNull((String)legacyRedirectURI)) {
            return legacyRedirectURI;
        }
        return legacyRedirectURI.replaceFirst("/c/login/facebook_connect_oauth", "/c/portal/facebook_connect_oauth");
    }
}

