/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.facebook.connect.internal;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.facebook.FacebookConnect;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.facebook.connect.configuration.FacebookConnectConfiguration;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.security.sso.facebook.connect.configuration.FacebookConnectConfiguration"}, immediate=true, service={FacebookConnect.class})
public class FacebookConnectImpl
implements FacebookConnect {
    private static final Log _log = LogFactoryUtil.getLog(FacebookConnectImpl.class);
    private ConfigurationProvider _configurationProvider;

    public String getAccessToken(long companyId, String redirect, String code) {
        FacebookConnectConfiguration facebookConnectConfiguration = this.getFacebookConnectConfiguration(companyId);
        String url = HttpUtil.addParameter((String)facebookConnectConfiguration.oauthTokenURL(), (String)"client_id", (String)facebookConnectConfiguration.appId());
        String facebookConnectRedirectURL = facebookConnectConfiguration.oauthRedirectURL();
        url = HttpUtil.addParameter((String)url, (String)"redirect_uri", (String)facebookConnectRedirectURL);
        facebookConnectRedirectURL = HttpUtil.addParameter((String)facebookConnectRedirectURL, (String)"redirect", (String)redirect);
        url = HttpUtil.addParameter((String)url, (String)"redirect_uri", (String)facebookConnectRedirectURL);
        url = HttpUtil.addParameter((String)url, (String)"client_secret", (String)facebookConnectConfiguration.appSecret());
        url = HttpUtil.addParameter((String)url, (String)"code", (String)code);
        Http.Options options = new Http.Options();
        options.setLocation(url);
        options.setPost(true);
        try {
            int x;
            String content = HttpUtil.URLtoString((Http.Options)options);
            if (Validator.isNotNull((String)content) && (x = content.indexOf("access_token=")) >= 0) {
                int y = content.indexOf(38, x);
                if (y < x) {
                    y = content.length();
                }
                return content.substring(x + 13, y);
            }
        }
        catch (Exception e) {
            throw new SystemException("Unable to retrieve Facebook access token", (Throwable)e);
        }
        return null;
    }

    public String getAccessTokenURL(long companyId) {
        FacebookConnectConfiguration facebookConnectConfiguration = this.getFacebookConnectConfiguration(companyId);
        return facebookConnectConfiguration.oauthTokenURL();
    }

    public String getAppId(long companyId) {
        FacebookConnectConfiguration facebookConnectConfiguration = this.getFacebookConnectConfiguration(companyId);
        return facebookConnectConfiguration.appId();
    }

    public String getAppSecret(long companyId) {
        FacebookConnectConfiguration facebookConnectConfiguration = this.getFacebookConnectConfiguration(companyId);
        return facebookConnectConfiguration.appSecret();
    }

    public String getAuthURL(long companyId) {
        FacebookConnectConfiguration facebookConnectConfiguration = this.getFacebookConnectConfiguration(companyId);
        return facebookConnectConfiguration.oauthAuthURL();
    }

    public JSONObject getGraphResources(long companyId, String path, String accessToken, String fields) {
        try {
            String url = HttpUtil.addParameter((String)this.getGraphURL(companyId).concat(path), (String)"access_token", (String)accessToken);
            if (Validator.isNotNull((String)fields)) {
                url = HttpUtil.addParameter((String)url, (String)"fields", (String)fields);
            }
            Http.Options options = new Http.Options();
            options.setLocation(url);
            String json = HttpUtil.URLtoString((Http.Options)options);
            return JSONFactoryUtil.createJSONObject((String)json);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e, (Throwable)e);
            }
            return null;
        }
    }

    public String getGraphURL(long companyId) {
        FacebookConnectConfiguration facebookConnectConfiguration = this.getFacebookConnectConfiguration(companyId);
        return facebookConnectConfiguration.graphURL();
    }

    public String getProfileImageURL(PortletRequest portletRequest) {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        HttpSession session = (request = PortalUtil.getOriginalServletRequest((HttpServletRequest)request)).getSession();
        String facebookId = (String)session.getAttribute("FACEBOOK_USER_ID");
        if (Validator.isNull((String)facebookId)) {
            return null;
        }
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        String token = (String)session.getAttribute("FACEBOOK_ACCESS_TOKEN");
        JSONObject jsonObject = this.getGraphResources(companyId, "/me", token, "id,picture");
        return jsonObject.getString("picture");
    }

    public String getRedirectURL(long companyId) {
        FacebookConnectConfiguration facebookConnectConfiguration = this.getFacebookConnectConfiguration(companyId);
        return facebookConnectConfiguration.oauthRedirectURL();
    }

    public boolean isEnabled(long companyId) {
        FacebookConnectConfiguration facebookConnectConfiguration = this.getFacebookConnectConfiguration(companyId);
        return facebookConnectConfiguration.enabled();
    }

    public boolean isVerifiedAccountRequired(long companyId) {
        FacebookConnectConfiguration facebookConnectConfiguration = this.getFacebookConnectConfiguration(companyId);
        return facebookConnectConfiguration.verifiedAccountRequired();
    }

    protected FacebookConnectConfiguration getFacebookConnectConfiguration(long companyId) {
        try {
            FacebookConnectConfiguration facebookConnectCompanyServiceSettings = (FacebookConnectConfiguration)this._configurationProvider.getConfiguration(FacebookConnectConfiguration.class, (SettingsLocator)new CompanyServiceSettingsLocator(companyId, "com.liferay.portal.security.sso.facebook.connect"));
            return facebookConnectCompanyServiceSettings;
        }
        catch (ConfigurationException ce) {
            _log.error((Object)"Unable to get Facebook Connect configuration", (Throwable)ce);
            return null;
        }
    }

    @Reference(unbind="-")
    protected void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this._configurationProvider = configurationProvider;
    }
}

